<div class="content">
    <!-- Page Header -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="<?php echo e(route('admin.staff-list')); ?>" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i><?php echo e($userIdBeingEdited ? 'Edit Staff' : 'Add New Staff'); ?>

                    </a>
                </h6>
            </div>
            <!-- Page header end -->

            <!-- Card start -->
            <div class="card">
                <div class="card-body pb-0">
                    <div id="staff-form" class="form">
                        <h6 class="fw-bold mb-3">Staff Information</h6>

                        <div class="row">
                            <!-- Profile Image -->
                            <div class="col-lg-12">
                                <div class="mb-3 d-flex align-items-center">
                                    <label class="form-label mb-0 fw-medium">Profile Image</label>
                                    <div class="position-relative ms-4">
                                        <div
                                            class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 p-0">
                                            <!--[if BLOCK]><![endif]--><?php if($profileImage): ?>
                                                <img src="<?php echo e($profileImage->temporaryUrl()); ?>" alt="Preview"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            <?php elseif($currentProfileImage): ?>
                                                <img src="<?php echo e(Storage::url($currentProfileImage)); ?>" alt="Current Profile"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            <?php else: ?>
                                                <i class="ti ti-user-plus fs-16"></i>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                            <input type="file" wire:model="profileImage"
                                                class="position-absolute top-0 start-0 w-100 h-100 opacity-0 cursor-pointer"
                                                accept="image/*" x-data="" x-on:change="
                                                    if ($el.files[0].size > 2097152) { // 2MB in bytes
                                                        alert('File size must be less than 2MB');
                                                        $el.value = '';
                                                    }
                                                ">

                                            <div
                                                class="position-absolute bottom-0 end-0 start-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center z-n1">
                                                <a href="javascript:void(0);"
                                                    class="text-white d-flex align-items-center justify-content-center">
                                                    <i class="ti ti-photo fs-14"></i>
                                                </a>
                                            </div>
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php if($profileImage || $currentProfileImage): ?>
                                            <button type="button" wire:click="$set('profileImage', null)"
                                                class="btn btn-sm btn-danger position-absolute top-0 end-0 rounded-circle p-1"
                                                style="transform: translate(50%, -25%);">
                                                <i class="ti ti-x fs-12"></i>
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['profileImage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->

                                <div wire:loading wire:target="profileImage" class="text-info small">
                                    <i class="spinner-border spinner-border-sm me-1"></i>
                                    Uploading image...
                                </div>
                            </div>

                            <!-- Staff Mode Selection -->
                            <!--[if BLOCK]><![endif]--><?php if(!$userIdBeingEdited): ?>
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label class="form-label mb-1 fw-medium d-block">Staff Selection Mode</label>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" name="staffMode" class="form-check-input" id="createMode"
                                                wire:click="toggleStaffMode('create')" value="create"
                                                <?php if($staffMode === 'create'): echo 'checked'; endif; ?>>
                                            <label class="form-check-label" for="createMode">Create New Staff</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" name="staffMode" class="form-check-input" id="selectMode"
                                                wire:click="toggleStaffMode('select')" value="select"
                                                <?php if($staffMode === 'select'): echo 'checked'; endif; ?>>
                                            <label class="form-check-label" for="selectMode">Select Existing User</label>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Existing User Selection -->
                            <!--[if BLOCK]><![endif]--><?php if($staffMode === 'select'): ?>
                                <div class="col-md-12" x-data="{ dropdownOpen: <?php if ((object) ('dropdownVisible') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('dropdownVisible'->value()); ?>')<?php echo e('dropdownVisible'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('dropdownVisible'); ?>')<?php endif; ?> }">
                                    <div class="mb-3">
                                        <label class="form-label mb-1 fw-medium">Select User<span
                                                class="text-danger ms-1">*</span></label>

                                        <div class="position-relative">
                                            <input type="text" class="form-control" placeholder="Search users..."
                                                wire:model.live.debounce.300ms="searchTerm"
                                                @focus="$wire.set('dropdownVisible', true)"
                                                @click.away="$wire.set('dropdownVisible', false)">

                                            <!--[if BLOCK]><![endif]--><?php if($dropdownVisible && count($existingUsers) > 0): ?>
                                                <div class="mt-1 dropdown-menu d-block position-absolute w-100 bg-white"
                                                    style="z-index: 1000; max-height: 300px; overflow-y: auto;">
                                                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $existingUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <button type="button" class="dropdown-item d-flex justify-content-between"
                                                            wire:click="selectUser(<?php echo e($user->id); ?>)">
                                                            <span><?php echo e($user->name); ?></span>
                                                            <small class="text-muted"><?php echo e($user->email); ?></small>
                                                        </button>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <div class="dropdown-item text-muted">No users found</div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php if($selectedExistingUser): ?>
                                                                            <?php
                                                                                $selectedUser = \App\Models\User::find($selectedExistingUser);
                                                                            ?>
                                             <div
                                                                                class="p-2 mt-2 rounded bg-light d-flex justify-content-between align-items-center">
                                                                                <div>
                                                                                    <strong>Selected:</strong> <?php echo e($selectedUser->name); ?>

                                                                                    <br>
                                                                                    <small class="text-muted"><?php echo e($selectedUser->email); ?></small>
                                                                                </div>
                                                                                <button type="button" class="btn btn-sm btn-outline-danger"
                                                                                    wire:click="$set('selectedExistingUser', null)">
                                                                                    <i class="fas fa-times"></i> Clear
                                                                                </button>
                                                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedExistingUser'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Name and Email Fields -->
                            <!--[if BLOCK]><![endif]--><?php if($staffMode === 'create' || $userIdBeingEdited): ?>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="name" class="form-label mb-1 fw-medium">Full Name<span
                                                class="text-danger ms-1">*</span></label>
                                        <input wire:model="name" type="text" id="name" class="form-control"
                                            placeholder="John Doe" <?php echo e($staffMode === 'select' && $selectedExistingUser ? 'readonly' : ''); ?>>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label mb-1 fw-medium">Email Address<span
                                                class="text-danger ms-1">*</span></label>
                                        <input wire:model="email" type="email" id="email" class="form-control"
                                            placeholder="example@email.com" <?php echo e($staffMode === 'select' && $selectedExistingUser ? 'readonly' : ''); ?>>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="phone_number" class="form-label mb-1 fw-medium">Phone Number<span
                                                class="text-danger ms-1">*</span></label>
                                        <input wire:model="phone_number" type="text" id="phone_number" class="form-control"
                                            placeholder="+1234567890">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>

                                <!-- Password fields only for create mode -->
                                <!--[if BLOCK]><![endif]--><?php if($staffMode === 'create' || $userIdBeingEdited): ?>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="password" class="form-label mb-1 fw-medium">
                                                Password
                                                <!--[if BLOCK]><![endif]--><?php if($userIdBeingEdited): ?>
                                                    <small class="text-muted">(Leave blank to keep current)</small>
                                                <?php else: ?>
                                                    <span class="text-danger ms-1">*</span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </label>
                                            <input wire:model="password" type="password" id="password" class="form-control"
                                                placeholder="<?php echo e($userIdBeingEdited ? 'Leave blank to keep current' : 'Password'); ?>">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="password_confirmation" class="form-label mb-1 fw-medium">Confirm
                                                Password</label>
                                            <input wire:model="password_confirmation" type="password" id="password_confirmation"
                                                class="form-control" placeholder="Confirm Password">
                                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Status -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label mb-1 fw-medium">Status<span
                                            class="text-danger ms-1">*</span></label>
                                    <div class="mt-2">
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" wire:model="status"
                                                id="statusActive" value="active">
                                            <label class="form-check-label" for="statusActive">Active</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" wire:model="status"
                                                id="statusInactive" value="inactive">
                                            <label class="form-check-label" for="statusInactive">Inactive</label>
                                        </div>
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>

                        <!-- Password Note for new staff -->
                        <!--[if BLOCK]><![endif]--><?php if($staffMode === 'create' && !$userIdBeingEdited): ?>
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i>
                                <strong>Note:</strong> A password is required for new staff. They can change it later
                                through their profile.
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Assignment Note for existing users -->
                        <!--[if BLOCK]><![endif]--><?php if($staffMode === 'select' && !$userIdBeingEdited): ?>
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle"></i>
                                <strong>Note:</strong> This will assign the selected user as staff to the chosen clinic and
                                doctor. They will receive an email notification.
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <!-- Card end -->

            <div class="d-flex align-items-center justify-content-end mt-3">
                <button type="button" wire:click="resetForm" class="btn btn-light me-2">
                    <i class="ti ti-refresh"></i> Reset Form
                </button>
                <button wire:click="save" wire:loading.attr="disabled" class="btn btn-primary">
                    <span wire:loading.remove>
                        <!--[if BLOCK]><![endif]--><?php if($userIdBeingEdited): ?>
                            <i class="ti ti-device-floppy"></i> Update Staff
                        <?php elseif($staffMode === 'select'): ?>
                            <i class="ti ti-user-plus"></i> Assign as Staff
                        <?php else: ?>
                            <i class="ti ti-plus"></i> Add New Staff
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </span>
                    <span wire:loading>
                        <i class="ti ti-loader fa-spin"></i> Processing...
                    </span>
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('scroll-to-form', () => {
                document.getElementById('staff-form').scrollIntoView({
                    behavior: 'smooth'
                });
            });

            // Handle clicking outside dropdown to close it
            document.addEventListener('click', function (event) {
                const dropdown = document.querySelector('.dropdown-menu');
                const input = document.querySelector('input[placeholder="Search users..."]');

                if (dropdown && input && !dropdown.contains(event.target) && !input.contains(event.target)) {
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('dropdownVisible', false);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /var/www/predcare/resources/views/livewire/admin/staff/staff-management.blade.php ENDPATH**/ ?>