<!-- Start Content -->
<div class="content pb-0">

    <!-- Profile Header Card -->
    <div class="card">
        <div class="card-body d-flex align-items-center justify-content-between flex-wrap row-gap-3">
            <div class="d-flex align-items-center flex-sm-nowrap flex-wrap row-gap-3">
                <div class="me-3 doctor-profile-img">
                    <a href="#">
                        <!--[if BLOCK]><![endif]--><?php if($doctor->profile_image): ?>
                            <img src="<?php echo e(Storage::url($doctor->profile_image)); ?>" class="rounded" alt="Profile Image"
                                style="width: 80px; height: 80px; object-fit: cover;">
                        <?php else: ?>
                            <div class="avatar avatar-xxxl <?php echo e($this->getAvatarColorClass(Auth::user()->name)); ?> rounded d-flex align-items-center justify-content-center text-white"
                                style="font-size: 2rem;">
                                <?php echo e($this->getInitials(Auth::user()->name)); ?>

                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </a>
                </div>
                <div class="flex-fill">
                    <div class="d-flex align-items-center mb-1">
                        <h6 class="mb-0 fw-semibold"><?php echo e(Auth::user()->name); ?></h6>
                        <span class="badge border bg-white text-dark fw-medium ms-2">
                            <i
                                class="ti ti-point-filled me-1 text-info"></i><?php echo e($doctor->specialization ?? 'Specialization'); ?>

                        </span>
                    </div>
                    <span class="d-block mb-3 fs-13">
                        <!--[if BLOCK]><![endif]--><?php if(count($educations) > 0): ?>
                            <?php echo e($educations->first()->degree ?? 'Medical Degree'); ?>

                        <?php else: ?>
                            Medical Professional
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </span>
                    <div class="d-flex align-items-center">
                        <p class="mb-0 fs-13"><i class="ti ti-building-hospital me-1"></i>Employee ID :
                            DR-<?php echo e(str_pad(Auth::id(), 4, '0', STR_PAD_LEFT)); ?></p>
                        <!--[if BLOCK]><![endif]--><?php if($doctor->verification_status === 'verified'): ?>
                            <span class="badge badge-soft-success fw-medium ms-2"><i
                                    class="ti ti-point-filled me-1 text-success"></i>Verified</span>
                        <?php elseif($doctor->verification_status === 'pending'): ?>
                            <span class="badge badge-soft-warning fw-medium ms-2"><i
                                    class="ti ti-point-filled me-1 text-warning"></i>Pending</span>
                        <?php else: ?>
                            <span class="badge badge-soft-secondary fw-medium ms-2"><i
                                    class="ti ti-point-filled me-1 text-secondary"></i>Not Verified</span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
            <div>
                <p class="mb-2">Years of Experience</p>
                <h6 class="fs-18 fw-bold mb-3"><?php echo e($doctor->years_of_experience ?? '0'); ?> <span
                        class="fw-normal text-body fs-14">Years</span></h6>
                <a href="#" class="btn btn-primary"><i class="ti ti-calendar-event me-1"></i>Book Appointment</a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div>
                <!-- Bio Section -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">About Me</h5>
                        <p><?php echo e($doctor->bio ?? 'No bio information available.'); ?></p>
                    </div>
                </div>

                <!-- Education Information -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="fw-bold mb-3">Education Information</h5>
                        <!--[if BLOCK]><![endif]--><?php if(count($educations) > 0): ?>
                            <ul class="activity-feed rounded">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="feed-item timeline-item">
                                        <h6 class="fw-bold mb-2"><?php echo e($education->institution ?? 'N/A'); ?> -
                                            <?php echo e($education->degree ?? 'N/A'); ?></h6>
                                        <p><?php echo e($education->start_year ?? 'N/A'); ?> -
                                            <?php echo e($education->end_year ?? 'Present'); ?></p>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </ul>
                        <?php else: ?>
                            <p>No education information available.</p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>

                <!-- Experience -->
                <!--[if BLOCK]><![endif]--><?php if(count($experiences) > 0): ?>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="fw-bold mb-3">Professional Experience</h5>
                            <ul class="activity-feed rounded">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="feed-item timeline-item">
                                        <h6 class="fw-bold mb-2"><?php echo e($experience->position ?? 'N/A'); ?></h6>
                                        <!--[if BLOCK]><![endif]--><?php if($experience->organization): ?>
                                            <div class="mb-1"><?php echo e($experience->organization); ?></div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <p>
                                            <!--[if BLOCK]><![endif]--><?php if($experience->start_date): ?>
                                                <?php echo e(\Carbon\Carbon::parse($experience->start_date)->format('M Y')); ?>

                                                -
                                                <!--[if BLOCK]><![endif]--><?php if(empty($experience->end_date)): ?>
                                                    Present
                                                <?php else: ?>
                                                    <?php echo e(\Carbon\Carbon::parse($experience->end_date)->format('M Y')); ?>

                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <?php else: ?>
                                                N/A
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </p>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </ul>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!-- Certificates -->
                <!--[if BLOCK]><![endif]--><?php if(count($uploadedCertificates) > 0): ?>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="fw-bold mb-3">Certifications</h5>
                            <div class="row">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $uploadedCertificates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $certificate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 mb-3">
                                        <div class="d-flex align-items-center mb-2">
                                            <span class="me-2"><i class="ti ti-award"></i></span>
                                            <h6 class="mb-0 fw-bold"><?php echo e($certificate['name']); ?></h6>
                                        </div>
                                        <p class="small text-muted mb-2">
                                            Uploaded:
                                            <?php echo e(\Carbon\Carbon::parse($certificate['uploaded_at'])->diffForHumans()); ?>

                                        </p>
                                        <a href="<?php echo e(Storage::url($certificate['path'])); ?>" target="_blank"
                                            class="btn btn-sm btn-primary">
                                            <i class="ti ti-eye me-1"></i> View Certificate
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

        <!-- Sidebar -->
        <div class="col-xl-4 theiaStickySidebar">
            <div class="card">
                <div class="card-body">
                    <h6 class="fw-bold mb-3">About</h6>
                    <div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-file"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Medical License Number</h6>
                                <p><?php echo e($doctor->license_number ?? 'N/A'); ?></p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-phone"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Phone Number</h6>
                                <p><?php echo e(Auth::user()->phone_number ?? 'N/A'); ?></p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-mail"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Email Address</h6>
                                <p><?php echo e(Auth::user()->email); ?></p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-user-check"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Years of Experience</h6>
                                <p><?php echo e($doctor->years_of_experience ?? '0'); ?> Years</p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-shield-check"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Verification Status</h6>
                                <p>
                                    <!--[if BLOCK]><![endif]--><?php if($doctor->verification_status === 'verified'): ?>
                                        <span class="badge bg-success">Verified</span>
                                        <!--[if BLOCK]><![endif]--><?php if($doctor->verified_at): ?>
                                            <small class="text-muted d-block">Verified on:
                                                <?php echo e($doctor->verified_at->format('M d, Y')); ?></small>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php elseif($doctor->verification_status === 'pending'): ?>
                                        <span class="badge bg-warning">Pending Verification</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Not Submitted</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </p>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <span class="avatar rounded-circle bg-light text-dark fs-16 flex-shrink-0 me-2"><i
                                    class="ti ti-id"></i></span>
                            <div>
                                <h6 class="fw-semibold fs-13 mb-1">Employee ID</h6>
                                <p>DR-<?php echo e(str_pad(Auth::id(), 4, '0', STR_PAD_LEFT)); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Content -->
<?php /**PATH /var/www/predcare/resources/views/livewire/doctor/profile/doctor-about-component.blade.php ENDPATH**/ ?>