<?php
    use App\Models\User;
    $isEditing = $staffId !== null;
?>

<div class="content">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="<?php echo e(route('doctor.staff.list')); ?>" class="text-dark">
                        <i class="ti ti-chevron-left me-1"></i><?php echo e($isEditing ? 'Edit Staff' : 'Add New Staff'); ?>

                    </a>
                </h6>
            </div>
            
            <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('message')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <?php if(session()->has('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <form wire:submit.prevent="save">
                <div class="card">
                    <div class="card-body">
                        <h6 class="fw-bold mb-3">Staff Information</h6>

                        <div class="row">
                            
                            <div class="col-lg-12 mb-4">
                                <div class="d-flex align-items-center">
                                    <label class="form-label mb-0 fw-medium">Profile Image</label>
                                    <div class="position-relative ms-4">
                                        <div
                                            class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 p-0">
                                            <!--[if BLOCK]><![endif]--><?php if($profileImage): ?>
                                                <img src="<?php echo e($profileImage->temporaryUrl()); ?>" alt="Preview"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            <?php elseif($currentProfileImage): ?>
                                                <img src="<?php echo e(Storage::url($currentProfileImage)); ?>"
                                                    alt="Current Profile"
                                                    class="w-100 h-100 object-fit-cover rounded-circle">
                                            <?php else: ?>
                                                <i class="ti ti-user-plus fs-16"></i>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                            <!--[if BLOCK]><![endif]--><?php if (! ($staffId)): ?>
                                                <input type="file" wire:model="profileImage"
                                                    class="position-absolute top-0 start-0 w-100 h-100 opacity-0 cursor-pointer"
                                                    accept="image/*" x-data
                                                    x-on:change="
                                                            if ($el.files[0].size > 2097152) {
                                                                alert('File size must be less than 2MB');
                                                                $el.value = '';
                                                            }
                                                        ">

                                                <div
                                                    class="position-absolute bottom-0 end-0 start-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center z-n1">
                                                    <span class="text-white"><i class="ti ti-photo fs-14"></i></span>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                        <!--[if BLOCK]><![endif]--><?php if (! ($staffId)): ?>
                                            <!--[if BLOCK]><![endif]--><?php if($profileImage || $currentProfileImage): ?>
                                                <button type="button" wire:click="$set('profileImage', null)"
                                                    class="btn btn-sm btn-danger position-absolute top-0 end-0 rounded-circle p-1"
                                                    style="transform: translate(50%, -25%);">
                                                    <i class="ti ti-x fs-12"></i>
                                                </button>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['profileImage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger small"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if (! ($staffId)): ?>
                                    <div wire:loading wire:target="profileImage" class="text-info small">
                                        <i class="spinner-border spinner-border-sm me-1"></i> Uploading image...
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Supervising Doctor <span class="text-danger">*</span></label>

                                <select class="form-select" wire:model="selectedDoctor"
                                    <?php if($staffId): ?> disabled <?php endif; ?>
                                    wire:key="doctor-select-<?php echo e($selectedDoctor); ?>">
                                    <option value="" >Select Doctor</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($doctor['id']); ?>"><?php echo e($doctor['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>

                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedDoctor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>


                            
                            <!--[if BLOCK]><![endif]--><?php if(!$staffId): ?>
                                <div class="mb-3 col-md-12">
                                    <label class="form-label d-block">Staff Selection Mode</label>
                                    <div class="form-check form-check-inline">
                                        <input type="radio" name="staffMode" class="form-check-input" id="createMode"
                                            wire:click="toggleStaffMode('create')" value="create"
                                            <?php if($staffMode === 'create'): echo 'checked'; endif; ?>>
                                        <label class="form-check-label" for="createMode">Create New Staff</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input type="radio" name="staffMode" class="form-check-input" id="selectMode"
                                            wire:click="toggleStaffMode('select')" value="select"
                                            <?php if($staffMode === 'select'): echo 'checked'; endif; ?>>
                                        <label class="form-check-label" for="selectMode">Select Existing Staff</label>
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            
                            <!--[if BLOCK]><![endif]--><?php if($staffMode === 'select'): ?>
                                <div class="mb-3 col-md-6" x-data="{ dropdownOpen: <?php if ((object) ('dropdownVisible') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('dropdownVisible'->value()); ?>')<?php echo e('dropdownVisible'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('dropdownVisible'); ?>')<?php endif; ?> }">
                                    <label class="form-label">Select Staff Member <span
                                            class="text-danger">*</span></label>
                                    <div class="position-relative">
                                        <input type="text" class="form-control" placeholder="Search staff..."
                                            wire:model.live.debounce.300ms="searchTerm"
                                            @focus="$wire.set('dropdownVisible', true)"
                                            @click.away="$wire.set('dropdownVisible', false)">

                                        <!--[if BLOCK]><![endif]--><?php if($dropdownVisible && count($existingStaff) > 0): ?>
                                            <div class="mt-1 dropdown-menu d-block position-absolute w-100 bg-white"
                                                style="z-index: 1000; max-height: 300px; overflow-y: auto;">
                                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $existingStaff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <button type="button"
                                                        class="dropdown-item d-flex justify-content-between"
                                                        wire:click="selectStaff(<?php echo e($staff->id); ?>)">
                                                        <span><?php echo e($staff->name); ?></span>
                                                        <small class="text-muted"><?php echo e($staff->email); ?></small>
                                                    </button>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <div class="dropdown-item text-muted">No staff found</div>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <!--[if BLOCK]><![endif]--><?php if($selectedExistingStaff): ?>
                                        <?php
                                            $selectedStaff = \App\Models\User::find($selectedExistingStaff);
                                        ?>
                                        <div
                                            class="p-2 mt-2 rounded bg-light d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong>Selected:</strong> <?php echo e($selectedStaff->name); ?>

                                                <br>
                                                <small class="text-muted"><?php echo e($selectedStaff->email); ?></small>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-outline-danger"
                                                wire:click="$set('selectedExistingStaff', null)">
                                                <i class="fas fa-times"></i> Clear
                                            </button>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedExistingStaff'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            
                            <!--[if BLOCK]><![endif]--><?php if($staffMode === 'create' || $staffId): ?>
                                <!--[if BLOCK]><![endif]--><?php if(!$staffId): ?>
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="name">Full Name <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="name" wire:model="name" class="form-control"
                                            placeholder="John Doe"
                                            <?php echo e($staffMode === 'select' && $selectedExistingStaff ? 'readonly' : ''); ?>>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="email">Email Address <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" wire:model="email" class="form-control"
                                            placeholder="example@email.com"
                                            <?php echo e($staffMode === 'select' && $selectedExistingStaff ? 'readonly' : ''); ?>>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="phone_number">Phone Number <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="phone_number" wire:model="phone_number"
                                            class="form-control" placeholder="+1234567890">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="password">
                                            Password
                                            <!--[if BLOCK]><![endif]--><?php if($staffId): ?>
                                                <small class="text-muted">(Leave blank to keep current)</small>
                                            <?php else: ?>
                                                <span class="text-danger">*</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </label>
                                        <input type="password" id="password" wire:model="password"
                                            class="form-control"
                                            placeholder="<?php echo e($staffId ? 'Leave blank to keep current' : 'Password'); ?>">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="password_confirmation">Confirm Password</label>
                                        <input type="password" id="password_confirmation"
                                            wire:model="password_confirmation" class="form-control"
                                            placeholder="Confirm Password">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($staffId): ?>
                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="name">Full Name <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="name" wire:model="name" class="form-control"
                                            placeholder="John Doe" readonly>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>

                                    <div class="mb-3 col-md-6">
                                        <label class="form-label" for="email">Email Address <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" wire:model="email" class="form-control"
                                            placeholder="example@email.com" readonly>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            
                            <div class="col-12 mt-4">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="fw-bold mb-0">Staff Permissions</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive border">
                                            <table class="table table-nowrap">
                                                <thead class="thead-light">
                                                    <tr>
                                                        <th>Module</th>
                                                        <th>LIST</th>
                                                        <th>CREATE</th>
                                                        <th>EDIT</th>
                                                        <th>DELETE</th>
                                                        <th>VIEW</th>
                                                        <th>TOGGLE ALL</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $permissionGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $groupPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $allChecked =
                                                                count(
                                                                    array_intersect($groupPermissions, $permissions),
                                                                ) === count($groupPermissions) ||
                                                                $groupName === 'Dashboard Access';
                                                            $isDisabled = in_array($groupName, [
                                                                'Appointment Management',
                                                                'Medical Records',
                                                                'Financial',
                                                                'Staff Management',
                                                            ]);
                                                        ?>
                                                        <tr>
                                                            <td>
                                                                <p class="fw-medium text-dark"><?php echo e($groupName); ?></p>
                                                            </td>
                                                            <?php
                                                                $permissionTypes = [
                                                                    'list',
                                                                    'create',
                                                                    'edit',
                                                                    'delete',
                                                                    'view',
                                                                ];
                                                                $permissionColumns = [];

                                                                foreach ($permissionTypes as $type) {
                                                                    $permissionColumns[$type] = false;
                                                                    foreach ($groupPermissions as $permission) {
                                                                        if (str_contains($permission, $type)) {
                                                                            $permissionColumns[$type] = $permission;
                                                                            break;
                                                                        }
                                                                    }
                                                                }

                                                                if ($groupName === 'Dashboard Access') {
                                                                    $permissionColumns['view'] =
                                                                        'access admin dashboard';
                                                                }
                                                            ?>

                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $permissionTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <td>
                                                                    <!--[if BLOCK]><![endif]--><?php if($permissionColumns[$type]): ?>
                                                                        <div class="form-check form-check-md">
                                                                            <input class="form-check-input"
                                                                                type="checkbox"
                                                                                id="perm_<?php echo e($permissionColumns[$type]); ?>"
                                                                                <?php if(
                                                                                    $permissionColumns[$type] === 'access admin dashboard' ||
                                                                                        (is_array($permissions) && in_array($permissionColumns[$type], $permissions))): echo 'checked'; endif; ?>
                                                                                <?php if($permissionColumns[$type] === 'access admin dashboard' || $isDisabled): echo 'disabled'; endif; ?>
                                                                                wire:click="togglePermission('<?php echo e($permissionColumns[$type]); ?>')">
                                                                            <!--[if BLOCK]><![endif]--><?php if($permissionColumns[$type] === 'access admin dashboard'): ?>
                                                                                <span
                                                                                    class="text-muted">(Required)</span>
                                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                        </div>
                                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                </td>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

                                                            <td>
                                                                <button type="button"
                                                                    class="btn btn-sm <?php echo e($allChecked ? 'btn-outline-danger' : 'btn-outline-primary'); ?>"
                                                                    wire:click="toggleAllPermissionsInGroup('<?php echo e($groupName); ?>')"
                                                                    <?php if($permissionColumns[$type] === 'access admin dashboard' || $isDisabled): echo 'disabled'; endif; ?>>
                                                                    <?php echo e($allChecked ? 'Deny All' : 'Allow All'); ?>

                                                                </button>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <div class="mt-2">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="status"
                                            id="statusActive" value="active" <?php if(!$staffId): ?> disabled <?php endif; ?>>
                                        <label class="form-check-label" for="statusActive">Active</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" wire:model="status"
                                            id="statusInactive" value="inactive" <?php if(!$staffId): ?> selected disabled <?php endif; ?>>
                                        <label class="form-check-label" for="statusInactive">Inactive</label>
                                    </div>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            
                            <div class="mb-3 col-md-12">
                                <label class="form-label" for="notes">Additional Notes</label>
                                <textarea id="notes" wire:model="notes" class="form-control" rows="2"
                                    placeholder="Any additional notes about this staff member..."></textarea>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            
                            <!--[if BLOCK]><![endif]--><?php if($staffMode === 'create' && !$staffId): ?>
                                <div class="col-md-12">
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle"></i>
                                        <strong>Note:</strong> A password is required for new staff. They can change it
                                        later through their profile.
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            
                            <!--[if BLOCK]><![endif]--><?php if($staffMode === 'select' && !$staffId): ?>
                                <div class="col-md-12">
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle"></i>
                                        <strong>Note:</strong> This will assign the selected user as staff to the chosen
                                        clinic and doctor. They will receive an email notification.
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    
                    <div class="card-footer text-end">
                        <button type="button" wire:click="resetForm" class="btn btn-secondary me-2">
                            <i class="ti ti-refresh"></i> Reset
                        </button>
                        <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <!--[if BLOCK]><![endif]--><?php if($staffId): ?>
                                    <i class="ti ti-device-floppy"></i> Update Staff
                                <?php elseif($staffMode === 'select'): ?>
                                    <i class="ti ti-user-plus"></i> Assign as Staff
                                <?php else: ?>
                                    <i class="ti ti-plus"></i> Add Staff
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </span>
                            <span wire:loading>
                                <i class="ti ti-loader fa-spin"></i> Processing...
                            </span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('scroll-to-form', () => {
                document.getElementById('staff-form').scrollIntoView({
                    behavior: 'smooth'
                });
            });

            // Handle clicking outside dropdown to close it
            document.addEventListener('click', function(event) {
                const dropdown = document.querySelector('.dropdown-menu');
                const input = document.querySelector('input[placeholder="Search staff..."]');

                if (dropdown && input && !dropdown.contains(event.target) && !input.contains(event
                        .target)) {
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('dropdownVisible', false);
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/doctor/staff/staff-form.blade.php ENDPATH**/ ?>