<div wire:ignore.self>
    <!--[if BLOCK]><![endif]--><?php if(!$isLoaded): ?>
        <div class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="mt-2">Loading doctors...</p>
        </div>
    <?php else: ?>
        <!-- Start Page Header -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
            <div class="flex-grow-1">
                <h4 class="fw-bold mb-0">
                    Doctor Management
                    <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                        Total Doctors: <?php echo e($doctors->total() ?? 0); ?>

                    </span>
                </h4>
            </div>

            <div class="text-end d-flex">
                <a href="<?php echo e(route('admin.clinics.doctor.management.create', $clinic)); ?>"
                    class="btn btn-primary ms-2 fs-13 btn-md">
                    <i class="ti ti-plus me-1"></i>Add New Doctor
                </a>
            </div>
        </div>
        <!-- End Page Header -->

        <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3">
            <div class="search-set mb-3">
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <div class="table-search d-flex align-items-center mb-0">
                        <div class="search-input">
                            <a href="javascript:void(0);" class="btn-searchset"></a>
                            <div id="DataTables_Table_0_filter" class="dataTables_filter">
                                <label>
                                    <input type="search" class="form-control form-control-sm"
                                        placeholder="Search doctors..." wire:model.live.debounce.300ms="searchTerm"
                                        aria-controls="DataTables_Table_0">
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
                <div class="dropdown me-2">
                    <a href="javascript:void(0);"
                        class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                        data-bs-toggle="dropdown" data-bs-auto-close="outside">
                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                    </a>
                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                            <h4 class="mb-0">Filter</h4>
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="link-danger text-decoration-underline"
                                    wire:click="clearAllFilters">Clear All</a>
                            </div>
                        </div>
                        <div class="filter-body pb-0">
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Status</label>
                                    <a href="javascript:void(0);" class="link-primary mb-1"
                                        wire:click="resetStatusFilter">Reset</a>
                                </div>
                                <select class="form-select" wire:model="statusFilter">
                                    <option value="all">All Status</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Approval Status</label>
                                    <a href="javascript:void(0);" class="link-primary mb-1"
                                        wire:click="resetApprovelStatusFilter">Reset</a>
                                </div>
                                <select class="form-select" wire:model="approvalStatusFilter">
                                    <option value="all">All Approval Status</option>
                                    <option value="approved">Approved</option>
                                    <option value="pending">Pending</option>
                                    <option value="rejected">Rejected</option>
                                </select>
                            </div>
                        </div>
                        <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                            <a href="javascript:void(0);" class="btn btn-light btn-md me-2"
                                data-bs-toggle="dropdown">Close</a>
                            <button type="button" class="btn btn-primary btn-md" wire:click="applyFilters"
                                data-bs-toggle="dropdown">Filter</button>
                        </div>
                    </div>
                </div>
                <div class="dropdown">
                    <a href="javascript:void(0);"
                        class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                        data-bs-toggle="dropdown">
                        <span class="me-1"> Sort By : </span> Recent
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1"
                                wire:click="sortBy('name')">Name</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1"
                                wire:click="sortBy('status')">Status</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1">Recently Added</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead class="">
                    <tr>
                        <th wire:click="sortBy('name')" style="cursor: pointer;">
                            Name <?php echo $sortField === 'name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : ''; ?>

                        </th>
                        <th>Email</th>
                        <th>License Number</th>
                        <th>Primary Clinic</th>
                        <th wire:click="sortBy('status')" style="cursor: pointer;">
                            Status <?php echo $sortField === 'status' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : ''; ?>

                        </th>
                        <th>Approval Status</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $association = $user->clinicAssociations->first();
                            $profile = $user?->doctorProfile;
                            $profileImage = $user->doctor?->profile_image;
                        ?>
                        <tr>
                            <td>
                                <?php if (isset($component)) { $__componentOriginal61678554f89acd69b53e2505281ebce7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal61678554f89acd69b53e2505281ebce7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user.avatar-name','data' => ['name' => $user->name,'profileImage' => $profileImage]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user.avatar-name'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($user->name),'profileImage' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($profileImage)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal61678554f89acd69b53e2505281ebce7)): ?>
<?php $attributes = $__attributesOriginal61678554f89acd69b53e2505281ebce7; ?>
<?php unset($__attributesOriginal61678554f89acd69b53e2505281ebce7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal61678554f89acd69b53e2505281ebce7)): ?>
<?php $component = $__componentOriginal61678554f89acd69b53e2505281ebce7; ?>
<?php unset($__componentOriginal61678554f89acd69b53e2505281ebce7); ?>
<?php endif; ?>
                            </td>
                            <td>
                                <span class="fs-13"><?php echo e($user->email); ?></span>
                            </td>
                            <td>
                                <span class="fs-13"><?php echo e($profile->license_number ?? 'N/A'); ?></span>
                            </td>
                            <td>
                                <?php
                                    $primaryClinic = $user->clinics->where('pivot.is_primary', true)->first();
                                ?>
                                <!--[if BLOCK]><![endif]--><?php if($primaryClinic): ?>
                                    <!--[if BLOCK]><![endif]--><?php if($primaryClinic->name === $clinic->name): ?>
                                        <span class="badge bg-primary">
                                            <?php echo e($primaryClinic->name); ?>

                                        </span>
                                    <?php else: ?>
                                        <span class="fs-13"><?php echo e($primaryClinic->name); ?></span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php else: ?>
                                    <span class="fs-13 text-muted">N/A</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td>
                                <span wire:click="toggleStatus(<?php echo e($user->id); ?>, <?php echo e($clinic->id); ?>)" style="cursor: pointer;"
                                    class="badge badge-soft-<?php echo e($association?->status === 'active' ? 'success' : 'danger'); ?> border border-<?php echo e($association?->status === 'active' ? 'success' : 'danger'); ?>">
                                    <?php echo e(ucfirst($association?->status ?? 'Inactive')); ?>

                                </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span
                                        class="badge badge-soft-<?php echo e($association?->approval_status === 'approved' ? 'success' : ($association?->approval_status === 'pending' ? 'warning' : 'danger')); ?> border border-<?php echo e($association?->approval_status === 'approved' ? 'success' : ($association?->approval_status === 'pending' ? 'warning' : 'danger')); ?>">
                                        <?php echo e(ucfirst($association?->approval_status ?? 'Pending')); ?>

                                    </span>
                                    <div class="action-item ms-2">
                                        <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                            <i class="ti ti-settings"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end bg-white">
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center" href="javascript:;"
                                                    wire:click="toggleApprovalStatus(<?php echo e($user->id); ?>, <?php echo e($clinic->id); ?>, 'approved')">
                                                    <i class="ti ti-check me-2 text-success"></i>
                                                    Approve
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center" href="javascript:;"
                                                    wire:click="toggleApprovalStatus(<?php echo e($user->id); ?>, <?php echo e($clinic->id); ?>, 'rejected')">
                                                    <i class="ti ti-x me-2 text-danger"></i>
                                                    Reject
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center" href="javascript:;"
                                                    wire:click="toggleApprovalStatus(<?php echo e($user->id); ?>, <?php echo e($clinic->id); ?>, 'pending')">
                                                    <i class="ti ti-clock me-2 text-warning"></i>
                                                    Pending
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="action-item">
                                        <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end bg-white">
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center"
                                                    href="<?php echo e(route('admin.clinics.doctor.management.edit', [$clinic, $user->id])); ?>">
                                                    <i class="ti ti-edit me-2"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center"
                                                    href="<?php echo e(route('admin.doctor-management.view', $user->id)); ?>">
                                                    <i class="ti ti-eye me-2"></i> View
                                                </a>
                                            </li>
                                            <li>
                                                <a href="javascript:void(0);" @click="$dispatch('show-shared-delete-modal', {
                                                                            title: 'Delete Doctor',
                                                                            message: 'Are you sure you want to remove this doctor from the clinic?',
                                                                            doctorId: <?php echo e($user->id); ?>,
                                                                            clinicId: <?php echo e($clinic->id); ?>,
                                                                            action: 'confirm-delete-doctor'
                                                                        })" class="dropdown-item text-danger">
                                                    <i class="ti ti-trash me-2"></i> Remove Doctor
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">No doctors found.</td>
                        </tr>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
            </table>
        </div>

        
        <?php if (isset($component)) { $__componentOriginal7a1de95135fea4b7a0f524148344a9f0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0 = $attributes; } ?>
<?php $component = App\View\Components\Table\Pagination::resolve(['paginator' => $doctors,'position' => 'both'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('table.pagination'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Table\Pagination::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $attributes = $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $component = $__componentOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /var/www/predcare/resources/views/livewire/admin/clinics/doctors-table.blade.php ENDPATH**/ ?>