<?php $__env->startSection('title', 'Patient Dashboard'); ?>

<?php $__env->startSection('content'); ?>

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="mb-3 border-bottom pb-3">
            <h4 class="fw-bold mb-0">Clinic List</h4>
        </div>
        <!-- End Page Header -->

        
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>

        
        <?php if($message): ?>
            <div class="alert alert-info"><?php echo e($message); ?></div>
        <?php endif; ?>

        <!-- Start Clinic List -->
        <div class="card flex-fill mb-0 border-0 bg-light-500 shadow-none">
            <div class="card-body px-0 mx-3">
                <!-- start row -->
                <div class="row">
        
                    <?php $__empty_1 = true; $__currentLoopData = $clinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                        <div class="col-md-4">
                            <div class="card shadow-none">
                                <div class="card-body">
                                    <div class="d-flex border-0 mb-0 pb-0">
                                        <!-- Clickable image -->
                                        <a href="<?php echo e(route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']])); ?>" >
                                            <!-- <img src="<?php echo e(asset('assets/img/hospital.png')); ?>" alt="Hospital" class=""> -->
                                            <img src="<?php echo e($clinic['image']); ?>" class="card-img-top me-2" alt="Clinic Image">
                                        </a>
                                    </div>
                                </div>
                                <div class="card-footer align-items-center justify-content-between">
                                    <div>
                                        <!-- Clickable Name with Icon -->
                                        <p class="fw-medium text-dark mb-1">
                                            <a href="<?php echo e(route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']])); ?>"  class="text-dark text-decoration-none">
                                                <i class="ti ti-building-hospital me-1"></i> <?php echo e($clinic['name']); ?>

                                            </a>
                                        </p>

                                        <p class="fw-medium text-dark mb-1">
                                            <a href="<?php echo e(route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']])); ?>"  class="text-dark text-decoration-none">
                                                <i class="ti ti-mail me-1"></i> <?php echo e($clinic['email']); ?>

                                            </a>
                                        </p>

                                        <p class="fw-medium text-dark mb-1">
                                            <a href="<?php echo e(route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']])); ?>"  class="text-dark text-decoration-none">
                                                <i class="ti ti-phone me-1"></i> <?php echo e($clinic['contact_numbers'] ?? 'N/A'); ?>

                                            </a>
                                        </p>

                                        <!-- Address with Location Icon -->
                                        <p class="mb-0">
                                            <i class="ti ti-map-pin me-1"></i> <?php echo e($clinic['address']); ?>

                                        </p>
                                    </div>
                                    <br>
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex flex-wrap">
                                            <?php if(!empty($clinic['specialities'])): ?>
                                                <?php $__currentLoopData = explode(',', $clinic['specialities']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speciality): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a class="btn btn-sm btn-light border rounded-2 p-1 me-2 mb-2" href="#">
                                                        <?php echo e(trim($speciality)); ?>

                                                    </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <span class="text-muted">N/A</span>
                                            <?php endif; ?>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p>No clinics found.</p>
                    <?php endif; ?>

                </div>
                <!-- end row -->
            </div>
        </div>
        <!-- End Clinic List -->

    </div>
    <!-- End Content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/predcare/resources/views/patient/doctor/clinic-list.blade.php ENDPATH**/ ?>