<div class="content">
    <!-- row start -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="<?php echo e(route('admin.subscription-plans.list')); ?>" class="text-dark">
                        <i
                            class="ti ti-chevron-left me-1"></i><?php echo e('Subscription Plan View'); ?>

                    </a>
                </h6>
            </div>
            <!-- page header end -->
            <div class="card">
                <div class="card-header">
                    <h5>View Plan Details</h5>
                </div>

                <div class="card-body">
                    <!-- Basic Information -->
                    <div class="mb-5">
                        <h6 class="border-bottom pb-2 mb-3">Basic Information</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <p><strong>Plan Code:</strong> <?php echo e($planData['basic']['plan_code']); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Plan Name:</strong> <?php echo e($planData['basic']['plan_name']); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Plan Type:</strong> <?php echo e(ucfirst($planData['basic']['plan_type'])); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Duration:</strong> <?php echo e($planData['basic']['duration']); ?>

                                    <?php echo e($planData['basic']['plan_type'] === 'monthly' ? 'Month(s)' : 'Year(s)'); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Base Price:</strong> <?php echo e($planData['basic']['currency']); ?>

                                    <?php echo e(number_format($planData['basic']['base_price'], 2)); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Status:</strong> <?php echo e(ucfirst($planData['basic']['plan_status'])); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Plan Limits -->
                    <div class="mb-5">
                        <h6 class="border-bottom pb-2 mb-3">Plan Limits</h6>
                        <div class="row">
                            <div class="col-md-4">
                                <p><strong>Max Doctors:</strong> <?php echo e($planData['limits']['included_doctors']); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Additional Doctor Price:</strong> <?php echo e($planData['basic']['currency']); ?>

                                    <?php echo e(number_format($planData['limits']['additional_doctor_price'], 2)); ?></p>
                            </div>
                            <div class="col-md-4">
                            </div>
                            <div class="col-md-4">
                                <p><strong>Max Staff:</strong> <?php echo e($planData['limits']['included_staff']); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Storage Limit:</strong> <?php echo e($planData['limits']['storage_limit_gb']); ?> GB</p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Teleconsultation:</strong>
                                    <?php echo e($planData['limits']['teleconsultation_minutes']); ?>

                                    minutes</p>
                            </div>
                        </div>
                    </div>

                    <!-- Included Features -->
                    <div class="mb-5">
                        <h6 class="border-bottom pb-2 mb-3">Included Features (<?php echo e(count($planData['features'])); ?>)</h6>
                        <div class="row">
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $available_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 mb-2">
                                    <i class="fas fa-check-circle text-success me-2"></i>
                                    <?php echo e($feature->feature_name); ?>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <!-- Usage Rates -->
                    <div class="mb-4">
                        <h6 class="border-bottom pb-2 mb-3">Usage Rates (<?php echo e(count($planData['rates'])); ?>)</h6>
                        <!--[if BLOCK]><![endif]--><?php if(count($planData['rates']) > 0): ?>
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Usage Type</th>
                                            <th>Per Unit Rate</th>
                                            <th>Free Units</th>
                                            
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $planData['rates']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $type = $available_usage_types->get($rate['usage_type_id']);
                                            ?>
                                            <tr>
                                                <td> <strong><?php echo e($type->type_name ?? 'N/A'); ?></strong>
                                                    <div class="small text-muted"><?php echo e($type->unit_name ?? ''); ?>

                                                </td>
                                                <td><?php echo e(number_format($rate['rate_per_unit'], 2)); ?>

                                                    <?php echo e($planData['basic']['currency']); ?> Per
                                                    <?php echo e($type->unit_name); ?>

                                                </td>
                                                <td><?php echo e(number_format($rate['free_units'])); ?>

                                                    <?php echo e($type->unit_name ?? ''); ?>

                                                </td>
                                                
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No usage rates configured</p>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/plans/subscription-plan-view.blade.php ENDPATH**/ ?>