@extends('layouts.app')

@section('title', 'Patient Dashboard')

@section('content')

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Start Page Header -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
            <div class="flex-grow-1">
                <h4 class="fw-bold mb-0"> Clinic/Doctors List</h4>
            </div>
        </div><br><br><br>
        <!-- End Page Header -->

        @if(session('success'))
            <div class="alert alert-success mt-2">
                {{ session('success') }}
            </div>
        @endif

        @if(session('error'))
            <div class="alert alert-danger mt-2">
                {{ session('error') }}
            </div>
        @endif

        <!-- QR Code Section -->
        <div class="row">
            <div class="col-md-4"></div>
            <div class="col-md-4">
                <div class="text-center bg-white mb-4 p-4 rounded shadow-sm">
                    <h1 class="fw-bold mb-2">Please Enter Clinic ID</h1>
                    <p class="text-muted">To book an appointment, please enter the clinic's id to view associated doctors and schedule your booking.</p>
                    <form method="POST" action="{{ route('patient.doctor.clinic') }}">
                        @csrf
                        <div class="form">
                            <div class="row">
                                <input type="text" id="clinic_id" name="clinic_id" class="form-control" placeholder="Enter the clinic id... Ex.: 1" required>
                            </div>
                        </div>
                            
                        <div class="align-items-center justify-content-end mt-3">
                            <a href="{{ route('patient.doctor.clinicList') }}" class="btn btn-info px-4 py-2 rounded-pill"><i class="ti ti-stethoscope me-2"></i> Clinic List</a>
                            <button type="submit" class="btn btn-primary px-4 py-2 rounded-pill">
                                <i class="ti ti-plus me-2"></i> Add Clinic
                            </button>
                        </div>
                    </form>

                    <!-- QR Code Image Placeholder -->
                    <!-- <div class="d-flex justify-content-center gap-3 mb-3 flex-wrap">
                        <img src="{{ asset('assets/img/qr_code.png') }}" alt="QR Code" class="img-fluid rounded shadow">

                    </div> -->

                </div>
            </div>
            <div class="col-md-4"></div>
        </div>
        <!-- End QR Code Section -->

    </div>
    <!-- End Content -->
@endsection
