@extends('layouts.app')

@section('title', 'Patient Dashboard')

@section('content')

<style>
.fl-wrapper[data-position^=top-] {
    top: 5em;
}
</style>

    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Page Header -->
        <div class="mb-3 border-bottom pb-3">
            <h4 class="fw-bold mb-0">Clinic List</h4>
        </div>
        <!-- End Page Header -->

        {{-- Flash Messages --}}
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        {{-- If message from controller --}}
        @if($message)
            <div class="alert alert-info">{{ $message }}</div>
        @endif

        <!-- Start Clinic List -->
        <div class="card flex-fill mb-0 border-0 bg-light-500 shadow-none">
            <div class="card-body px-0 mx-3">
                <!-- start row -->
                <div class="row">
        
                    @forelse($clinics as $clinic)

                        <div class="col-md-4">
                            <div class="card shadow-none">
                                <div class="card-body">
                                    <div class="d-flex border-0 mb-0 pb-0">
                                        <!-- Clickable image -->
                                        <a href="{{ route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']]) }}" >
                                            <!-- <img src="{{ asset('assets/img/hospital.png') }}" alt="Hospital" class=""> -->
                                            <img src="{{ $clinic['image'] }}" class="card-img-top me-2" alt="Clinic Image">
                                        </a>
                                    </div>
                                </div>
                                <div class="card-footer align-items-center justify-content-between">
                                    <div>
                                        <!-- Clickable Name with Icon -->
                                        <p class="fw-medium text-dark mb-1">
                                            <a href="{{ route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']]) }}"  class="text-dark text-decoration-none">
                                                <i class="ti ti-building-hospital me-1"></i> {{ $clinic['name'] }}
                                            </a>
                                        </p>

                                        <p class="fw-medium text-dark mb-1">
                                            <a href="{{ route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']]) }}"  class="text-dark text-decoration-none">
                                                <i class="ti ti-mail me-1"></i> {{ $clinic['email'] }}
                                            </a>
                                        </p>

                                        <p class="fw-medium text-dark mb-1">
                                            <a href="{{ route('patient.doctor.clinicDetail', ['id' => $clinic['clinic_id']]) }}"  class="text-dark text-decoration-none">
                                                <i class="ti ti-phone me-1"></i> {{ $clinic['contact_numbers'] ?? 'N/A' }}
                                            </a>
                                        </p>

                                        <!-- Address with Location Icon -->
                                        <p class="mb-0">
                                            <i class="ti ti-map-pin me-1"></i> {{ $clinic['address'] }}
                                        </p>
                                    </div>
                                    <br>
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex flex-wrap">
                                            @if(!empty($clinic['specialities']))
                                                @foreach(explode(',', $clinic['specialities']) as $speciality)
                                                    <a class="btn btn-sm btn-light border rounded-2 p-1 me-2 mb-2" href="#">
                                                        {{ trim($speciality) }}
                                                    </a>
                                                @endforeach
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                    @empty
                        <p>No clinics found.</p>
                    @endforelse

                </div>
                <!-- end row -->
            </div>
        </div>
        <!-- End Clinic List -->

    </div>
    <!-- End Content -->

@endsection
