@extends('layouts.app')

@section('title', 'Patient Dashboard')

@section('content')

<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>
    <!-- Start Content -->
    <div class="content pb-0">

        <!-- Start Page Header -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
            <div class="flex-grow-1">
                <h4 class="fw-semibold mb-0"> 
                    Appointment List
                    <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                        Total Appointment: {{ $appointments->count() }}
                    </span>
                </h4>
            </div>
            <div class="text-end d-flex">
                <a href="{{ route('patient.appointments.create') }}" class="btn btn-primary ms-2 fs-13 btn-md"><i class="ti ti-plus me-1"></i> New Appointment </a>
            </div>
        </div>
        <!-- End Page Header -->

        <!--  Start Filter -->
        <div class=" d-flex align-items-center justify-content-between flex-wrap">
            <div class="d-flex align-items-center gap-2">
                <div class="search-set mb-3">
                    <div class="d-flex align-items-center flex-wrap gap-2">
                        <div class="table-search d-flex align-items-center mb-0">
                            <div class="search-input">
                                <a href="javascript:void(0);" class="btn-searchset"></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
            </div>
        </div>
        <!--  End Filter -->

        <!--  Start Table -->
        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead class="">
                    <tr>
                        <th>Auto ID</th>
                        <th>Appointment ID</th>
                        <th>Doctor</th>
                        <th>Specialization</th>
                        <th>Appointment Date</th>
                        <th>Appointment Time (Slot)</th>
                        <th>Consultation Fees</th>
                        <th>Appointment Type</th>
                        <th>Reason</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($appointments as $item)
                        <tr>
                            <td>{{ $item->id }}</td>
                            <td>{{ $item->appointment_id }}</td>
                            <td>{{ $item->doctor->name ?? 'N/A' }}</td>
                            <td>{{ $item->specialization }}</td>
                            <td>{{ \Carbon\Carbon::parse($item->appointment_date)->isoFormat('D, MMMM YYYY') }}</td>
                            <td>
                                <ul class="list-unstyled mb-0">
                                    @foreach (json_decode($item->appointment_slot_time) as $slot)
                                        <li class="d-inline-block me-2 mb-2 px-3 border rounded bg-light">
                                            <i class="ti ti-clock me-1 text-primary"></i> {{ $slot }}
                                        </li><br>
                                    @endforeach
                                </ul>
                            </td>
                            <td>
                                <strong>
                                    @if ($item->fee_type === 'in_person_fee')
                                        In-Person
                                    @elseif ($item->fee_type === 'video_fee')
                                        Video
                                    @else
                                        {{ ucfirst(str_replace('_', ' ', $item->fee_type)) }}
                                    @endif
                                </strong>
                                - ${{ $item->appointment_fee }}
                            </td>
                            <td>
                                @if ($item->appointment_type === 'first_visit')
                                    First Visit
                                @elseif ($item->appointment_type === 'follow_up')
                                    Follow Up
                                @else
                                    {{ ucfirst($item->appointment_type) }}
                                @endif
                            </td>
                            <td>{{ $item->reason }}</td>
                            <td>
                                {{-- Appointment Status --}}
                                @if($item->appointment_status == 'completed')
                                    <span class="badge bg-success fw-medium">Completed</span>
                                @elseif($item->appointment_status == 'cancelled')
                                    <span class="badge bg-danger fw-medium">Cancelled</span>
                                @else
                                    @if ($item->fee_type === 'in_person_fee')
                                            
                                    @elseif ($item->fee_type === 'video_fee')
                                        <div class="">
                                            <a href="{{ route('patient.call', [
                                                            'appointment_id' => $item->appointment_id,
                                                            'doctor_id'      => auth('doctor')->id(),
                                                            'patient_id'     => $item->patient_id, // optional but nice
                                                        ]) }}"
                                                class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2" data-bs-toggle="tooltip" title="Start Video Call">
                                                <i class="ti ti-video"></i>
                                            </a>

                                            {{-- Call Button --}}
                                            <!-- <a href="javascript:void(0);" 
                                            class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#termsModal{{ $item->id }}" 
                                            title="Start Video Call">
                                                <i class="ti ti-video"></i>
                                            </a>

                                            {{-- Modal --}}
                                            <div class="modal fade" id="termsModal{{ $item->id }}" tabindex="-1" aria-labelledby="termsModalLabel{{ $item->id }}" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="termsModalLabel{{ $item->id }}">Terms & Conditions</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>

                                                <div class="modal-body">
                                                    <p class="text-muted">
                                                    Before starting the video consultation, please read and agree to the Terms & Conditions.  
                                                    <br><br>
                                                    • The consultation will be recorded for compliance if required.  
                                                    • This call does not replace emergency services.  
                                                    • Any prescriptions provided must be followed as per doctor’s advice.  
                                                    • Your data will be kept confidential.  
                                                    </p>
                                                </div>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Decline</button>
                                                    <a href="{{ route('patient.call', [
                                                                'appointment_id' => $item->appointment_id,
                                                                'doctor_id'      => auth('doctor')->id(),
                                                                'patient_id'     => $item->patient_id,
                                                            ]) }}" class="btn btn-primary">
                                                    Accept & Join Call
                                                    </a>
                                                </div>
                                                </div>
                                            </div>
                                            </div> -->

                                            <!-- <a href="{{ route('patient.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2" data-bs-toggle="tooltip" title="Start Video Call">
                                                <i class="ti ti-video"></i>
                                            </a> -->
                                            <!-- <a href="{{ route('patient.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14" data-bs-toggle="tooltip" title="Start Audio Call">
                                                <i class="ti ti-phone"></i>
                                            </a> -->
                                            <!-- <a href="{{ route('patient.call') }}" class="btn btn-outline-info shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14" data-bs-toggle="tooltip" title="Start Chat">
                                                <i class="ti ti-message-circle"></i>
                                            </a> -->
                                        </div><br>
                                    @endif

                                    <span class="badge bg-secondary fw-medium">{{ ucfirst($item->appointment_status) }}</span>
                                @endif
                            </td>
                            <td class="action-item">
                                <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                    <i class="ti ti-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu p-2">
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center view-appointment" data-id="{{ $item->id }}"
                                            data-bs-toggle="offcanvas" data-bs-target="#view_details"><i class="ti ti-eye me-2"></i>  View
                                        </a>
                                    </li>
                                    <li>
                                        <form method="POST" action="{{ route('patient.appointments.destroy', $item->id) }}" class="delete-form d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="dropdown-item d-flex align-items-center text-danger confirm-delete"
                                                    data-doctor="{{ $item->doctor->name }}">
                                                <i class="ti ti-trash me-2"></i> Delete
                                            </button>
                                        </form>
                                    </li>
                                </ul>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <!--  End Table -->

        <!-- Start View Details -->
        <div class="offcanvas offcanvas-offset offcanvas-end" tabindex="-1" id="view_details">
            <div class="offcanvas-header d-block pb-0 px-0">
                <div class="border-bottom d-flex align-items-center justify-content-between pb-3 px-3">
                    <!-- Inside the Offcanvas -->
                    <h5 class="offcanvas-title fs-18 fw-bold">
                        Appointment Details <span class="badge badge-soft-primary border pt-1 px-2 border-primary fw-medium ms-2" id="view_appointment_id">#APT0000</span>
                    </h5>
                    <button type="button" class="btn-close custom-btn-close opacity-100" data-bs-dismiss="offcanvas" aria-label="Close"><i class="ti ti-x bg-white fs-16 text-dark"></i></button>            
                </div>
            </div>
            <div class="offcanvas-body pt-0 px-0">
                <h6 class="bg-light py-2 px-3 text-dark fw-bold"> When & Where </h6>
                <div class="px-3 my-4">
                    <!-- Example Data Section -->
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Appointment On <span class="text-body fw-normal" id="view_appointment_date">Loading...</span>
                    </p>
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Time <span class="text-body fw-normal" id="view_appointment_time">Loading...</span>
                    </p>
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Location <span class="text-body fw-normal" id="view_clinic">Loading...</span>
                    </p>
                    <p class="text-dark mb-3 fw-semibold d-flex align-items-center justify-content-between"> 
                        Appointment Type <span class="text-body fw-normal" id="view_appointment_type">Loading...</span>
                    </p>
                    <!-- Patient Name -->
                    <div class="text-body fw-normal d-flex align-items-center" id="view_patient">
                        <span class="avatar avatar-sm me-1">
                            <img src="{{URL::asset('assets/img/PRED_CARE-Logo.png')}}" alt="" class="rounded-circle">
                        </span>
                        Loading...
                    </div>
                </div>
            </div>
        </div>
        <!-- End View Details -->
                
    </div>
    <!-- End Content -->
@endsection

<!-- Delete Confirmation Modal -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".confirm-delete").forEach(function (button) {
            button.addEventListener("click", function () {
                const form = this.closest('form');
                const name = this.dataset.name || 'this appointment';

                Swal.fire({
                    title: 'Are you sure?',
                    text: `You are about to delete ${name}.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, delete it!',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".view-appointment").forEach(function (button) {
        button.addEventListener("click", function () {
            const id = this.dataset.id;

            // Laravel route helper with placeholder
            const url = '{{ route("patient.appointments.show", ":id") }}'.replace(':id', encodeURIComponent(id));

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    // Set values
                    document.getElementById('view_appointment_id').textContent = '#' + data.appointment_id;
                    document.getElementById('view_appointment_date').textContent = data.appointment_date;
                    document.getElementById('view_appointment_time').textContent = JSON.parse(data.appointment_slot_time).join(', ');
                    document.getElementById('view_clinic').textContent = data.clinic?.name || 'N/A';
                    document.getElementById('view_appointment_type').textContent = data.appointment_type.replace('_', ' ').toUpperCase();

                    const patientName = data.patient?.name || 'N/A';
                    document.getElementById('view_patient').innerHTML = `
                        <span class="avatar avatar-sm me-1">
                            <img src="/assets/img/PRED_CARE-Logo.png" alt="" class="rounded-circle">
                        </span>
                        ${patientName}
                    `;
                })
                .catch(error => {
                    console.error('Error fetching appointment:', error);
                });
        });
    });
});
</script>
