
<!DOCTYPE html>
<html lang="en">

<head>

	<!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Preclinic - Medical & Hospital - Bootstrap 5 Admin Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="author" content="Dreams Technologies">
	
    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/img/favicon.png">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="assets/img/apple-icon.png">

    <!-- Theme Config Js -->
    <script src="assets/js/theme-script.js"></script>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <!-- Glightbox CSS -->
    <link rel="stylesheet" href="assets/plugins/lightbox/glightbox.min.css">

    <!-- Tabler Icon CSS -->
    <link rel="stylesheet" href="assets/plugins/tabler-icons/tabler-icons.min.css">

    <!-- Simplebar CSS -->
    <link rel="stylesheet" href="assets/plugins/simplebar/simplebar.min.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="assets/css/style.css" id="app-style">

</head>

<body>

    <!-- Begin Wrapper -->
    <div class="main-wrapper">

        <!-- Topbar Start -->
        <header class="navbar-header">
            <div class="page-container topbar-menu">
                <div class="d-flex align-items-center gap-2">

                    <!-- Logo -->
                    <a href="index.html" class="logo">

                        <!-- Logo Normal -->
                        <span class="logo-light">
                            <span class="logo-lg"><img src="assets/img/logo.svg" alt="logo"></span>
                            <span class="logo-sm"><img src="assets/img/logo-small.svg" alt="small logo"></span>
                        </span>

                        <!-- Logo Dark -->
                        <span class="logo-dark">
                            <span class="logo-lg"><img src="assets/img/logo-white.svg" alt="dark logo"></span>
                        </span>
                    </a>

                    <!-- Sidebar Mobile Button -->
                    <a id="mobile_btn" class="mobile-btn" href="#sidebar">
                        <i class="ti ti-menu-deep fs-24"></i>
                    </a>
                       
                    <button class="sidenav-toggle-btn btn border-0 p-0 active" id="toggle_btn2"> 
                        <i class="ti ti-arrow-right"></i>
                    </button>  
					
                    <!-- Search -->
                    <div class="me-auto d-flex align-items-center header-search d-lg-flex d-none">
                        <!-- Search -->
                        <div class="input-icon-start position-relative me-2">
                            <span class="input-icon-addon">
                                <i class="ti ti-search"></i>
                            </span>
                           <input type="text" class="form-control shadow-sm" placeholder="Search">
                           <span class="input-icon-addon text-dark shadow fs-18 d-inline-flex p-0 header-search-icon"><i class="ti ti-command"></i></span>
                        </div>
                        <!-- /Search -->
                    </div>
					
                </div>

                <div class="d-flex align-items-center">
				
                    <!-- Search for Mobile -->
                    <div class="header-item d-flex d-lg-none me-2">
                        <button class="topbar-link btn btn-icon" data-bs-toggle="modal" data-bs-target="#searchModal" type="button">
                            <i class="ti ti-search fs-16"></i>
                        </button>
                    </div>
					
                    <!-- AI Assistance -->
					<a href="javascript:void(0);" class="btn btn-liner-gradient me-3 d-lg-flex d-none">AI Assistance<i class="ti ti-chart-bubble-filled ms-1"></i></a>
                    <!-- AI Assistance -->

                    <!-- Appointment -->
                    <div class="header-item">
                        <div class="dropdown me-2">
                            <a href="new-appointment.html" class="btn topbar-link"><i class="ti ti-calendar-due"></i></a>
                        </div>
                    </div>                    
                    <!-- Appointment -->

                    <!-- Settings -->
                    <div class="header-item">
                        <div class="dropdown me-2">
                            <a href="profile-settings.html" class="btn topbar-link"><i class="ti ti-settings-2"></i></a>
                        </div> 
                    </div> 
                    <!-- Settings -->                   

                    <!-- Light/Dark Mode Button -->
                    <div class="header-item d-none d-sm-flex me-2">
                        <button class="topbar-link btn btn-icon topbar-link" id="light-dark-mode" type="button">
                            <i class="ti ti-moon fs-16"></i>
                        </button>
                    </div>
                    
					
					<!-- Notification Dropdown -->
                    <div class="header-item">
						<div class="dropdown me-3">
						
							<button class="topbar-link btn btn-icon topbar-link dropdown-toggle drop-arrow-none" data-bs-toggle="dropdown" data-bs-offset="0,24" type="button" aria-haspopup="false" aria-expanded="false">
								<i class="ti ti-bell-check fs-16 animate-ring"></i>
								<span class="notification-badge"></span>
							</button>
							
							<div class="dropdown-menu p-0 dropdown-menu-end dropdown-menu-lg" style="min-height: 300px;">
							
								<div class="p-2 border-bottom">
									<div class="row align-items-center">
										<div class="col">
											<h6 class="m-0 fs-16 fw-semibold"> Notifications</h6>
										</div>
									</div>
								</div>
								
								<!-- Notification Body -->
								<div class="notification-body position-relative z-2 rounded-0" data-simplebar>
								 
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-1">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-01.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Dr. Smith</p>
												<p class="mb-1 text-wrap">
													updated the <span class="fw-medium text-dark">surgery</span> schedule. 
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>4 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-1">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
							
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-2">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-06.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Dr. Patel</p>
												<p class="mb-1 text-wrap">
                                                    completed a <span class="fw-medium text-dark">follow-up</span> report for patient <span class="fw-medium text-dark">Emily</span>.
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>8 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-2">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-3">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-02.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Emily</p>
												<p class="mb-1 text-wrap">
                                                    booked an appointment with <span class="fw-medium text-dark">Dr. Patel</span> for <span class="fw-medium text-dark">April 15</span>
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>15 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-3">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap" id="notification-4">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-07.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Amelia</p>
												<p class="mb-1 text-wrap">
                                                    completed the <span class="fw-medium text-dark">pre-visit</span> health questionnaire.
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>20 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-4">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									 
								</div>
								
								<!-- View All-->
								<div class="p-2 rounded-bottom border-top text-center">
									<a href="notifications.html" class="text-center text-decoration-underline fs-14 mb-0">
										View All Notifications
									</a>
								</div>
								
							</div>
						</div>
					</div>
					
					<!-- User Dropdown -->
					<div class="dropdown profile-dropdown d-flex align-items-center justify-content-center">
                        <a href="javascript:void(0);" class="topbar-link dropdown-toggle drop-arrow-none position-relative" data-bs-toggle="dropdown" data-bs-offset="0,22" aria-haspopup="false" aria-expanded="false">
                            <img src="assets/img/users/user-01.jpg" width="32" class="rounded-circle d-flex" alt="user-image">
                            <span class="online text-success"><i class="ti ti-circle-filled d-flex bg-white rounded-circle border border-1 border-white"></i></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end dropdown-menu-md p-2">
                        
                            <div class="d-flex align-items-center bg-light rounded-3 p-2 mb-2">
                                <img src="assets/img/users/user-01.jpg" class="rounded-circle" width="42" height="42" alt="">
                                <div class="ms-2">
                                    <p class="fw-medium text-dark mb-0">Jimmy Anderson</p>
                                    <span class="d-block fs-13">Administrator</span>
                                </div>
                            </div>

                            <!-- Item-->
                            <a href="profile-settings.html" class="dropdown-item">
                                <i class="ti ti-user-circle me-1 align-middle"></i>
                                <span class="align-middle">Profile Settings</span>
                            </a>

                            <!-- Item-->
                            <a href="account-settings.html" class="dropdown-item">
                                <i class="ti ti-settings me-1 align-middle"></i>
                                <span class="align-middle">Account Settings</span>
                            </a>

                            <!-- item -->
                            <div class="form-check form-switch form-check-reverse d-flex align-items-center justify-content-between dropdown-item mb-0">
                                <label class="form-check-label" for="notify"><i class="ti ti-bell me-1"></i>Notifications</label>
                                <input class="form-check-input me-0" type="checkbox" role="switch" id="notify">
                            </div>

                            <!-- Item-->
                            <a href="transactions.html" class="dropdown-item">
                                <i class="ti ti-transition-right me-1 align-middle"></i>
                                <span class="align-middle">Transactions</span>
                            </a>

                                        
                            
                            <!-- Item-->
                            <div class="pt-2 mt-2 border-top">
                                <a href="login.html" class="dropdown-item text-danger">
                                    <i class="ti ti-logout me-1 fs-17 align-middle"></i>
                                    <span class="align-middle">Log Out</span>
                                </a>
                            </div>
                        </div>
                    </div>
						
                </div>
            </div>
        </header>
        <!-- Topbar End -->

        <!-- Search Modal -->
        <div class="modal fade" id="searchModal">
            <div class="modal-dialog modal-lg">
                <div class="modal-content bg-transparent">
                    <div class="card shadow-none mb-0">
                        <div class="px-3 py-2 d-flex flex-row align-items-center" id="search-top">
                            <i class="ti ti-search fs-22"></i>
                            <input type="search" class="form-control border-0" placeholder="Search">
                            <button type="button" class="btn p-0" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-x fs-22"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidenav Menu Start -->
        <div class="sidebar" id="sidebar">
            
            <!-- Start Logo -->
            <div class="sidebar-logo">
                <div>
                    <!-- Logo Normal -->
                    <a href="index.html" class="logo logo-normal">
                        <img src="assets/img/logo.svg" alt="Logo">
                    </a>

                    <!-- Logo Small -->
                    <a href="index.html" class="logo-small">
                        <img src="assets/img/logo-small.svg" alt="Logo">
                    </a>

                    <!-- Logo Dark -->
                    <a href="index.html" class="dark-logo">
                        <img src="assets/img/logo-white.svg" alt="Logo">
                    </a>
                </div>
                <button class="sidenav-toggle-btn btn border-0 p-0 active" id="toggle_btn"> 
                    <i class="ti ti-arrow-left"></i>
                </button>

                <!-- Sidebar Menu Close -->
                <button class="sidebar-close">
                    <i class="ti ti-x align-middle"></i>
                </button>                
            </div>
            <!-- End Logo -->

            <!-- Sidenav Menu -->
            <div class="sidebar-inner" data-simplebar>                
                <div id="sidebar-menu" class="sidebar-menu">
                    <div class="sidebar-top shadow-sm p-2 rounded-1 mb-3 dropend">
                        <a href="javascript:void(0);" class="drop-arrow-none" data-bs-toggle="dropdown" data-bs-auto-close="outside" data-bs-offset="0,22" aria-haspopup="false" aria-expanded="false">
                            <div class="d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center">
                                    <span class="avatar rounded-circle flex-shrink-0 p-2"><img src="./assets/img/icons/trustcare.svg" alt="img"></span>
                                    <div class="ms-2">
                                        <h6 class="fs-14 fw-semibold mb-0">Trustcare Clinic</h6>
                                        <p class="fs-13 mb-0">Lasvegas</p>
                                    </div>
                                </div>
                                <i class="ti ti-arrows-transfer-up"></i>                            
                            </div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-lg">
                            <div class="p-2"> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-01.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">CureWell Medical Hub<small class="d-block text-muted fw-normal fs-13">Ohio</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-02.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">Trustcare Clinic<small class="d-block text-muted fw-normal fs-13">Lasvegas</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-03.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">NovaCare Medical<small class="d-block text-muted fw-normal fs-13">Washington</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                                <label class="dropdown-item d-flex align-items-center justify-content-between p-1">
                                    <span class="d-flex align-items-center">
                                        <span class="me-2"><img src="assets/img/icons/clinic-04.svg" alt=""></span>
                                        <span class="fw-semibold text-dark">Greeny Medical Clinic<small class="d-block text-muted fw-normal fs-13">Illinios</small></span>
                                    </span>
                                    <input class="form-check-input m-0 me-2" type="checkbox">
                                </label> 
                            </div>
                        </div>
                    </div>
                    <ul>
                        <li class="menu-title"><span>Main Menu</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-layout-dashboard"></i><span>Dashboard</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="index.html">Admin Dashboard</a></li>
                                        <li><a href="doctor-dashboard.html">Doctor Dashboard</a></li>
                                        <li><a href="patient-dashboard.html">Patient Dashboard</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-apps"></i><span>Applications</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="chat.html">Chat</a></li>
                                        <li class="submenu submenu-two">
                                            <a href="#">Calls<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="voice-call.html">Voice Call</a></li>
                                                <li><a href="video-call.html">Video Call</a></li>
                                                <li><a href="outgoing-call.html">Outgoing Call</a></li>
                                                <li><a href="incoming-call.html">Incoming Call</a></li>
                                                <li><a href="call-history.html">Call History</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="calendar.html">Calendar</a></li>
                                        <li><a href="contacts.html">Contacts</a></li>		
                                        <li><a href="email.html">Email</a></li>
                                        <li class="submenu submenu-two">
                                            <a href="#">Invoices<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="invoice.html">Invoices</a></li>
                                                <li><a href="invoice-details.html">Invoice Details</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="todo.html">To Do</a></li>
                                        <li><a href="notes.html">Notes</a></li>
                                        <li><a href="kanban-view.html">Kanban Board</a></li>
                                        <li><a href="file-manager.html">File Manager</a></li>
                                        <li><a href="social-feed.html">Social Feed</a></li>
                                        <li><a href="search-list.html">Search Result</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="../../frontend/index.html" target="_blank">
                                        <i class="ti ti-world"></i><span>Frontend</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-layout-sidebar"></i><span>Layouts</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="index.html">Default</a></li>
                                        <li><a href="layout-mini.html">Mini</a></li>
                                        <li><a href="layout-hover-view.html">Hover View</a></li>
                                        <li><a href="layout-hidden.html">Hidden</a></li>
                                        <li><a href="layout-full-width.html">Full Width</a></li>
                                        <li><a href="layout-rtl.html">RTL</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Clinic</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-user-plus"></i><span>Doctors</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="doctors.html">Doctors</a></li>
                                        <li><a href="doctor-details.html">Doctor Details</a></li>
                                        <li><a href="add-doctor.html">Add Doctor</a></li>
                                        <li><a href="doctor-schedule.html">Doctor Schedule</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-user-heart"></i><span>Patients</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="patients.html">Patients</a></li>
                                        <li><a href="patient-details.html">Patient Details</a></li>
                                        <li><a href="create-patient.html">Create Patient</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-calendar-check"></i><span>Appointments</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="appointments.html">Appointments</a></li>
                                        <li><a href="new-appointment.html">New Appointment</a></li>
                                        <li><a href="appointment-calendar.html">Calendar</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="locations.html">
                                        <i class="ti ti-map-pin"></i><span>Locations</span>
                                    </a>
                                </li>  
                                <li>
                                    <a href="services.html">
                                        <i class="ti ti-user-cog"></i><span>Services</span>
                                    </a>
                                </li>  
                                <li>
                                    <a href="specializations.html">
                                        <i class="ti ti-user-shield"></i><span>Specializations</span>
                                    </a>
                                </li> 
                                <li>
                                    <a href="assets.html">
                                        <i class="ti ti-asset"></i><span>Assets</span>
                                    </a>
                                </li>  
                                <li>
                                    <a href="activities.html">
                                        <i class="ti ti-activity"></i><span>Activities</span>
                                    </a>
                                </li> 
                                <li>
                                    <a href="messages.html">
                                        <i class="ti ti-messages"></i><span>Messages</span>
                                    </a>
                                </li>                           
                            </ul>
                        </li>
                        <li class="menu-title"><span>HRM</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="staffs.html">
                                        <i class="ti ti-users-group"></i><span>Staffs</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="hrm-departments.html">
                                        <i class="ti ti-building-bank"></i><span>Departments</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="designation.html">
                                        <i class="ti ti-user-cog"></i><span>Designation</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="attendance.html">
                                        <i class="ti ti-user-check"></i><span>Attendance</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-users-minus"></i><span>Leaves</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="leaves.html">Leaves</a></li>
                                        <li><a href="leave-type.html">Leave Type</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="holidays.html">
                                        <i class="ti ti-home-exclamation"></i><span>Holidays</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="payroll.html">
                                        <i class="ti ti-coin"></i><span>Payroll</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Finance & Accounts</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-credit-card"></i><span>Expenses</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="expenses.html">Expenses</a></li>
                                        <li><a href="expense-category.html">Expense Category</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="income.html">
                                        <i class="ti ti-coins"></i><span>Income</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-file-invoice"></i><span>Invoices</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="invoices.html">Invoices</a></li>
                                        <li><a href="invoices-details.html">Invoice Details</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="payments.html">
                                        <i class="ti ti-cards"></i><span>Payments</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="transactions.html">
                                        <i class="ti ti-transition-right"></i><span>Transactions</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Administration</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-user"></i><span>Users</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="roles-and-permissions.html">Roles & Permissions</a></li>
                                        <li><a href="delete-account-request.html">Delete Account Request</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-report"></i><span>Reports</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="income-report.html">Income Report</a></li>
                                        <li><a href="expense-report.html">Expense Report</a></li>
                                        <li><a href="profit-and-loss.html">Profit & Loss</a></li>
                                        <li><a href="appointment-report.html">Appointment Report</a></li>
                                        <li><a href="patient-report.html">Patient Report</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Content</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="pages.html">
                                        <i class="ti ti-brand-pagekit"></i><span>Pages</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-brand-blogger"></i><span>Blogs</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="add-blog.html">Add Blog</a></li>
                                        <li><a href="blogs.html">Blogs</a></li>
                                        <li><a href="blog-categories.html">Blog Categories</a></li>
                                        <li><a href="blog-comments.html">Blog Comments</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-map-pins"></i><span>Location</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="countries.html">Countries</a></li>
                                        <li><a href="states.html">States</a></li>
                                        <li><a href="cities.html">Cities</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="testimonials.html">
                                        <i class="ti ti-brand-wechat"></i><span>Testimonials</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="faq.html">
                                        <i class="ti ti-question-mark"></i><span>FAQ</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Support</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="contact-messages.html">
                                        <i class="ti ti-message-dots"></i><span>Contact Messages</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="tickets.html">
                                        <i class="ti ti-ticket"></i><span>Tickets</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="announcements.html">
                                        <i class="ti ti-speakerphone"></i><span>Announcements</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="newsletters.html">
                                        <i class="ti ti-mail-bolt"></i><span>Newsletters</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Pages</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="starter.html">
                                        <i class="ti ti-player-play"></i><span>Starter</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="profile.html">
                                        <i class="ti ti-user-circle"></i><span>Profile</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="gallery.html">
                                        <i class="ti ti-photo"></i><span>Gallery</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="timeline.html">
                                        <i class="ti ti-timeline-event-text"></i><span>Timeline</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="pricing.html">
                                        <i class="ti ti-tag"></i><span>Pricing</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="coming-soon.html">
                                        <i class="ti ti-sparkles"></i><span>Coming Soon</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="under-maintenance.html">
                                        <i class="ti ti-settings-down"></i><span>Under Maintenance</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="privacy-policy.html">
                                        <i class="ti ti-shield-check"></i><span>Privacy Policy</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="terms-and-conditions.html">
                                        <i class="ti ti-file-time"></i><span>Terms & Conditions</span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Authentication</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-login"></i><span>Login</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="login-cover.html">Cover</a></li>
                                        <li><a href="login-illustration.html">Illustration</a></li>
                                        <li><a href="login-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-file-pencil"></i><span>Register</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="register-cover.html">Cover</a></li>
                                        <li><a href="register-illustration.html">Illustration</a></li>
                                        <li><a href="register-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-lock-exclamation"></i><span>Forgot Password</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="forgot-password-cover.html">Cover</a></li>
                                        <li><a href="forgot-password-illustration.html">Illustration</a></li>
                                        <li><a href="forgot-password-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-restore"></i><span>Reset Password</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="reset-password-cover.html">Cover</a></li>
                                        <li><a href="reset-password-illustration.html">Illustration</a></li>
                                        <li><a href="reset-password-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-mail-check"></i><span>Email Verification</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="email-verification-cover.html">Cover</a></li>
                                        <li><a href="email-verification-illustration.html">Illustration</a></li>
                                        <li><a href="email-verification-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-discount-check"></i><span>2 Step Verification</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="two-step-verification-cover.html">Cover</a></li>
                                        <li><a href="two-step-verification-illustration.html">Illustration</a></li>
                                        <li><a href="two-step-verification-basic.html">Basic</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="lock-screen.html">
                                        <i class="ti ti-lock"></i><span>Lock Screen</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-exclamation-mark-off"></i><span>Error Pages</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="error-404.html">404 Error</a></li>
                                        <li><a href="error-500.html">500 Error</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Settings</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-user-cog"></i><span>Account Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="profile-settings.html">Profile</a></li>
                                        <li><a href="security-settings.html">Security</a></li>
                                        <li><a href="notifications-settings.html">Notifications</a></li>
                                        <li><a href="integrations-settings.html">Integrations</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-world-cog"></i><span>Website Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="organization-settings.html">Organization</a></li>
                                        <li><a href="localization-settings.html">Localization</a></li>
                                        <li><a href="prefixes-settings.html">Prefixes</a></li>
                                        <li><a href="seo-setup-settings.html">SEO Setup</a></li>
                                        <li><a href="language-settings.html">Language</a></li>
                                        <li><a href="maintenance-mode-settings.html">Maintenance Mode</a></li>
                                        <li><a href="login-and-register-settings.html">Login & Register</a></li>
                                        <li><a href="preferences-settings.html">Preferences</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-building-hospital"></i><span>Clinic Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="appointment-settings.html">Appointment</a></li>
                                        <li><a href="working-hours-settings.html">Working Hours</a></li>
                                        <li><a href="cancellation-reason-settings.html">Cancellation Reason</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-device-mobile-cog"></i><span>App Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="invoice-settings.html">Invoice Settings</a></li>
                                        <li><a href="invoice-templates-settings.html">Invoice Templates</a></li>
                                        <li><a href="signatures-settings.html">Signatures</a></li>
                                        <li><a href="custom-fields-settings.html">Custom Fields</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-device-desktop-cog"></i><span>System Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="email-settings.html">Email Settings</a></li>
                                        <li><a href="email-templates-settings.html">Email Templates</a></li>
                                        <li><a href="sms-gateways-settings.html">SMS Gateways</a></li>
                                        <li><a href="sms-templates-settings.html">SMS Templates</a></li>
                                        <li><a href="gdpr-cookies-settings.html">GDPR Cookies</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-settings-dollar"></i><span>Finance & Accounts</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="payment-methods-settings.html">Payment Methods</a></li>
                                        <li><a href="bank-accounts-settings.html">Bank Accounts</a></li>
                                        <li><a href="tax-rates-settings.html">Tax Rates</a></li>
                                        <li><a href="currencies-settings.html">Currencies</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-settings-2"></i><span>Other Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="sitemap-settings.html">Sitemap</a></li>
                                        <li><a href="clear-cache-settings.html">Clear Cache</a></li>
                                        <li><a href="storage-settings.html">Storage</a></li>
                                        <li><a href="cronjob-settings.html">Cronjob</a></li>
                                        <li><a href="ban-ip-address-settings.html">Ban IP Address</a></li>
                                        <li><a href="system-backup-settings.html">System Backup</a></li>
                                        <li><a href="database-backup-settings.html">Database Backup</a></li>
                                        <li><a href="system-update.html">System Update</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>UI Interface</span></li>
                        <li>
                            <ul>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-chart-pie"></i><span>Base UI</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="ui-accordion.html">Accordion</a></li>
                                        <li><a href="ui-alerts.html">Alerts</a></li>
                                        <li><a href="ui-avatar.html">Avatar</a></li>
                                        <li><a href="ui-badges.html">Badges</a></li>
                                        <li><a href="ui-breadcrumb.html">Breadcrumb</a></li>
                                        <li><a href="ui-buttons.html">Buttons</a></li>
                                        <li><a href="ui-buttons-group.html">Button Group</a></li>
                                        <li><a href="ui-cards.html">Card</a></li>
                                        <li><a href="ui-carousel.html">Carousel</a></li>
                                        <li><a href="ui-collapse.html">Collapse</a></li>
                                        <li><a href="ui-dropdowns.html">Dropdowns</a></li>
                                        <li><a href="ui-ratio.html">Ratio</a></li>
                                        <li><a href="ui-grid.html">Grid</a></li>
                                        <li><a href="ui-images.html">Images</a></li>
                                        <li><a href="ui-links.html">Links</a></li>
                                        <li><a href="ui-list-group.html">List Group</a></li>
                                        <li><a href="ui-modals.html">Modals</a></li>
                                        <li><a href="ui-offcanvas.html">Offcanvas</a></li>
                                        <li><a href="ui-pagination.html">Pagination</a></li>
                                        <li><a href="ui-placeholders.html">Placeholders</a></li>
                                        <li><a href="ui-popovers.html">Popovers</a></li>
                                        <li><a href="ui-progress.html">Progress</a></li>
                                        <li><a href="ui-scrollspy.html">Scrollspy</a></li>
                                        <li><a href="ui-spinner.html">Spinner</a></li>
                                        <li><a href="ui-nav-tabs.html">Tabs</a></li>
                                        <li><a href="ui-toasts.html">Toasts</a></li>
                                        <li><a href="ui-tooltips.html">Tooltips</a></li>
                                        <li><a href="ui-typography.html">Typography</a></li>
                                        <li><a href="ui-utilities.html">Utilities</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-radar"></i><span>Advanced UI</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="extended-dragula.html">Dragula</a></li>
                                        <li><a href="ui-clipboard.html">Clipboard</a></li>
                                        <li><a href="ui-rangeslider.html">Range Slider</a></li>
                                        <li><a href="ui-sweetalerts.html">Sweet Alerts</a></li>
										<li><a href="ui-lightbox.html">Lightbox</a></li>
										<li><a href="ui-rating.html">Rating</a></li>
										<li><a href="ui-scrollbar.html">Scrollbar</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-forms"></i><span>Forms</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li class="submenu submenu-two">
                                            <a href="javascript:void(0);">Form Elements<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="form-basic-inputs.html">Basic Inputs</a></li>
                                                <li><a href="form-checkbox-radios.html">Checkbox & Radios</a></li>
                                                <li><a href="form-input-groups.html">Input Groups</a></li>
                                                <li><a href="form-grid-gutters.html">Grid & Gutters</a></li>
                                                <li><a href="form-mask.html">Input Masks</a></li>
                                                <li><a href="form-fileupload.html">File Uploads</a></li>
                                            </ul>
                                        </li>
                                        <li class="submenu submenu-two">
                                            <a href="javascript:void(0);">Layouts<span class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="form-horizontal.html">Horizontal Form</a></li>
                                                <li><a href="form-vertical.html">Vertical Form</a></li>
                                                <li><a href="form-floating-labels.html">Floating Labels</a></li>
                                            </ul>
                                        </li>
                                        <li><a href="form-validation.html">Form Validation</a></li>
                                        <li><a href="form-select2.html">Select2</a></li>
                                        <li><a href="form-wizard.html">Form Wizard</a></li>
                                        <li><a href="form-pickers.html">Form Picker</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-table-row"></i><span>Tables</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="tables-basic.html">Basic Tables </a></li>
                                        <li><a href="data-tables.html">Data Table </a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-chart-donut"></i>
                                        <span>Charts</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="chart-apex.html">Apex Charts</a></li>
                                        <li><a href="chart-c3.html">Chart C3</a></li>
                                        <li><a href="chart-js.html">Chart Js</a></li>
                                        <li><a href="chart-morris.html">Morris Charts</a></li>
                                        <li><a href="chart-flot.html">Flot Charts</a></li>
                                        <li><a href="chart-peity.html">Peity Charts</a></li>
                                    </ul>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-icons"></i>
                                        <span>Icons</span><span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="icon-fontawesome.html">Fontawesome Icons</a></li>
                                        <li><a href="icon-tabler.html">Tabler Icons</a></li>
                                        <li><a href="icon-bootstrap.html">Bootstrap Icons</a></li>
                                        <li><a href="icon-remix.html">Remix Icons</a></li>
                                        <li><a href="icon-feather.html">Feather Icons</a></li>
                                        <li><a href="icon-ionic.html">Ionic Icons</a></li>
                                        <li><a href="icon-material.html">Material Icons</a></li>
                                        <li><a href="icon-pe7.html">Pe7 Icons</a></li>
                                        <li><a href="icon-simpleline.html">Simpleline Icons</a></li>
                                        <li><a href="icon-themify.html">Themify Icons</a></li>
                                        <li><a href="icon-weather.html">Weather Icons</a></li>
                                        <li><a href="icon-typicons.html">Typicons Icons</a></li>
                                        <li><a href="icon-flag.html">Flag Icons</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li class="menu-title"><span>Help</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="javascript:void(0);"><i class="ti ti-file-dots"></i><span>Documentation</span></a>
                                </li>
                                <li>
                                    <a href="javascript:void(0);"><i class="ti ti-status-change"></i><span>Changelog</span><span class="badge bg-danger ms-2 badge-md rounded-2 fs-12 fw-medium">v1.6.7</span></a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-versions"></i><span>Multi Level</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="javascript:void(0);">Multilevel 1</a></li>
                                        <li class="submenu submenu-two">
                                            <a href="javascript:void(0);">Multilevel 2<span
                                                    class="menu-arrow inside-submenu"></span></a>
                                            <ul>
                                                <li><a href="javascript:void(0);">Multilevel 2.1</a></li>
                                                <li class="submenu submenu-two submenu-three">
                                                    <a href="javascript:void(0);">Multilevel 2.2<span
                                                            class="menu-arrow inside-submenu inside-submenu-two"></span></a>
                                                    <ul>
                                                        <li><a href="javascript:void(0);">Multilevel 2.2.1</a></li>
                                                        <li><a href="javascript:void(0);">Multilevel 2.2.2</a></li>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </li>
                                        <li><a href="javascript:void(0);">Multilevel 3</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>                        
                    </ul>                   
                </div>
                <div class="sidebar-footer border-top mt-3">
                    <div class="trial-item mt-0 p-3 text-center">
                        <div class="trial-item-icon rounded-4 mb-3 p-2 text-center shadow-sm d-inline-flex">
                            <img src="./assets/img/icons/sidebar-icon.svg" alt="img">
                        </div>
                        <div>
                            <h6 class="fs-14 fw-semibold mb-1">Upgrade To Pro</h6>
                            <p class="fs-13 mb-0">Check 1 min video and begin use Preclinic like a pro</p>
                        </div>
                        <a href="javascript:void(0);" class="close-icon shadow-sm"><i class="ti ti-x"></i></a>
                    </div>
                </div>
            </div>

        </div>
        <!-- Sidenav Menu End -->

        <!-- ========================
			Start Page Content
		========================= -->
         
        <div class="page-wrapper">

            <!-- Start Content -->
            <div class="content">

                <!-- Page Header -->
                <div class="mb-4">
                    <h4 class="mb-0 fw-bold">Widgets</h4>
				</div>
				<!-- End Page Header -->
                
                <!-- start row -->
                <div class="row">
                    <div class="col-xl-3 col-md-6">
                        <div class="position-relative border card rounded-2 shadow-sm">
                            <img src="./assets/img/bg/bg-01.svg" alt="img" class="position-absolute start-0 top-0">
                           <div class="card-body">
                               <div class="d-flex align-items-center mb-2 justify-content-between">
                                  <span class="avatar bg-primary rounded-circle"><i class="ti ti-calendar-heart fs-24"></i></span>
                                  <div class="text-end">
                                    <span class="badge px-2 py-1 fs-12 fw-medium d-inline-flex mb-1 bg-success">+95%</span>
                                    <p class="fs-13 mb-0">in last 7 Days </p>
                                  </div>
                               </div>
                               <div class="d-flex align-items-center justify-content-between">
                                   <div>
                                     <p class="mb-1">Doctors</p>
                                     <h3 class="fw-bold mb-0">247</h3>
                                   </div>
                                   <div>
                                     <div id="s-col" class="chart-set"></div>
                                   </div>
                               </div>
                           </div>
                        </div>
                    </div>
                    <!-- end col -->
                    <div class="col-xl-3 col-md-6">
                        <div class="position-relative border card rounded-2 shadow-sm">
                            <img src="./assets/img/bg/bg-02.svg" alt="img" class="position-absolute start-0 top-0">
                           <div class="card-body">
                               <div class="d-flex align-items-center mb-2 justify-content-between">
                                  <span class="avatar bg-danger rounded-circle"><i class="ti ti-calendar-heart fs-24"></i></span>
                                  <div class="text-end">
                                    <span class="badge px-2 py-1 fs-12 fw-medium d-inline-flex mb-1 bg-success">+25%</span>
                                    <p class="fs-13 mb-0">in last 7 Days </p>
                                  </div>
                               </div>
                               <div class="d-flex align-items-center justify-content-between">
                                   <div>
                                     <p class="mb-1">Patients</p>
                                     <h3 class="fw-bold mb-0">4178</h3>
                                   </div>
                                   <div>
                                     <div id="s-col-2" class="chart-set"></div>
                                   </div>
                               </div>
                           </div>
                        </div>
                    </div>
                    <!-- end col -->
                    <div class="col-xl-3 col-md-6">
                        <div class="position-relative border card rounded-2 shadow-sm">
                            <img src="./assets/img/bg/bg-03.svg" alt="img" class="position-absolute start-0 top-0">
                           <div class="card-body">
                               <div class="d-flex align-items-center mb-2 justify-content-between">
                                  <span class="avatar bg-info rounded-circle"><i class="ti ti-calendar-heart fs-24"></i></span>
                                  <div class="text-end">
                                    <span class="badge px-2 py-1 fs-12 fw-medium d-inline-flex mb-1 bg-danger">-15%</span>
                                    <p class="fs-13 mb-0">in last 7 Days </p>
                                  </div>
                               </div>
                               <div class="d-flex align-items-center justify-content-between">
                                   <div>
                                     <p class="mb-1">Appointment</p>
                                     <h3 class="fw-bold mb-0">12178</h3>
                                   </div>
                                   <div>
                                     <div id="s-col-3" class="chart-set"></div>
                                   </div>
                               </div>
                           </div>
                        </div>
                    </div>
                    <!-- end col -->
                    <div class="col-xl-3 col-md-6">
                        <div class="position-relative border card rounded-2 shadow-sm">
                            <img src="./assets/img/bg/bg-04.svg" alt="img" class="position-absolute start-0 top-0">
                           <div class="card-body">
                               <div class="d-flex align-items-center mb-2 justify-content-between">
                                  <span class="avatar bg-success rounded-circle"><i class="ti ti-calendar-heart fs-24"></i></span>
                                  <div class="text-end">
                                    <span class="badge px-2 py-1 fs-12 fw-medium d-inline-flex mb-1 bg-success">+25%</span>
                                    <p class="fs-13 mb-0">in last 7 Days </p>
                                  </div>
                               </div>
                               <div class="d-flex align-items-center justify-content-between overflow-hidden">
                                   <div>
                                     <p class="mb-1">Revenue</p>
                                     <h3 class="fw-bold mb-0 text-truncate">$55,1240</h3>
                                   </div>
                                   <div>
                                     <div id="s-col-4" class="chart-set"></div>
                                   </div>
                               </div>
                           </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>
                 <!-- end row -->

                <!-- start row -->
                <div class="row">
                  <!-- col start -->
                  <div class="col-xl-4 d-flex">
                     <div class="card shadow-sm flex-fill w-100">
                        <div class="card-header d-flex align-items-center justify-content-between">
                           <h5 class="fw-bold mb-0">Top 3 Departments</h5> 
                            <div class="dropdown">
                                <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"  data-bs-toggle="dropdown">
                                    Weekly <i class="ti ti-chevron-down ms-1"></i>
                                </a>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a class="dropdown-item" href="#">Monthly</a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">Weekly</a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">Yearly</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="circle-chart" class="chart-set"></div>  
                            <div class="d-flex align-items-center flex-wrap justify-content-center gap-2 mt-3">
                                <p class="d-flex align-items-center mb-0 fs-13"><i class="ti ti-circle-filled text-info fs-10 me-1"></i><span class="text-dark fw-semibold me-1">214</span> Cardiology</p>
                                <p class="d-flex align-items-center mb-0 fs-13"><i class="ti ti-circle-filled text-purple fs-10 me-1"></i><span class="text-dark fw-semibold me-1">150</span> Dental</p>
                                <p class="d-flex align-items-center mb-0 fs-13"><i class="ti ti-circle-filled text-primary fs-10 me-1"></i><span class="text-dark fw-semibold me-1">121</span> Neurolgy</p>
                            </div>
                        </div>                        
                     </div>
                  </div>
                  <!-- col end -->

                  <!-- col start -->
                  <div class="col-xl-4 col-lg-6 d-flex">
                    <div class="card shadow-sm flex-fill w-100">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="fw-bold mb-0">Doctors Schedule</h5> 
                            <a href="doctor-schedule.html" class="btn fw-normal btn-outline-white">View All</a>
                        </div>
                        <div class="card-body">
                            <div class="row g-2 mb-4">
                                <div class="col d-flex border-end">
                                    <div class="text-center flex-fill">
                                        <p class="mb-1">Available</p>
                                        <h3 class="fw-bold mb-0">48</h3>
                                    </div>
                                </div>
                                <div class="col d-flex border-end">
                                    <div class="text-center flex-fill">
                                        <p class="mb-1">Unavailable</p>
                                        <h3 class="fw-bold mb-0">28</h3>
                                    </div>
                                </div>
                                <div class="col d-flex">
                                    <div class="text-center flex-fill">
                                        <p class="mb-1">Leave</p>
                                        <h3 class="fw-bold mb-0">12</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="overflow-auto">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-02.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2 flex-shrink-0">
                                            <div>
                                                <h6 class="fw-semibold fs-14 text-truncate mb-1"><a href="doctor-details.html">Dr. Sarah Johnson</a></h6>
                                                <p class="fs-13">Orthopedic Surgeon</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-shrink-0 ms-2">
                                      <a href="#" class="btn btn-primary btn-sm py-1 flex-shrink-0">Book Now</a> 
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-03.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2 flex-shrink-0">
                                            <div>
                                                <h6 class="fw-semibold fs-14 text-truncate mb-1"><a href="doctor-details.html">Dr. Emily Carter</a></h6>
                                                <p class="fs-13">Pediatrician</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-shrink-0 ms-2">
                                      <a href="#" class="btn btn-primary btn-sm py-1">Book Now</a> 
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-04.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2 flex-shrink-0">
                                            <div>
                                                <h6 class="fw-semibold fs-14 text-truncate mb-1"><a href="doctor-details.html">Dr. David Lee</a></h6>
                                                <p class="fs-13">Gynecologist</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-shrink-0 ms-2">
                                      <a href="#" class="btn btn-primary btn-sm py-1">Book Now</a> 
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-0">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-14.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2 flex-shrink-0">
                                            <div>
                                                <h6 class="fw-semibold fs-14 text-truncate mb-1"><a href="doctor-details.html">Dr. Michael Smith</a></h6>
                                                <p class="fs-13">Cardiologist</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-shrink-0 ms-2">
                                      <a href="#" class="btn btn-primary btn-sm py-1">Book Now</a> 
                                    </div>
                                </div>
                            </div>                            
                        </div>
                    </div>
                  </div>
                  <!-- col end -->

                  <!-- col start -->
                  <div class="col-xl-4 col-lg-6 d-flex">
                    <div class="card shadow-sm flex-fill w-100">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="fw-bold mb-0">Income By Treatment</h5> 
                            <div class="dropdown">
                                <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"  data-bs-toggle="dropdown">
                                    Weekly <i class="ti ti-chevron-down ms-1"></i>
                                </a>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a class="dropdown-item" href="#">Monthly</a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">Weekly</a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#">Yearly</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div>
                                    <p class="fw-semibold mb-1 text-dark">Cardiology</p>
                                    <p class="mb-0">4,556 Apointments</p>
                                </div>
                                <h6 class="fw-bold mb-0">$5,985</h6>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div>
                                    <p class="fw-semibold mb-1 text-dark">Radiology</p>
                                    <p class="mb-0">4,125 Apointments</p>
                                </div>
                                <h6 class="fw-bold mb-0">$5,194</h6>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div>
                                    <p class="fw-semibold mb-1 text-dark">Dental Surgery</p>
                                    <p class="mb-0">1,796 Apointments</p>
                                </div>
                                <h6 class="fw-bold mb-0">$2,716</h6>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div>
                                    <p class="fw-semibold mb-1 text-dark">Orthopaedics</p>
                                    <p class="mb-0">3,827 Apointments</p>
                                </div>
                                <h6 class="fw-bold mb-0">$4,682</h6>
                            </div>
                            <div class="d-flex align-items-center justify-content-between mb-0">
                                <div>
                                    <p class="fw-semibold mb-1 text-dark">General Medicine</p>
                                    <p class="mb-0">9,894 Apointments</p>
                                </div>
                                <h6 class="fw-bold mb-0">$9,450</h6>
                            </div>
                        </div>
                    </div> 
                  </div> 
                  <!-- col end -->     
                </div>
                <!-- end row -->

                <!-- row start -->
                <div class="row">
                    <div class="col-12 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">All Appointments</h5> 
                                <a href="appointments.html" class="btn fw-normal btn-outline-white">View All</a>
                            </div>
                            <div class="card-body">
                                <!-- Table start -->
                                <div class="table-responsive table-nowrap">
                                    <table class="table border">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Doctor</th>
                                                <th>Patient</th>
                                                <th>Date & Time</th>
                                                <th>Mode</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-06.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. John Smith</a></h6>
                                                          <p class="mb-0 fs-13">Neurosurgeon</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-02.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Jesus Adams</a></h6>
                                                          <p class="mb-0 fs-13">+1 41254 45214</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>28 May 2025 - 11:15 AM</td>
                                                <td>Online</td>
                                                <td><span class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Confirmed</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-07.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Lisa White</a></h6>
                                                          <p class="mb-0 fs-13">Oncologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-27.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Ezra Belcher</a></h6>
                                                          <p class="mb-0 fs-13">+1 65895 41247</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>29 May 2025 - 11:30 AM</td>
                                                <td>In-Person</td>
                                                <td><span class="badge fs-13 py-1 badge-soft-danger border border-danger rounded fw-medium">Cancelled</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-10.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Patricia Brown</a></h6>
                                                          <p class="mb-0 fs-13">Pulmonologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-20.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Glen Lentz</a></h6>
                                                          <p class="mb-0 fs-13">+1 62458 45845</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>30 May 2025 - 09:30 AM </td>
                                                <td>Online</td>
                                                <td><span class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Confirmed</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-11.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Rachel Green</a></h6>
                                                          <p class="mb-0 fs-13">Urologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-06.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Bernard Griffith</a></h6>
                                                          <p class="mb-0 fs-13">+1 61422 45214</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>30 May 2025 - 10:00 AM</td>
                                                <td>Online</td>
                                                <td><span class="badge fs-13 py-1 badge-soft-secondary border border-secondary rounded fw-medium">Checked Out</span></td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-14.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Michael Smith</a></h6>
                                                          <p class="mb-0 fs-13">Cardiologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-25.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">John Elsass</a></h6>
                                                          <p class="mb-0 fs-13">+1 47851 26371</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>30 May 2025 - 11:00 AM</td>
                                                <td>Online</td>
                                                <td><span class="badge fs-13 py-1 badge-soft-info border border-info rounded fw-medium">Schedule</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- Table end -->
                            </div>
                        </div> 
                    </div> 
                </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-xl-4 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Top 5 Patients</h5> 
                                <a href="patients.html" class="btn fw-normal btn-outline-white">View All</a>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-02.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Jesus Adams</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Total Paid : $6589</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">80 Appointments</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-27.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Ezra Belcher</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Total Paid : $5632</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">60 Appointments</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-20.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Glen Lentz</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Total Paid : $4125</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">40 Appointments</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-06.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Bernard Griffith</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Total Paid : $3140</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">25 Appointments</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-0">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-25.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">John Elsass</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Total Paid : $2654</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">25 Appointments</span>
                                </div>
                            </div>
                        </div> 
                    </div>
                    <!-- col end -->
                     
                    <!-- col start -->
                    <div class="col-xl-4 col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Recent Transactions</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"  data-bs-toggle="dropdown">
                                        Weekly <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="#">Monthly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Weekly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Yearly</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/icons/stripe.svg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">General Check-up</a></h6>
                                          <p class="mb-0 fs-13 text-truncate"><a href="javascript:void(0);" class="link-primary">#INV5889</a></p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium bg-success flex-shrink-0">+ $234</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/icons/paypal.svg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Online Consultation</a></h6>
                                          <p class="mb-0 fs-13 text-truncate"><a href="javascript:void(0);" class="link-primary">#INV7874</a></p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium bg-success flex-shrink-0">+ $234</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/icons/stripe.svg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Purchase Product</a></h6>
                                          <p class="mb-0 fs-13 text-truncate"><a href="javascript:void(0);" class="link-primary">#INV4458</a></p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium bg-danger flex-shrink-0">- $69</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/icons/paypal.svg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Online Consultation</a></h6>
                                          <p class="mb-0 fs-13 text-truncate"><a href="javascript:void(0);" class="link-primary">#INV5456</a></p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium bg-success flex-shrink-0">+ $234</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mb-0">
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/icons/stripe.svg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Online Consultation</a></h6>
                                          <p class="mb-0 fs-13 text-truncate"><a href="javascript:void(0);" class="link-primary">#INV4557</a></p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium bg-success flex-shrink-0">+ $234</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-4 col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Leave Requests</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center"  data-bs-toggle="dropdown">
                                        Today <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="#">Today</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">This Week</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">This Month</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-16.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2">
                                            <div>
                                                <h6 class="fw-semibold text-truncate mb-1 fs-14"><a href="doctor-details.html">James Allaire</a></h6>
                                                <p class="fs-13 mb-0 text-truncate">4 Days - Personal Reason</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="d-inline-flex bg-soft-danger text-danger p-2 rounded-circle"><i class="ti ti-x fw-bold"></i></a>
                                        <a href="javascript:void(0);" class="d-inline-flex ms-2 text-success p-2 bg-soft-success rounded-circle"><i class="ti ti-check fw-bold"></i></a>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-21.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2">
                                            <div>
                                                <h6 class="fw-semibold text-truncate mb-1 fs-14"><a href="doctor-details.html">Esther Schmidt</a></h6>
                                                <p class="fs-13 mb-0 text-truncate">2 Days - Going to Hospital</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="d-inline-flex bg-soft-danger text-danger p-2 rounded-circle"><i class="ti ti-x fw-bold"></i></a>
                                        <a href="javascript:void(0);" class="d-inline-flex ms-2 text-success p-2 bg-soft-success rounded-circle"><i class="ti ti-check fw-bold"></i></a>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-03.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2">
                                            <div>
                                                <h6 class="fw-semibold text-truncate mb-1 fs-14"><a href="doctor-details.html">Valerie Padgett</a></h6>
                                                <p class="fs-13 mb-0 text-truncate">1 Day - Changing Account</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="d-inline-flex bg-soft-danger text-danger p-2 rounded-circle"><i class="ti ti-x fw-bold"></i></a>
                                        <a href="javascript:void(0);" class="d-inline-flex ms-2 text-success p-2 bg-soft-success rounded-circle"><i class="ti ti-check fw-bold"></i></a>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-02.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2">
                                            <div>
                                                <h6 class="fw-semibold text-truncate mb-1 fs-14"><a href="doctor-details.html">Diane Nash</a></h6>
                                                <p class="fs-13 mb-0 text-truncate">1 Day - Not Well</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="d-inline-flex bg-soft-danger text-danger p-2 rounded-circle"><i class="ti ti-x fw-bold"></i></a>
                                        <a href="javascript:void(0);" class="d-inline-flex ms-2 text-success p-2 bg-soft-success rounded-circle"><i class="ti ti-check fw-bold"></i></a>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between mb-0">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-09.jpg" class="rounded-circle" alt="img">
                                        </a>
                                        <div class="ms-2">
                                            <div>
                                                <h6 class="fw-semibold text-truncate mb-1 fs-14"><a href="doctor-details.html">Sally Cavazos</a></h6>
                                                <p class="fs-13 mb-0 text-truncate">2 Days - Going to Checkup</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <a href="javascript:void(0);" class="d-inline-flex bg-soft-danger text-danger p-2 rounded-circle"><i class="ti ti-x fw-bold"></i></a>
                                        <a href="javascript:void(0);" class="d-inline-flex ms-2 text-success p-2 bg-soft-success rounded-circle"><i class="ti ti-check fw-bold"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- row start -->
                 <div class="row">

                    <!-- col start -->
                    <div class="col-xl-4 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                           <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div>
                                        <p class="mb-1">Total Appointments</p>
                                        <div class="d-flex align-items-center gap-1">
                                            <h3 class="fw-bold mb-0">658</h3>
                                            <span class="badge fw-medium bg-success flex-shrink-0">+95%</span>
                                        </div>
                                    </div>
                                    <span class="avatar border border-primary text-primary rounded-2 flex-shrink-0"><i class="ti ti-calendar-heart fs-20"></i></span>
                                </div>
                                <div class="d-flex align-items-end">
                                    <div id="s-col-5" class="chart-set"></div>
                                    <span class="badge fw-medium badge-soft-success flex-shrink-0 ms-2">+21% <i class="ti ti-arrow-up ms-1"></i></span>
                                    <p class="ms-1 fs-13 text-truncate">in last 7 Days </p>
                                </div>
                           </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-4 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                           <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div>
                                        <p class="mb-1">Online Consultations</p>
                                        <div class="d-flex align-items-center gap-1">
                                            <h3 class="fw-bold mb-0">125</h3>
                                            <span class="badge fw-medium bg-danger flex-shrink-0">-15%</span>
                                        </div>
                                    </div>
                                    <span class="avatar border border-danger text-danger rounded-2 flex-shrink-0"><i class="ti ti-users fs-20"></i></span>
                                </div>
                                <div class="d-flex align-items-end">
                                    <div id="s-col-6" class="chart-set"></div>
                                    <span class="badge fw-medium badge-soft-danger flex-shrink-0 ms-2">+21% <i class="ti ti-arrow-down ms-1"></i></span>
                                    <p class="ms-1 fs-13 text-truncate">in last 7 Days </p>
                                </div>
                           </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-4 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                           <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div>
                                        <p class="mb-1">Cancelled Appointments</p>
                                        <div class="d-flex align-items-center gap-1">
                                            <h3 class="fw-bold mb-0">35</h3>
                                            <span class="badge fw-medium bg-success flex-shrink-0">+45%</span>
                                        </div>
                                    </div>
                                    <span class="avatar border border-success text-success rounded-2 flex-shrink-0"><i class="ti ti-versions fs-20"></i></span>
                                </div>
                                <div class="d-flex align-items-end">
                                    <div id="s-col-7" class="chart-set"></div>
                                    <span class="badge fw-medium badge-soft-success flex-shrink-0 ms-2">+31% <i class="ti ti-arrow-up ms-1"></i></span>
                                    <p class="ms-1 fs-13 text-truncate">in last 7 Days </p>
                                </div>
                           </div>
                        </div>
                    </div>
                    <!-- col end -->

                 </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row row-cols-1 row-cols-xl-6 row-cols-md-3 row-cols-sm-2">

                    <!-- col start -->
                     <div class="col">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <span class="avatar bg-primary rounded-2 fs-20 d-inline-flex mb-2"><i class="ti ti-user"></i></span>
                                <p class="mb-1 text-truncate">Total Patient</p>
                                <h3 class="fw-bold mb-2">658</h3>
                                <p class="mb-0 text-success text-truncate">+31% Last Week</p>
                            </div>
                        </div>
                     </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <span class="avatar bg-secondary rounded-2 fs-20 d-inline-flex mb-2"><i class="ti ti-video"></i></span>
                                <p class="mb-1 text-truncate">Video Consultation</p>
                                <h3 class="fw-bold mb-2">256</h3>
                                <p class="mb-0 text-danger text-truncate">-21% Last Week</p>
                            </div>
                        </div>
                     </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <span class="avatar bg-success rounded-2 fs-20 d-inline-flex mb-2"><i class="ti ti-calendar-up"></i></span>
                                <p class="mb-1 text-truncate">Rescheduled</p>
                                <h3 class="fw-bold mb-2">141</h3>
                                <p class="mb-0 text-success text-truncate">+64% Last Week</p>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <span class="avatar bg-danger rounded-2 fs-20 d-inline-flex mb-2"><i class="ti ti-checklist"></i></span>
                                <p class="mb-1 text-truncate">Pre Visit Bookings</p>
                                <h3 class="fw-bold mb-2">524</h3>
                                <p class="mb-0 text-success text-truncate">+38% Last Week</p>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <span class="avatar bg-info rounded-2 fs-20 d-inline-flex mb-2"><i class="ti ti-calendar-share"></i></span>
                                <p class="mb-1 text-truncate">Walkin Bookings</p>
                                <h3 class="fw-bold mb-2">21</h3>
                                <p class="mb-0 text-success text-truncate">+95% Last Week</p>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <span class="avatar bg-soft-success text-success rounded-2 fs-20 d-inline-flex mb-2"><i class="ti ti-carousel-vertical"></i></span>
                                <p class="mb-1 text-truncate">Follow Ups</p>
                                <h3 class="fw-bold mb-2">451</h3>
                                <p class="mb-0 text-success text-truncate">+76% Last Week</p>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row start -->

                <!-- row start -->
                <div class="row">
                    <div class="col-12 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Recent Appointments</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                        Weekly <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="#">Monthly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Weekly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Yearly</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Table start -->
                                <div class="table-responsive table-nowrap">
                                    <table class="table border">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Patient</th>
                                                <th>Date & Time</th>
                                                <th>Mode</th>
                                                <th>Status</th>
                                                <th>Consultation Fees</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-06.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Alberto Ripley</a></h6>
                                                          <p class="mb-0 fs-13">+1 56556 54565</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>27 May 2025 - 09:30 AM</td>
                                                <td>Online</td>
                                                <td><span class="badge bg-success fw-medium">Checked Out</span></td>
                                                <td class="fw-semibold text-dark">$400</td>
                                                <td>
                                                    <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                        <i class="ti ti-calendar-plus"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                        <i class="ti ti-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu p-2">
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-12.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Susan Babin</a></h6>
                                                          <p class="mb-0 fs-13">+1 65658 95654</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>26 May 2025 - 10:15 AM</td>
                                                <td>Online</td>
                                                <td><span class="badge bg-warning fw-medium">Checked in</span></td>
                                                <td class="fw-semibold text-dark">$370</td>
                                                <td>
                                                    <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                        <i class="ti ti-calendar-plus"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                        <i class="ti ti-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu p-2">
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-08.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Carol Lam</a></h6>
                                                          <p class="mb-0 fs-13">+1 55654 56647</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>25 May 2025 - 02:40 PM</td>
                                                <td>In-Person</td>
                                                <td><span class="badge bg-danger fw-medium">Cancelled</span></td>
                                                <td class="fw-semibold text-dark">$450</td>
                                                <td>
                                                    <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                        <i class="ti ti-calendar-plus"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                        <i class="ti ti-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu p-2">
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-22.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">Marsha Noland</a></h6>
                                                          <p class="mb-0 fs-13">+1 65668 54558</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>24 May 2025 - 11:30 AM</td>
                                                <td>In-Person</td>
                                                <td><span class="badge bg-info fw-medium">Schedule</span></td>
                                                <td class="fw-semibold text-dark">$310</td>
                                                <td>
                                                    <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                        <i class="ti ti-calendar-plus"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                        <i class="ti ti-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu p-2">
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <a href="patient-details.html" class="avatar me-2">
                                                            <img src="assets/img/profiles/avatar-25.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="patient-details.html" class="fw-medium">John Elsass</a></h6>
                                                          <p class="mb-0 fs-13">47851263</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>23 May 2025 - 04:10 PM</td>
                                                <td>Online</td>
                                                <td><span class="badge bg-info fw-medium">Schedule</span></td>
                                                <td class="fw-semibold text-dark">$400</td>
                                                <td>
                                                    <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                        <i class="ti ti-calendar-plus"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                        <i class="ti ti-dots-vertical"></i>
                                                    </a>
                                                    <ul class="dropdown-menu p-2">
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- Table end -->
                            </div>
                        </div> 
                    </div> 
                </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row">

                    <!-- col start -->
                    <div class="col-xl-4 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Availability</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                        Trustcare Clinic <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="javascript:void(0);">CureWell Medical Hub</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="javascript:void(0);">Trustcare Clinic</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="javascript:void(0);">NovaCare Medical</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="javascript:void(0);">Greeny Medical Clinic</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                                    <p class="text-dark fw-semibold mb-0">Mon</p>
                                    <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM - 12:30 PM</p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                                    <p class="text-dark fw-semibold mb-0">Tue</p>
                                    <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM - 12:30 PM</p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                                    <p class="text-dark fw-semibold mb-0">Wed</p>
                                    <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM - 12:30 PM</p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                                    <p class="text-dark fw-semibold mb-0">Thu</p>
                                    <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM - 12:30 PM</p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                                    <p class="text-dark fw-semibold mb-0">Fri</p>
                                    <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM - 12:30 PM</p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-2 border-bottom pb-2">
                                    <p class="text-dark fw-semibold mb-0">Sat</p>
                                    <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-clock me-1"></i>11:00 PM - 12:30 PM</p>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-2 pb-2">
                                    <p class="text-dark fw-semibold mb-0">Sun</p>
                                    <p class="mb-0 d-inline-flex align-items-center text-danger"><i class="ti ti-clock me-1"></i>Closed</p>
                                </div>
                                <a href="javascript:void(0);" class="btn btn-light w-100 mt-2 fs-13">Edit Availability</a>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-4 col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Appointment Statistics</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                        Monthly <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="#">Monthly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Weekly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Yearly</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <div id="circle-chart-2" class="chart-set"></div> 
                                <div class="d-flex align-items-center flex-wrap justify-content-center gap-2 mt-3">
                                    <div class="text-center">
                                        <p class="d-flex align-items-center mb-1 fs-13"><i class="ti ti-circle-filled text-success fs-10 me-1"></i>Completed</p>
                                        <h5 class="fw-bold mb-0">260</h5>
                                    </div>
                                    <div class="text-center">
                                        <p class="d-flex align-items-center mb-1 fs-13"><i class="ti ti-circle-filled text-warning fs-10 me-1"></i>Pending</p>
                                        <h5 class="fw-bold mb-0">21</h5>
                                    </div>
                                    <div class="text-center">
                                        <p class="d-flex align-items-center mb-1 fs-13"><i class="ti ti-circle-filled text-danger fs-10 me-1"></i>Cancelled</p>
                                        <h5 class="fw-bold mb-0">50</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-4 col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Top Patients</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                        Weekly <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="#">Monthly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Weekly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Yearly</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between mb-4">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-06.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Alberto Ripley</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">+1 56556 54565</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">20 Appointments</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-4">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-12.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Susan Babin</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">+1 65658 95654</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">18 Appointments</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-4">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-08.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Carol Lam</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">+1 55654 56647</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">16 Appointments</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-4">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-22.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Marsha Noland</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">+1 65668 54558</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">14 Appointments</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-0">
                                    <div class="d-flex align-items-center">
                                        <a href="patient-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/profiles/avatar-17.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="patient-details.html" class="fw-medium">Irma Armstrong</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">+1 45214 66568</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-primary border border-primary flex-shrink-0">12 Appointments</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- row start -->
                 <div class="row">

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card flex-fill w-100 shadow-sm">
                           <div class="card-body">
                              <div class="d-flex align-items-center mb-4">
                                <span class="avatar bg-primary rounded-circle fs-20 d-inline-flex flex-shrink-0"><i class="ti ti-calendar-heart"></i></span>
                                <div class="ms-2">
                                    <p class="mb-1 text-truncate">Total Appointments</p>
                                    <h3 class="fw-bold mb-0">24</h3>
                                </div>
                              </div>
                              <div class="d-flex align-items-center">
                                <span class="badge fw-medium bg-success flex-shrink-0 me-2">+95%</span>
                                <p class="fs-13 mb-0">in last 7 Days </p>
                              </div>
                           </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card flex-fill w-100 shadow-sm">
                           <div class="card-body">
                              <div class="d-flex align-items-center mb-4">
                                <span class="avatar bg-danger rounded-circle fs-20 d-inline-flex flex-shrink-0"><i class="ti ti-users"></i></span>
                                <div class="ms-2">
                                    <p class="mb-1 text-truncate">Online Consultations</p>
                                    <h3 class="fw-bold mb-0">36</h3>
                                </div>
                              </div>
                              <div class="d-flex align-items-center">
                                <span class="badge fw-medium bg-danger flex-shrink-0 me-2">-15%</span>
                                <p class="fs-13 mb-0">in last 7 Days</p>
                              </div>
                           </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card flex-fill w-100 shadow-sm">
                           <div class="card-body">
                              <div class="d-flex align-items-center justify-content-between mb-3">
                                <div>
                                    <p class="mb-1 text-truncate">Blood Pressure</p>
                                    <span class="badge fw-medium bg-success flex-shrink-0 me-2">+95%</span>
                                </div>
                                <div class="d-flex align-items-center">
                                    <h3 class="fw-bold mb-0 me-1">89</h3>
                                    <p class="mb-0">g/dl</p>
                                </div>
                              </div>
                              <div id="s-col-8" class="chart-set"></div>
                           </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card flex-fill w-100 shadow-sm">
                           <div class="card-body">
                              <div class="d-flex align-items-center justify-content-between mb-3">
                                <div>
                                    <p class="mb-1 text-truncate">Heart Rate</p>
                                    <span class="badge fw-medium bg-success flex-shrink-0 me-2">+95%</span>
                                </div>
                                <div class="d-flex align-items-center">
                                    <h3 class="fw-bold mb-0 me-1">87</h3>
                                    <p class="mb-0">bpm</p>
                                </div>
                              </div>
                              <div id="s-col-9" class="chart-set"></div>
                           </div>
                        </div>
                    </div>
                    <!-- col end -->

                 </div>
                <!-- row start -->

                <!-- row start -->
                <div class="row">
                    
                    <!-- col start -->
                    <div class="col-xl-4 col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">My Doctors</h5> 
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-01.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="doctor-details.html" class="fw-semibold">Dr. Mick Thompson</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Cardiologist</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-danger border border-danger flex-shrink-0">20 Bookings</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-02.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="doctor-details.html" class="fw-semibold">Dr. Sarah Johnson</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Orthopedic Surgeon</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-danger border border-danger flex-shrink-0">15 Bookings</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-03.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="doctor-details.html" class="fw-semibold">Dr. Emily Carter</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Pediatrician</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-danger border border-danger flex-shrink-0">12 Bookings</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-04.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="doctor-details.html" class="fw-semibold">Dr. David Lee</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Gynecologist</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-danger border border-danger flex-shrink-0">08 Bookings</span>
                                </div>
                                <div class="d-flex align-items-center justify-content-between mb-0">
                                    <div class="d-flex align-items-center">
                                        <a href="doctor-details.html" class="avatar me-2 flex-shrink-0">
                                            <img src="assets/img/doctors/doctor-05.jpg" alt="img" class="rounded-circle">
                                        </a>
                                        <div>
                                          <h6 class="fs-14 mb-1 text-truncate"><a href="doctor-details.html" class="fw-semibold">Dr. Anna Kim</a></h6>
                                          <p class="mb-0 fs-13 text-truncate">Psychiatrist</p>
                                        </div>
                                    </div>
                                    <span class="badge fw-medium badge-soft-danger border border-danger flex-shrink-0">06 Bookings</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-4 col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Prescriptions</h5> 
                            </div>
                            <div class="card-body">
                                <div class="overflow-auto">
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="d-flex align-items-center flex-shrink-0">
                                            <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0 bg-light rounded-circle text-dark">
                                               <i class="ti ti-file-description fs-20"></i>
                                            </a>
                                            <div>
                                              <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Cardiology Prescription</a></h6>
                                              <p class="mb-0 fs-13 text-truncate">20 Apr 2025</p>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm me-2 p-1"><i class="ti ti-eye"></i></a>
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm p-1"><i class="ti ti-download"></i></a>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="d-flex align-items-center flex-shrink-0">
                                            <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0 bg-light rounded-circle text-dark">
                                               <i class="ti ti-file-description fs-20"></i>
                                            </a>
                                            <div>
                                              <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Dentist Prescription</a></h6>
                                              <p class="mb-0 fs-13 text-truncate">25 Mar 2025</p>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm me-2 p-1"><i class="ti ti-eye"></i></a>
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm p-1"><i class="ti ti-download"></i></a>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="d-flex align-items-center flex-shrink-0">
                                            <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0 bg-light rounded-circle text-dark">
                                               <i class="ti ti-file-description fs-20"></i>
                                            </a>
                                            <div>
                                              <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Dentist Prescription</a></h6>
                                              <p class="mb-0 fs-13 text-truncate">16 Mar 2025</p>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm me-2 p-1"><i class="ti ti-eye"></i></a>
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm p-1"><i class="ti ti-download"></i></a>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="d-flex align-items-center flex-shrink-0">
                                            <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0 bg-light rounded-circle text-dark">
                                               <i class="ti ti-file-description fs-20"></i>
                                            </a>
                                            <div>
                                              <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Dentist Prescription</a></h6>
                                              <p class="mb-0 fs-13 text-truncate">12 Feb 2025</p>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm me-2 p-1"><i class="ti ti-eye"></i></a>
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm p-1"><i class="ti ti-download"></i></a>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between mb-0">
                                        <div class="d-flex align-items-center flex-shrink-0">
                                            <a href="javascript:void(0);" class="avatar me-2 flex-shrink-0 bg-light rounded-circle text-dark">
                                               <i class="ti ti-file-description fs-20"></i>
                                            </a>
                                            <div>
                                              <h6 class="fs-14 mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Cardiology Prescription</a></h6>
                                              <p class="mb-0 fs-13 text-truncate">04 Jan 2025</p>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm me-2 p-1"><i class="ti ti-eye"></i></a>
                                            <a href="javascript:void(0);" class="btn btn-outline-white d-inline-flex align-items-center shadow-sm p-1"><i class="ti ti-download"></i></a>
                                        </div>
                                    </div>
                                </div>                                
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-4 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Recent Activity</h5> 
                            </div>
                            <div class="card-body">
                                <div class="recent-activity">
                                    <div class="d-flex align-items-center mb-3">
                                        <span><i class="ti ti-point-filled fs-24 text-success"></i></span>
                                        <div class="ms-2">
                                          <p class="mb-1 text-truncate">Appointment with <a href="javascript:void(0);" class="fw-semibold">Primary Care Physician</a></p>
                                          <p class="fs-13 mb-0">24 Mar 2025, 10:55 AM</p>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center mb-3">
                                        <span><i class="ti ti-point-filled fs-24 text-danger"></i></span>
                                        <div class="ms-2">
                                          <p class="mb-1 text-truncate"><a href="javascript:void(0);" class="fw-semibold">Blood Pressure Check</a> (Home Monitoring)</p>
                                          <p class="fs-13 mb-0">24 Apr 2025, 11:00 AM</p>
                                        </div>
                                    </div>    
                                    <div class="d-flex align-items-center mb-3">
                                        <span><i class="ti ti-point-filled fs-24 text-warning"></i></span>
                                        <div class="ms-2">
                                          <p class="mb-1"><a href="javascript:void(0);" class="fw-semibold">Physical Therapy Session</a> Knee strengthening exercises</p>
                                          <p class="fs-13 mb-0">24 Apr 2025, 11:00 AM</p>
                                        </div>
                                    </div>   
                                    <div class="d-flex align-items-center mb-0">
                                        <span><i class="ti ti-point-filled fs-24 text-info"></i></span>
                                        <div class="ms-2">
                                          <p class="mb-1"><a href="javascript:void(0);" class="fw-semibold">Discuss dietary changes</a> to manage blood sugar levels and weight</p>
                                          <p class="fs-13 mb-0">24 Apr 2025, 11:00 AM</p>
                                        </div>
                                    </div> 
                                </div>                           
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- card start -->
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h5 class="fw-bold mb-0">Vitals</h5> 
                    </div>
                    <div class="card-body">

                        <!-- row start -->
                        <div class="row row-gap-3 row-cols-1 row-cols-xl-6 row-cols-md-3 row-cols-sm-2">

                            <!-- col start -->
                            <div class="col d-flex">
                                <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                                    <div class="d-flex align-items-center">
                                        <span class="avatar bg-primary rounded-circle flex-shrink-0"><img src="./assets/img/icons/weight.svg" alt="img" class="w-auto h-auto"></span>
                                        <div class="ms-1">
                                            <p class="mb-1">Weight</p>
                                            <p class="text-truncate"><span class="fs-18 fw-bold text-dark">100</span> Kg</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- col end -->

                            <!-- col start -->
                            <div class="col d-flex">
                                <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                                    <div class="d-flex align-items-center">
                                        <span class="avatar bg-primary rounded-circle flex-shrink-0"><img src="./assets/img/icons/rotate-left.svg" alt="img" class="w-auto h-auto"></span>
                                        <div class="ms-1">
                                            <p class="mb-1">Height</p>
                                            <p class="text-truncate"><span class="fs-18 fw-bold text-dark">154</span> Cm</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- col end -->

                            <!-- col start -->
                            <div class="col d-flex">
                                <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                                    <div class="d-flex align-items-center">
                                        <span class="avatar bg-primary rounded-circle flex-shrink-0"><img src="./assets/img/icons/user-cirlce-add.svg" alt="img" class="w-auto h-auto"></span>
                                        <div class="ms-1">
                                            <p class="mb-1">BMI</p>
                                            <p class="text-truncate"><span class="fs-18 fw-bold text-dark">19.2</span> kg/cm</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- col end -->

                            <!-- col start -->
                            <div class="col d-flex">
                                <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                                    <div class="d-flex align-items-center">
                                        <span class="avatar bg-primary rounded-circle flex-shrink-0"><img src="./assets/img/icons/driver-2.svg" alt="img" class="w-auto h-auto"></span>
                                        <div class="ms-1">
                                            <p class="mb-1">Pulse</p>
                                            <p class="text-truncate"><span class="fs-18 fw-bold text-dark">97%</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- col end -->

                            <!-- col start -->
                            <div class="col d-flex">
                                <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                                    <div class="d-flex align-items-center">
                                        <span class="avatar bg-primary rounded-circle flex-shrink-0"><img src="./assets/img/icons/wind.svg" alt="img" class="w-auto h-auto"></span>
                                        <div class="ms-1">
                                            <p class="mb-1">SPO2</p>
                                            <p class="text-truncate"><span class="fs-18 fw-bold text-dark">98%</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- col end -->

                            <!-- col start -->
                            <div class="col d-flex">
                                <div class="p-3 border shadow-sm flex-fill w-100 rounded-2">
                                    <div class="d-flex align-items-center">
                                        <span class="avatar bg-primary rounded-circle flex-shrink-0"><img src="./assets/img/icons/sun.svg" alt="img" class="w-auto h-auto"></span>
                                        <div class="ms-1">
                                            <p class="mb-1 text-truncate">Temprature</p>
                                            <p class="text-truncate"><span class="fs-18 fw-bold text-dark">101</span> C</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- col end -->
        
                        </div>
                        <!-- row end -->

                    </div>
                </div>
                <!-- card end -->

                <!-- row start -->
                 <div class="row">

                    <!-- col start -->
                    <div class="col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Consultation By Department</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                        Monthly <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="#">Monthly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Weekly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Yearly</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body pb-0">
                                <div id="s-col-10" class="chart-set"></div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-lg-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header d-flex align-items-center justify-content-between">
                                <h5 class="fw-bold mb-0">Recent Transactions</h5> 
                                <div class="dropdown">
                                    <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                        Weekly <i class="ti ti-chevron-down ms-1"></i>
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="dropdown-item" href="#">Monthly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Weekly</a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item" href="#">Yearly</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">

                                <!-- Table start -->
                                <div class="table-responsive table-nowrap">
                                    <table class="table">
                                        <tbody>
                                            <tr class="border-white">
                                                <td class="ps-0">
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-06.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. John Smith</a></h6>
                                                          <p class="mb-0 fs-13">Neurosurgeon</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                                    <p class="fs-13">$450</p>
                                                </td>
                                                <td class="pe-0 text-end"><span class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span></td>
                                            </tr>
                                            <tr class="border-white">
                                                <td class="ps-0">
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-07.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Lisa White</a></h6>
                                                          <p class="mb-0 fs-13">Oncologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                                    <p class="fs-13">$350</p>
                                                </td>
                                                <td class="pe-0 text-end"><span class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span></td>
                                            </tr>
                                            <tr class="border-white">
                                                <td class="ps-0">
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-08.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Patricia Brown</a></h6>
                                                          <p class="mb-0 fs-13">Pulmonologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                                    <p class="fs-13">$400</p>
                                                </td>
                                                <td class="pe-0 text-end"><span class="badge fs-13 py-1 badge-soft-danger border border-danger rounded text-danger fw-medium">Failed</span></td>
                                            </tr>
                                            <tr class="border-white">
                                                <td class="ps-0">
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-09.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Rachel Green</a></h6>
                                                          <p class="mb-0 fs-13">Urologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                                    <p class="fs-13">$550</p>
                                                </td>
                                                <td class="pe-0 text-end"><span class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span></td>
                                            </tr>
                                            <tr class="border-white">
                                                <td class="ps-0">
                                                    <div class="d-flex align-items-center">
                                                        <a href="doctor-details.html" class="avatar me-2">
                                                            <img src="assets/img/doctors/doctor-10.jpg" alt="img" class="rounded-circle">
                                                        </a>
                                                        <div>
                                                          <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Michael Smith</a></h6>
                                                          <p class="mb-0 fs-13">Cardiologist</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <h6 class="fs-14 fw-semibold">Consultation Fees</h6>
                                                    <p class="fs-13">$600</p>
                                                </td>
                                                <td class="pe-0 text-end"><span class="badge fs-13 py-1 badge-soft-success border border-success rounded text-success fw-medium">Success</span></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- Table end -->

                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                 </div>
                <!-- row end -->

                <!-- card start -->
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Recent Appointments</h5> 
                        <div class="dropdown">
                            <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                Weekly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Table start -->
                        <div class="table-responsive table-nowrap">
                            <table class="table border">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Name & Designation</th>
                                        <th>Date & Time</th>
                                        <th>Consultation Fees</th>
                                        <th>Mode</th>
                                        <th>Status</th>                                        
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="doctor-details.html" class="avatar me-2">
                                                    <img src="assets/img/doctors/doctor-01.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                  <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Mick Thompson</a></h6>
                                                  <p class="mb-0 fs-13">Cardiologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>27 May 2025 - 09:30 AM</td>
                                        <td class="fw-semibold text-dark">$400</td>
                                        <td>Online</td>
                                        <td><span class="badge bg-success fw-medium">Checked Out</span></td>                                        
                                        <td>
                                            <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                <i class="ti ti-calendar-plus"></i>
                                            </a>
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="doctor-details.html" class="avatar me-2">
                                                    <img src="assets/img/doctors/doctor-09.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                  <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Sarah Johnson</a></h6>
                                                  <p class="mb-0 fs-13">Orthopedic Surgeon</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>26 May 2025 - 10:15 AM</td>
                                        <td class="fw-semibold text-dark">$370</td>
                                        <td>Online</td>
                                        <td><span class="badge bg-warning fw-medium">Checked in</span></td>                                        
                                        <td>
                                            <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                <i class="ti ti-calendar-plus"></i>
                                            </a>
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="doctor-details.html" class="avatar me-2">
                                                    <img src="assets/img/doctors/doctor-03.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                  <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Emily Carter</a></h6>
                                                  <p class="mb-0 fs-13">Pediatrician</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>25 May 2025 - 02:40 PM</td>
                                        <td class="fw-semibold text-dark">$450</td>
                                        <td>In-Person</td>
                                        <td><span class="badge bg-danger fw-medium">Cancelled</span></td>                                        
                                        <td>
                                            <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                <i class="ti ti-calendar-plus"></i>
                                            </a>
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="doctor-details.html" class="avatar me-2">
                                                    <img src="assets/img/doctors/doctor-04.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                  <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. David Lee</a></h6>
                                                  <p class="mb-0 fs-13">Gynecologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>24 May 2025 - 11:30 AM</td>
                                        <td class="fw-semibold text-dark">$310</td>
                                        <td>In-Person</td>
                                        <td><span class="badge bg-info fw-medium">Schedule</span></td>                                        
                                        <td>
                                            <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                <i class="ti ti-calendar-plus"></i>
                                            </a>
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="doctor-details.html" class="avatar me-2">
                                                    <img src="assets/img/doctors/doctor-05.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                  <h6 class="fs-14 mb-1"><a href="doctor-details.html" class="fw-semibold">Dr. Anna Kim</a></h6>
                                                  <p class="mb-0 fs-13">Psychiatrist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>23 May 2025 - 04:10 PM</td>
                                        <td class="fw-semibold text-dark">$400</td>
                                        <td>Online</td>
                                        <td><span class="badge bg-info fw-medium">Schedule</span></td>                                        
                                        <td>
                                            <a href="javascript:void(0);" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1 me-1">
                                                <i class="ti ti-calendar-plus"></i>
                                            </a>
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown" class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#edit_appointment"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- Table end -->
                    </div>
                </div>
                <!-- card end -->

                <!-- row start -->
                <div class="row">
                    <div class="col-xl-4 col-md-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center flex-sm-nowrap flex-wrap row-gap-3">
                                <div class="me-3 doctor-profile-img"><a href="doctor-details.html"><img src="assets/img/doctors/doctor-01.jpg" class="rounded" alt=""></a></div>
                                <div class="flex-fill">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <h6 class="mb-0 fs-14 fw-semibold text-truncate"><a href="doctor-details.html">Dr. Mick Thompson</a></h6>
                                        <div class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#edit_doctor"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <span class="d-block mb-2 fs-13">Cardiologist</span>
                                    <p class="mb-2 fs-13 text-truncate">Available : Mon, 20 Jan 2025</p>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <h6 class="text-primary fs-14 fw-semibold mb-0"><span class="text-muted fs-13 fw-normal">Starts From : </span> $499</h6>
                                        <a href="#" class="avatar avatar-xs border text-muted fs-14"><i class="ti ti-calendar-cog"></i></a>
                                    </div>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-xl-4 col-md-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center flex-sm-nowrap flex-wrap row-gap-3">
                                <div class="me-3 doctor-profile-img"><a href="doctor-details.html"><img src="assets/img/doctors/doctor-02.jpg" class="rounded" alt=""></a></div>
                                <div class="flex-fill">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <h6 class="mb-0 fs-14 fw-semibold text-truncate"><a href="doctor-details.html">Dr. Sarah Johnson</a></h6>
                                        <div class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#edit_doctor"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <span class="d-block mb-2 fs-13">Orthopedic Surgeon</span>
                                    <p class="mb-2 fs-13 text-truncate">Available : Wed, 22 Jan 2025</p>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <h6 class="text-primary fw-semibold fs-14 mb-0"><span class="text-muted fs-13 fw-normal">Starts From : </span> $450</h6>
                                        <a href="#" class="avatar avatar-xs border text-muted fs-14"><i class="ti ti-calendar-cog"></i></a>
                                    </div>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-xl-4 col-md-6">
                        <div class="card">
                            <div class="card-body d-flex align-items-center flex-sm-nowrap flex-wrap row-gap-3">
                                <div class="me-3 doctor-profile-img"><a href="doctor-details.html"><img src="assets/img/doctors/doctor-03.jpg" class="rounded" alt=""></a></div>
                                <div class="flex-fill">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <h6 class="mb-0 fs-14 fw-semibold text-truncate"><a href="doctor-details.html">Dr. Emily Carter</a></h6>
                                        <div class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#edit_doctor"><i class="ti ti-edit me-2"></i>Edit</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal"><i class="ti ti-trash me-2"></i>Delete</a>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <span class="d-block mb-2 fs-13">Pediatrician</span>
                                    <p class="mb-2 fs-13 text-truncate">Available : Fri, 24 Jan 2025</p>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <h6 class="text-primary fw-semibold fs-14 mb-0"><span class="text-muted fs-13 fw-normal">Starts From : </span> $300</h6>
                                        <a href="#" class="avatar avatar-xs border text-muted fs-14"><i class="ti ti-calendar-cog"></i></a>
                                    </div>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->
                </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row">

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <img src="./assets/img/bg/widget-bg-01.svg" alt="img" class="position-absolute end-0 bottom-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <p class="mb-2">Total Present</p>
                                        <div class="d-flex align-items-center">
                                            <p class="mb-0 text-truncate"><span class="fs-16 text-dark fw-bold">180</span> / 200</p>
                                            <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+10.6%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                        </div>
                                    </div>
                                    <span class="avatar avatar-sm bg-soft-primary text-primary border border-primary rounded-circle flex-shrink-0"><i class="ti ti-user-check fs-14"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <img src="./assets/img/bg/widget-bg-02.svg" alt="img" class="position-absolute end-0 bottom-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <p class="mb-2">Planned Leaves</p>
                                        <div class="d-flex align-items-center">
                                            <p class="mb-0"><span class="fs-16 text-dark fw-bold">10</span></p>
                                            <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+8.95%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                        </div>
                                    </div>
                                    <span class="avatar avatar-sm bg-soft-success text-success border border-success rounded-circle flex-shrink-0"><i class="ti ti-user-x fs-14"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <img src="./assets/img/bg/widget-bg-03.svg" alt="img" class="position-absolute end-0 bottom-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <p class="mb-2">Unplanned Leaves</p>
                                        <div class="d-flex align-items-center">
                                            <p class="mb-0"><span class="fs-16 text-dark fw-bold">50</span></p>
                                            <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+3.78%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                        </div>
                                    </div>
                                    <span class="avatar avatar-sm bg-soft-warning text-warning border border-warning rounded-circle flex-shrink-0"><i class="ti ti-user-exclamation fs-14"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <img src="./assets/img/bg/widget-bg-04.svg" alt="img" class="position-absolute end-0 bottom-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <p class="mb-2">Pending Requests</p>
                                        <div class="d-flex align-items-center">
                                            <p class="mb-0"><span class="fs-16 text-dark fw-bold">15</span></p>
                                            <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+7.65%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                        </div>
                                    </div>
                                    <span class="avatar avatar-sm bg-soft-danger text-danger border border-danger rounded-circle flex-shrink-0"><i class="ti ti-user-question fs-14"></i></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row">

                   <!-- col start -->
                   <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Total Clinic Income</p>
                                        <h6 class="mb-0 fw-bold">$18,750</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-soft-primary text-primary rounded-circle flex-shrink-0"><i class="ti ti-currency-dollar fs-24"></i></span>
                                </div>
                                <div class="progress mb-2 progress-sm">
                                    <div class="progress-bar bg-primary" role="progressbar" style="width: 75%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <p class="mb-0 fs-13"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>5.62%</span> from last month</p>
                            </div>
                        </div>
                   </div>
                   <!-- col end -->

                   <!-- col start -->
                   <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Doctor Fees Collected</p>
                                        <h6 class="mb-0 fw-bold">$7,000</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-soft-success text-success rounded-circle flex-shrink-0"><i class="ti ti-stethoscope fs-24"></i></span>
                                </div>
                                <div class="progress mb-2 progress-sm">
                                    <div class="progress-bar bg-success" role="progressbar" style="width: 75%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <p class="mb-0 fs-13"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>11.4%</span> from last month</p>
                            </div>
                        </div>
                   </div>
                   <!-- col end -->

                   <!-- col start -->
                   <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Medicine Sales</p>
                                        <h6 class="mb-0 fw-bold">$6,250</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-soft-warning text-warning rounded-circle flex-shrink-0"><i class="ti ti-pill fs-24"></i></span>
                                </div>
                                <div class="progress mb-2 progress-sm">
                                    <div class="progress-bar bg-warning" role="progressbar" style="width: 75%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <p class="mb-0 fs-13"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>8.52%</span> from last month</p>
                            </div>
                        </div>
                   </div>
                   <!-- col end -->

                   <!-- col start -->
                   <div class="col-xl-3 col-md-6 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Lab Revenue</p>
                                        <h6 class="mb-0 fw-bold">$5,500</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-soft-danger text-danger rounded-circle flex-shrink-0"><i class="ti ti-flask fs-24"></i></span>
                                </div>
                                <div class="progress mb-2 progress-sm">
                                    <div class="progress-bar bg-danger" role="progressbar" style="width: 25%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <p class="mb-0 fs-13"><span class="text-danger"><i class="ti ti-arrow-down-right me-1"></i>7.45%</span> from last month</p>
                            </div>
                        </div>
                   </div>
                   <!-- col end -->

                </div>     
                <!-- row end -->

                <!-- row start -->
                <div class="row">

                   <!-- col start -->
                   <div class="col-xl-3 col-md-6 d-flex">                       
                       <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-05.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-end">
                                    <div>
                                        <p class="mb-1 text-truncate">Total Expenses</p>
                                        <h6 class="mb-2 fw-bold">$13,500</h6>
                                        <p class="mb-0 fs-13 text-truncate"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>5.62%</span> from last month</p>
                                    </div>
                                    <span class="avatar avatar-md widget-icon bg-soft-primary border border-primary text-primary rounded-2 flex-shrink-0"><i class="ti ti-currency-dollar fs-14"></i></span>
                                </div>                                
                            </div>
                       </div>
                   </div>
                   <!-- col end -->

                   <!-- col start -->
                   <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-06.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-end">
                                    <div>
                                        <p class="mb-1 text-truncate">Doctor Payouts</p>
                                        <h6 class="mb-2 fw-bold">$4,500</h6>
                                        <p class="mb-0 fs-13 text-truncate"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>11.4%</span> from last month</p>
                                    </div>
                                    <span class="avatar avatar-md widget-icon bg-soft-success border border-success text-success rounded-2 flex-shrink-0"><i class="ti ti-stethoscope fs-14"></i></span>
                                </div>                                
                            </div>
                        </div>
                   </div>
                   <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-07.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-end">
                                    <div>
                                        <p class="mb-1 text-truncate">Staff Salaries</p>
                                        <h6 class="mb-2 fw-bold">$3,200</h6>
                                        <p class="mb-0 fs-13 text-truncate"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>8.52%</span> from last month</p>
                                    </div>
                                    <span class="avatar avatar-md widget-icon bg-soft-warning border border-warning text-warning rounded-2 flex-shrink-0"><i class="ti ti-pill fs-14"></i></span>
                                </div>                                
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-08.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-end">
                                    <div>
                                        <p class="mb-1 text-truncate">Utilities & Rent</p>
                                        <h6 class="mb-2 fw-bold">$2,000</h6>
                                        <p class="mb-0 fs-13 text-truncate"><span class="text-danger"><i class="ti ti-arrow-down-right me-1"></i>7.45%</span> from last month</p>
                                    </div>
                                    <span class="avatar avatar-md widget-icon bg-soft-danger border border-danger text-danger rounded-2 flex-shrink-0"><i class="ti ti-flask fs-14"></i></span>
                                </div>                                
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row">
                   
                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Total Income</p>
                                        <h6 class="mb-0 fw-bold">$125,150</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-primary rounded-circle flex-shrink-0"><i class="ti ti-arrow-up-right-circle fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block bg-light rounded-2 p-2 text-center"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>5.62%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Total Expenses</p>
                                        <h6 class="mb-0 fw-bold">$91,800</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-success rounded-circle flex-shrink-0"><i class="ti ti-arrow-down-right-circle fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block bg-light rounded-2 p-2 text-center"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>11.4%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Net Profit</p>
                                        <h6 class="mb-0 fw-bold">$91,800</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-warning rounded-circle flex-shrink-0"><i class="ti ti-currency-dollar fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block bg-light rounded-2 p-2 text-center"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>8.52%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Profit Margin (%)</p>
                                        <h6 class="mb-0 fw-bold">26.6%</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-danger rounded-circle flex-shrink-0"><i class="ti ti-cash fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block bg-light rounded-2 p-2 text-center"><span class="text-danger"><i class="ti ti-arrow-down-right me-1"></i>7.45%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row">

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="avatar avatar-sm bg-soft-primary border border-primary text-primary rounded-2 flex-shrink-0"><i class="ti ti-calendar-time fs-14"></i></span>
                                    <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+10%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                </div>  
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-1 text-truncate">Total Appointments</p>
                                        <h6 class="mb-0 fw-bold">850</h6>
                                    </div>
                                    <div id="s-col-11" class="chart-set"></div>
                                </div>  
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="avatar avatar-sm bg-soft-success border border-success text-success rounded-2 flex-shrink-0"><i class="ti ti-calendar-up fs-14"></i></span>
                                    <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+11.5%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                </div>  
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-1 text-truncate">Completed</p>
                                        <h6 class="mb-0 fw-bold">720</h6>
                                    </div>
                                    <div id="s-col-12" class="chart-set"></div>
                                </div>  
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="avatar avatar-sm bg-soft-warning border border-warning text-warning rounded-2 flex-shrink-0"><i class="ti ti-calendar-down fs-14"></i></span>
                                    <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+8.43%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                </div>  
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-1 text-truncate">Cancelled</p>
                                        <h6 class="mb-0 fw-bold">65</h6>
                                    </div>
                                    <div id="s-col-13" class="chart-set"></div>
                                </div>  
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <span class="avatar avatar-sm bg-soft-danger border border-danger text-danger rounded-2 flex-shrink-0"><i class="ti ti-calendar-repeat fs-14"></i></span>
                                    <span class="badge fw-medium bg-soft-success text-success flex-shrink-0 ms-2">+6.58%<i class="ti ti-arrow-up-right ms-1"></i></span>
                                </div>  
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <p class="mb-1 text-truncate">Rescheduled</p>
                                        <h6 class="mb-0 fw-bold">40</h6>
                                    </div>
                                    <div id="s-col-14" class="chart-set"></div>
                                </div>  
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- row start-->
                <div class="row">
                    
                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-09.svg" alt="img" class="position-absolute end-0 bottom-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Total Patients</p>
                                        <h6 class="mb-0 fw-bold">1,240</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-primary rounded-circle flex-shrink-0"><i class="ti ti-users fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block border-top rounded-2 pt-2"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>5.62%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-10.svg" alt="img" class="position-absolute end-0 bottom-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">New Patients</p>
                                        <h6 class="mb-0 fw-bold">210</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-success rounded-circle flex-shrink-0"><i class="ti ti-users-plus fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block border-top rounded-2 pt-2"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>11.4%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-11.svg" alt="img" class="position-absolute end-0 bottom-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Appointment Booked</p>
                                        <h6 class="mb-0 fw-bold">500</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-warning rounded-circle flex-shrink-0"><i class="ti ti-bookmarks fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block border-top rounded-2 pt-2"><span class="text-success"><i class="ti ti-arrow-up-right me-1"></i>8.52%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-12.svg" alt="img" class="position-absolute end-0 bottom-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Returning Patients</p>
                                        <h6 class="mb-0 fw-bold">380</h6>
                                    </div>
                                    <span class="avatar avatar-lg bg-danger rounded-circle flex-shrink-0"><i class="ti ti-users-minus fs-24"></i></span>
                                </div>  
                                <span class="mb-0 fs-13 d-block border-top rounded-2 pt-2"><span class="text-danger"><i class="ti ti-arrow-down-right me-1"></i>7.45%</span> from last month</span>                              
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                 <!-- row end -->

                 <!-- row start -->
                <div class="row">

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-05.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Total Visits</p>
                                        <h6 class="mb-0 fw-bold">750</h6>
                                    </div>
                                    <span class="avatar bg-soft-primary border border-primary text-primary rounded-2 flex-shrink-0"><i class="ti ti-user-down fs-24"></i></span>
                                </div>  
                                <div class="chart-set" id="s-col-15"></div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-06.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Completed</p>
                                        <h6 class="mb-0 fw-bold">625</h6>
                                    </div>
                                    <span class="avatar bg-soft-success border border-success text-success rounded-2 flex-shrink-0"><i class="ti ti-user-check fs-24"></i></span>
                                </div>  
                                <div class="chart-set" id="s-col-16"></div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-07.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">No-Shows</p>
                                        <h6 class="mb-0 fw-bold">50</h6>
                                    </div>
                                    <span class="avatar bg-soft-warning border border-warning text-warning rounded-2 flex-shrink-0"><i class="ti ti-user-cancel fs-24"></i></span>
                                </div>  
                                <div class="chart-set" id="s-col-17"></div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                    <!-- col start -->
                    <div class="col-xl-3 col-md-6 d-flex">                       
                        <div class="card shadow-sm flex-fill w-100 z-0">
                            <img src="./assets/img/bg/widget-bg-08.svg" alt="img" class="position-absolute start-0 top-0 z-n1">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div>
                                        <p class="mb-1 text-truncate">Follow-ups</p>
                                        <h6 class="mb-0 fw-bold">75</h6>
                                    </div>
                                    <span class="avatar bg-soft-danger border border-danger text-danger rounded-2 flex-shrink-0"><i class="ti ti-user-exclamation fs-24"></i></span>
                                </div>  
                                <div class="chart-set" id="s-col-18"></div>
                            </div>
                        </div>
                    </div>
                    <!-- col end -->

                </div>
                <!-- row end -->

                <!-- row start -->
                <div class="row">

                    <div class="col-md-4">
                        <div class="card blog-item">
                            <div class="card-body p-0">
                                <div class="position-relative rounded-top overflow-hidden">
                                    <a href="blog-details.html" class="blog-img"><img src="assets/img/blogs/blog-img-01.jpg" alt="img" class="img-fluid rounded-top"></a>
                                    <a href="javascript:void(0);" class="btn btn-sm fs-16 d-inline-flex align-items-center justify-content-center p-2 bg-white rounded-2 blog-delete"><i class="ti ti-trash"></i></a>
                                    <a href="edit-blog.html" class="btn btn-sm fs-16 d-inline-flex align-items-center justify-content-center p-2 bg-white rounded-2 blog-edit"><i class="ti ti-edit"></i></a>
                                </div>
                                <div class="p-3">
                                    <span class="badge badge-soft-primary border border-primary fw-medium fs-13 py-1 px-2 mb-3">Preventive Care</span>
                                    <h6 class="fw-bold"><a href="blog-details.html">Health First: Your Guide to Better Living</a></h6>
                                    <p class="truncate-2-lines mb-0">Preventive care refers to medical services that help you avoid illness, detect health issues early, and maintain overall wellness</p>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-md-4">
                        <div class="card blog-item">
                            <div class="card-body p-0">
                                <div class="position-relative rounded-top overflow-hidden">
                                    <a href="blog-details.html" class="blog-img"><img src="assets/img/blogs/blog-img-02.jpg" alt="img" class="img-fluid rounded-top"></a>
                                    <a href="javascript:void(0);" class="btn fs-16 btn-sm d-inline-flex align-items-center justify-content-center p-2 bg-white rounded-2 blog-delete"><i class="ti ti-trash"></i></a>
                                    <a href="edit-blog.html" class="btn btn-sm fs-16 d-inline-flex align-items-center justify-content-center p-2 bg-white rounded-2 blog-edit"><i class="ti ti-edit"></i></a>
                                </div>
                                <div class="p-3">
                                    <span class="badge badge-soft-primary fw-medium border border-primary fs-13 py-1 px-2 mb-3">Nutrition</span>
                                    <h6 class="fw-bold"><a href="blog-details.html">Balance Your Plate, Boost Your Life</a></h6>
                                    <p class="truncate-2-lines mb-0">Fuel your body, move with purpose—wellness starts with what you eat and how you live</p>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    <div class="col-md-4">
                        <div class="card blog-item">
                            <div class="card-body p-0">
                                <div class="position-relative rounded-top overflow-hidden">
                                    <a href="blog-details.html" class="blog-img"><img src="assets/img/blogs/blog-img-04.jpg" alt="img" class="img-fluid rounded-top"></a>
                                    <a href="javascript:void(0);" class="btn btn-sm fs-16 d-inline-flex align-items-center justify-content-center p-2 bg-white rounded-2 blog-delete"><i class="ti ti-trash"></i></a>
                                    <a href="edit-blog.html" class="btn btn-sm fs-16 d-inline-flex align-items-center justify-content-center p-2 bg-white rounded-2 blog-edit"><i class="ti ti-edit"></i></a>
                                </div>
                                <div class="p-3">
                                    <span class="badge badge-soft-primary fw-medium border border-primary fs-13 py-1 px-2 mb-3">Health Tips</span>
                                    <h6 class="fw-bold"><a href="blog-details.html">Small Daily Habits, Big Health Benefits</a></h6>
                                    <p class="truncate-2-lines mb-0">Add a fruit or veggie to every meal.Don’t skip breakfast—it fuels your day.Go to bed and wake up at the same time daily</p>
                                </div>
                            </div><!-- end card body -->
                        </div><!-- end card -->
                    </div><!-- end col -->

                    
                </div>
                <!-- row end -->

                <!-- start row -->
                <div class="row row-gap-3 mb-3">
                    <div class="col-md-6 col-lg">
                        <a href="assets/img/gallery/gallery-img-06.jpg" class="image-popup">
                            <img src="assets/img/gallery/gallery-06.jpg" alt="img" class="img-fluid w-100">
                        </a>
                    </div><!-- end col -->
                    <div class="col-md-6 col-lg">
                        <a href="assets/img/gallery/gallery-img-07.jpg" class="image-popup">
                            <img src="assets/img/gallery/gallery-07.jpg" alt="img" class="img-fluid w-100">
                        </a>
                    </div><!-- end col -->
                    <div class="col-md-6 col-lg">
                        <a href="assets/img/gallery/gallery-img-08.jpg" class="image-popup">
                            <img src="assets/img/gallery/gallery-08.jpg" alt="img" class="img-fluid w-100">
                        </a>
                    </div><!-- end col -->
                    <div class="col-md-6 col-lg">
                        <a href="assets/img/gallery/gallery-img-04.jpg" class="image-popup">
                            <img src="assets/img/gallery/gallery-04.jpg" alt="img" class="img-fluid w-100">
                        </a>
                    </div><!-- end col -->
                    <div class="col-md-6 col-lg">
                        <a href="assets/img/gallery/gallery-img-10.jpg" class="image-popup">
                            <img src="assets/img/gallery/gallery-10.jpg" alt="img" class="img-fluid w-100">
                        </a>
                    </div><!-- end col -->
                </div>
                <!-- end row -->

                <!-- card start -->
                <div class="card shadow-sm flex-fill w-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Appointment Statistics</h5> 
                        <div class="dropdown">
                            <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                Monthly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div class="row row-gap-3">
                            <div class="col-md-3 col-sm-6">
                                <div class="bg-light border p-2 text-center rounded-2">
                                    <p class="mb-1 text-truncate"><i class="ti ti-point-filled me-1 text-primary"></i>All Appointments</p>
                                    <h5 class="fw-bold mb-0">6314</h5>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="bg-light border p-2 text-center rounded-2">
                                    <p class="mb-1"><i class="ti ti-point-filled me-1 text-danger"></i>Cancelled</p>
                                    <h5 class="fw-bold mb-0">456</h5>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="bg-light border p-2 text-center rounded-2">
                                    <p class="mb-1"><i class="ti ti-point-filled me-1 text-warning"></i>Reschedule</p>
                                    <h5 class="fw-bold mb-0">745</h5>
                                </div>
                            </div>
                            <div class="col-md-3 col-sm-6">
                                <div class="bg-light border p-2 text-center rounded-2">
                                    <p class="mb-1"><i class="ti ti-point-filled me-1 text-success"></i>Completed</p>
                                    <h5 class="fw-bold mb-0">4578</h5>
                                </div>
                            </div>
                        </div>
                        <div class="chart-set" id="s-col-19"></div>
                    </div>
                </div>
                <!-- card end -->

                <!-- card start -->
                <div class="card shadow-sm flex-fill w-100 mb-0">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h5 class="fw-bold mb-0">Appointments</h5> 
                        <div class="dropdown">
                            <a href="javascript:void(0);" class="btn btn-sm px-2 border shadow-sm btn-outline-white d-inline-flex align-items-center" data-bs-toggle="dropdown">
                                Monthly <i class="ti ti-chevron-down ms-1"></i>
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" href="#">Monthly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Weekly</a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="#">Yearly</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <div class="d-flex align-items-center justify-content-center gap-2 mb-1 flex-wrap">
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-point-filled me-1 fs-18 text-primary"></i>Total Appointments</p>
                            <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-point-filled me-1 fs-18 text-success"></i>Completed Appointments</p>
                        </div>
                        <div class="chart-set" id="s-col-20"></div>
                    </div>
                </div>
                <!-- card end -->
                                
            </div>
            <!-- End Content -->


            <!-- Footer Start -->
            <div class="footer text-center bg-white p-2 border-top">
                <p class="text-dark mb-0">2025 &copy; <a href="javascript:void(0);" class="link-primary">Preclinic</a>, All Rights Reserved</p>
            </div>
            <!-- Footer End -->

        </div>

        <!-- ========================
			End Page Content
		========================= -->

    </div>
    <!-- End Wrapper -->

    <!-- Start Delete Modal  -->
    <div class="modal fade" id="delete_modal">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                    <img src="assets/img/bg/delete-modal-bg-01.png" alt="" class="img-fluid position-absolute top-0 start-0 z-0">
                    <img src="assets/img/bg/delete-modal-bg-02.png" alt="" class="img-fluid position-absolute bottom-0 end-0 z-0">
                    <div class="mb-3 position-relative z-1">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1 position-relative z-1">Delete Confirmation</h5>
                    <p class="mb-3 position-relative z-1">Are you sure want to delete?</p>
                    <div class="d-flex justify-content-center">
                        <a href="javascript:void(0);" class="btn btn-light position-relative z-1 me-3" data-bs-dismiss="modal">Cancel</a>
                        <a href="" class="btn btn-danger position-relative z-1" data-bs-dismiss="modal">Yes, Delete</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Delete Modal  -->

    <!-- jQuery -->
    <script src="assets/js/jquery-3.7.1.min.js"></script>

    <!-- Bootstrap Core JS -->
    <script src="assets/js/bootstrap.bundle.min.js"></script>    

	<!-- Simplebar JS -->
	<script src="assets/plugins/simplebar/simplebar.min.js"></script>

    <!-- Lightbox JS -->
    <script src="assets/plugins/lightbox/glightbox.min.js"></script>
    <script src="assets/plugins/lightbox/lightbox.js"></script>

    <!-- Chart JS -->
    <script src="assets/plugins/apexchart/apexcharts.min.js"></script>
    <script src="assets/plugins/apexchart/chart-data.js"></script>

    <!-- Main JS -->
    <script src="assets/js/script.js"></script>

</body>

</html>