
<!DOCTYPE html>
<html lang="en">

<head>

	<!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Doctors | Preclinic - Medical & Hospital - Bootstrap 5 Admin Template</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="author" content="Dreams Technologies">
	
    <!-- Favicon -->
    <link rel="shortcut icon" href="assets/img/favicon.png">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="assets/img/apple-icon.png">

    <!-- Theme Config Js -->
    <script src="assets/js/theme-script.js"></script>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <!-- Tabler Icon CSS -->
    <link rel="stylesheet" href="assets/plugins/tabler-icons/tabler-icons.min.css">

    <!-- Font Awosome Icon CSS -->
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/plugins/fontawesome/css/all.min.css">

    <!-- Select2 CSS -->
    <link rel="stylesheet" href="assets/plugins/select2/css/select2.min.css">

	<!-- Daterangepikcer CSS -->
	<link rel="stylesheet" href="assets/plugins/daterangepicker/daterangepicker.css">

    <!-- Datetimepicker CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap-datetimepicker.min.css">

    <!-- Simplebar CSS -->
    <link rel="stylesheet" href="assets/plugins/simplebar/simplebar.min.css">

    <!-- Datatable CSS -->
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap5.min.css">

    <!-- Main CSS -->
    <link rel="stylesheet" href="assets/css/style.css" id="app-style">

</head>

<body>

    <!-- Begin Wrapper -->
    <div class="main-wrapper">

        <!-- Topbar Start -->
        <header class="navbar-header">
            <div class="page-container topbar-menu">
                <div class="d-flex align-items-center gap-2">

                    <!-- Logo -->
                    <a href="index.html" class="logo">

                        <!-- Logo Normal -->
                        <span class="logo-light">
                            <span class="logo-lg"><img src="assets/img/logo.svg" alt="logo"></span>
                            <span class="logo-sm"><img src="assets/img/logo-small.svg" alt="small logo"></span>
                        </span>

                        <!-- Logo Dark -->
                        <span class="logo-dark">
                            <span class="logo-lg"><img src="assets/img/logo-white.svg" alt="dark logo"></span>
                        </span>
                    </a>

                    <!-- Sidebar Mobile Button -->
                    <a id="mobile_btn" class="mobile-btn" href="#sidebar">
                        <i class="ti ti-menu-deep fs-24"></i>
                    </a>
                       
                    <button class="sidenav-toggle-btn btn border-0 p-0 active" id="toggle_btn2"> 
                        <i class="ti ti-arrow-right"></i>
                    </button>  
					
                    <!-- Search -->
                    <div class="me-auto d-flex align-items-center header-search d-lg-flex d-none">
                        <!-- Search -->
                        <div class="input-icon-start position-relative me-2">
                            <span class="input-icon-addon">
                                <i class="ti ti-search"></i>
                            </span>
                           <input type="text" class="form-control shadow-sm" placeholder="Search">
                           <span class="input-icon-addon text-dark shadow fs-18 d-inline-flex p-0 header-search-icon"><i class="ti ti-command"></i></span>
                        </div>
                        <!-- /Search -->
                    </div>
					
                </div>

                <div class="d-flex align-items-center">
				
                    <!-- Search for Mobile -->
                    <div class="header-item d-flex d-lg-none me-2">
                        <button class="topbar-link btn btn-icon" data-bs-toggle="modal" data-bs-target="#searchModal" type="button">
                            <i class="ti ti-search fs-16"></i>
                        </button>
                    </div>
					
                    <!-- AI Assistance -->
					<a href="javascript:void(0);" class="btn btn-liner-gradient me-3 d-lg-flex d-none">AI Assistance<i class="ti ti-chart-bubble-filled ms-1"></i></a>

                    <div class="header-item">
                        <div class="dropdown me-2">
                            <a href="doctors-appointments.html" class="btn topbar-link"><i class="ti ti-calendar-due"></i></a>
                        </div>
                    </div>                    

                    <div class="header-item">
                        <div class="dropdown me-2">
                            <a href="doctors-profile-settings.html" class="btn topbar-link"><i class="ti ti-settings-2"></i></a>
                        </div> 
                    </div>                    

                    <!-- Light/Dark Mode Button -->
                    <div class="header-item d-none d-sm-flex me-2">
                        <button class="topbar-link btn btn-icon topbar-link" id="light-dark-mode" type="button">
                            <i class="ti ti-moon fs-16"></i>
                        </button>
                    </div>
                    
					
					<!-- Notification Dropdown -->
                    <div class="header-item">
						<div class="dropdown me-3">
						
							<button class="topbar-link btn btn-icon topbar-link dropdown-toggle drop-arrow-none" data-bs-toggle="dropdown" data-bs-offset="0,24" type="button" aria-haspopup="false" aria-expanded="false">
								<i class="ti ti-bell-check fs-16 animate-ring"></i>
								<span class="notification-badge"></span>
							</button>
							
							<div class="dropdown-menu p-0 dropdown-menu-end dropdown-menu-lg" style="min-height: 300px;">
							
								<div class="p-2 border-bottom">
									<div class="row align-items-center">
										<div class="col">
											<h6 class="m-0 fs-16 fw-semibold"> Notifications</h6>
										</div>
									</div>
								</div>
								
								<!-- Notification Body -->
								<div class="notification-body position-relative z-2 rounded-0" data-simplebar>
								 
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-1">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-01.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Dr. Smith</p>
												<p class="mb-1 text-wrap">
													updated the <span class="fw-medium text-dark">surgery</span> schedule. 
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>4 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-1">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
							
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-2">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-06.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Dr. Patel</p>
												<p class="mb-1 text-wrap">
                                                    completed a <span class="fw-medium text-dark">follow-up</span> report for patient <span class="fw-medium text-dark">Emily</span>.
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>8 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-2">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap border-bottom" id="notification-3">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-02.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Emily</p>
												<p class="mb-1 text-wrap">
                                                    booked an appointment with <span class="fw-medium text-dark">Dr. Patel</span> for <span class="fw-medium text-dark">April 15</span>
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>15 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-3">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									
									<!-- Item-->
									<div class="dropdown-item notification-item py-3 text-wrap" id="notification-4">
										<div class="d-flex">
											<div class="me-2 position-relative flex-shrink-0">
												<img src="assets/img/doctors/doctor-07.jpg" class="avatar-md rounded-circle" alt="">
											</div>
											<div class="flex-grow-1">
												<p class="mb-0 fw-medium text-dark">Amelia</p>
												<p class="mb-1 text-wrap">
                                                    completed the <span class="fw-medium text-dark">pre-visit</span> health questionnaire.
												</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="fs-12"><i class="ti ti-clock me-1"></i>20 min ago</span>
													<div class="notification-action d-flex align-items-center float-end gap-2">
														<a href="javascript:void(0);" class="notification-read rounded-circle bg-danger" data-bs-toggle="tooltip" title="" data-bs-original-title="Make as Read" aria-label="Make as Read"></a>
														<button class="btn rounded-circle p-0" data-dismissible="#notification-4">
															<i class="ti ti-x"></i>
														</button>
													</div>
												</div>
											</div>
										</div>
									</div>
									 
								</div>
								
								<!-- View All-->
								<div class="p-2 rounded-bottom border-top text-center">
									<a href="doctors-notifications.html" class="text-center text-decoration-underline fs-14 mb-0">
										View All Notifications
									</a>
								</div> 
								
							</div>
						</div>
					</div>
					
					<!-- User Dropdown -->
					<div class="dropdown profile-dropdown d-flex align-items-center justify-content-center">
                        <a href="javascript:void(0);" class="topbar-link dropdown-toggle drop-arrow-none position-relative" data-bs-toggle="dropdown" data-bs-offset="0,22" aria-haspopup="false" aria-expanded="false">
                            <img src="assets/img/doctors/doctor-01.jpg" width="32" class="rounded-circle d-flex" alt="user-image">
                            <span class="online text-success"><i class="ti ti-circle-filled d-flex bg-white rounded-circle border border-1 border-white"></i></span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end dropdown-menu-md p-2">
                        
                            <div class="d-flex align-items-center bg-light rounded-3 p-2 mb-2">
                                <img src="assets/img/doctors/doctor-01.jpg" class="rounded-circle" width="42" height="42" alt="">
                                <div class="ms-2">
                                    <p class="fw-medium text-dark mb-0">Dr.Michael Smith</p>
                                    <span class="d-block fs-13">Cardiologist</span>
                                </div>
                            </div>

                            <!-- Item-->
                            <a href="doctors-profile-settings.html" class="dropdown-item">
                                <i class="ti ti-user-circle me-1 align-middle"></i>
                                <span class="align-middle">Profile Settings</span>
                            </a>

                            <!-- item -->
                            <div class="form-check form-switch form-check-reverse d-flex align-items-center justify-content-between dropdown-item mb-0">
                                <label class="form-check-label" for="notify"><i class="ti ti-bell me-1"></i>Notifications</label>
                                <input class="form-check-input me-0" type="checkbox" role="switch" id="notify">
                            </div>

                            <!-- Item-->
                            <a href="javascript:void(0);" class="dropdown-item">
                                <i class="ti ti-receipt me-1 align-middle"></i>
                                <span class="align-middle">Activity Logs</span>
                            </a>

                             <!-- Item-->
                             <a href="javascript:void(0);" class="dropdown-item">
                                <i class="ti ti-help me-1 align-middle"></i>
                                <span class="align-middle">Help & Support</span>
                            </a>
                                        
                            
                            <!-- Item-->
                            <div class="pt-2 mt-2 border-top">
                                <a href="login.html" class="dropdown-item text-danger">
                                    <i class="ti ti-logout me-1 fs-17 align-middle"></i>
                                    <span class="align-middle">Log Out</span>
                                </a>
                            </div>
                        </div>
                    </div>
						
                </div>
            </div>
        </header>
        <!-- Topbar End -->

        <!-- Search Modal -->
        <div class="modal fade" id="searchModal">
            <div class="modal-dialog modal-lg">
                <div class="modal-content bg-transparent">
                    <div class="card shadow-none mb-0">
                        <div class="px-3 py-2 d-flex flex-row align-items-center" id="search-top">
                            <i class="ti ti-search fs-22"></i>
                            <input type="search" class="form-control border-0" placeholder="Search">
                            <button type="button" class="btn p-0" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-x fs-22"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidenav Menu Start -->
        <div class="sidebar" id="sidebar">
            
            <!-- Start Logo -->
            <div class="sidebar-logo">
                <div>
                    <!-- Logo Normal -->
                    <a href="index.html" class="logo logo-normal">
                        <img src="assets/img/logo.svg" alt="Logo">
                    </a>

                    <!-- Logo Small -->
                    <a href="index.html" class="logo-small">
                        <img src="assets/img/logo-small.svg" alt="Logo">
                    </a>

                    <!-- Logo Dark -->
                    <a href="index.html" class="dark-logo">
                        <img src="assets/img/logo-white.svg" alt="Logo">
                    </a>
                </div>
                <button class="sidenav-toggle-btn btn border-0 p-0 active" id="toggle_btn"> 
                    <i class="ti ti-arrow-left"></i>
                </button>

                <!-- Sidebar Menu Close -->
                <button class="sidebar-close">
                    <i class="ti ti-x align-middle"></i>
                </button>                
            </div>
            <!-- End Logo -->

            <!-- Sidenav Menu -->
            <div class="sidebar-inner" data-simplebar>                
                <div id="sidebar-menu" class="sidebar-menu">
                    <ul>
                        <li class="menu-title"><span>Main Menu</span></li>
                        <li>
                            <ul>
                                <li>
                                    <a href="doctor-dashboard.html">
                                        <i class="ti ti-layout-dashboard"></i><span>Dashboard</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);" class="active subdrop">
                                        <i class="ti ti-calendar-check"></i><span>Appointments</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="doctors-appointments.html" class="active">Appointments</a></li>
                                        <li><a href="online-consultations.html">Online Consultations</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="doctors-schedules.html">
                                        <i class="ti ti-clock-check"></i><span>My Schedule</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="doctors-prescriptions.html">
                                        <i class="ti ti-prescription"></i><span>Prescriptions</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="doctors-leaves.html">
                                        <i class="ti ti-calendar-x"></i><span>Leave</span>
                                    </a>
                                </li>
                                <li>
                                    <a href="doctors-reviews.html">
                                        <i class="ti ti-star"></i><span>Reviews</span>
                                    </a>
                                </li>
                                <li class="submenu">
                                    <a href="javascript:void(0);">
                                        <i class="ti ti-settings"></i><span>Settings</span>
                                        <span class="menu-arrow"></span>
                                    </a>
                                    <ul>
                                        <li><a href="doctors-profile-settings.html">Profile Settings</a></li>
                                        <li><a href="doctors-password-settings.html">Change Password</a></li>
                                        <li><a href="doctors-notification-settings.html">Notifications</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                                        
                    </ul>                   
                </div>
                <div class="sidebar-footer border-top mt-3">
                    <div class="trial-item mt-0 p-3 text-center">
                        <div class="trial-item-icon rounded-4 mb-3 p-2 text-center shadow-sm d-inline-flex">
                            <img src="./assets/img/icons/sidebar-icon.svg" alt="img">
                        </div>
                        <div>
                            <h6 class="fs-14 fw-semibold mb-1">Upgrade To Pro</h6>
                            <p class="fs-13 mb-0">Check 1 min video and begin use Preclinic like a pro</p>
                        </div>
                        <a href="javascript:void(0);" class="close-icon shadow-sm"><i class="ti ti-x"></i></a>
                    </div>
                </div>
            </div>

        </div>
        <!-- Sidenav Menu End -->

        <!-- ========================
			Start Page Content
		========================= -->
         
        <div class="page-wrapper">

            <!-- Start Content -->
            <div class="content">

                <!-- Start Page Header -->
                <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
                    <div class="flex-grow-1">
                        <h4 class="fw-bold mb-0"> Patient Details </h4>
                    </div>
                    <div class="text-end d-flex">
                        <!-- dropdown-->
                        <div class="dropdown me-1">
							<a href="javascript:void(0);" class="btn btn-md fs-14 fw-normal border bg-white rounded text-dark d-inline-flex align-items-center"  data-bs-toggle="dropdown">
								Export<i class="ti ti-chevron-down ms-2"></i>
							</a>
							<ul class="dropdown-menu p-2">
								<li>
									<a class="dropdown-item" href="#">Download as PDF</a>
								</li>
								<li>
									<a class="dropdown-item" href="#">Download as Excel</a>
								</li>
							</ul>
						</div>

                    </div>
				</div>
				<!-- End Page Header -->
                 
                <!-- card start -->
                <div class="card">
                    <div class="row align-items-end">
                        <div class="col-xl-9 col-lg-8">
                            <div class="d-sm-flex align-items-center position-relative z-0 overflow-hidden p-3">
                                <img src="./assets/img/icons/shape-01.svg" alt="img" class="z-n1 position-absolute end-0 top-0 d-none d-lg-flex">
                                <a href="javascript:void(0);" class="avatar avatar-xxxl patient-avatar me-2 flex-shrink-0">
                                    <img src="assets/img/users/user-08.jpg" alt="product" class="rounded">
                                </a>
                                <div>
                                    <p class="text-primary mb-1">#PT0025</p>
                                    <h5 class="mb-1"><a href="javascript:void(0);" class="fw-bold">Alberto Ripley</a></h5>
                                    <p class="mb-3">4150 Hiney Road, Las Vegas, NV 89109</p>
                                    <div class="d-flex align-items-center flex-wrap">
                                        <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-phone me-1 text-dark"></i>Phone : <span class="text-dark ms-1">+1 54546 45648</span></p>
                                        <span class="mx-2 text-light">|</span>
                                        <p class="mb-0 d-inline-flex align-items-center"><i class="ti ti-calendar-time me-1 text-dark"></i>Last Visited : <span class="text-dark ms-1">30 Apr 2025</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-4">
                            <div class="p-3 text-lg-end">
                                <div class="mb-4">
                                    <a href="javascript:void(0);" class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2"><i class="ti ti-phone"></i></a>
                                    <a href="javascript:void(0);" class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14 me-2"><i class="ti ti-message-circle"></i></a>
                                    <a href="javascript:void(0);" class="btn btn-outline-white shadow-sm rounded-circle d-inline-flex align-items-center p-2 fs-14"><i class="ti ti-video"></i></a>
                                </div>
                                <a href="patient-appointment-details.html" class="btn btn-primary"><i class="ti ti-calendar-event me-1"></i>Book Apppointment</a>
                            </div>
                        </div>
                      </div>
                </div>
                <!-- card end -->

                <!-- row start -->
                <div class="row">
                    <div class="col-xl-5 d-flex">
                       <div class="card shadow-sm flex-fill w-100">
                           <div class="card-header">
                              <h5 class="fw-bold mb-0"><i class="ti ti-user-star me-1"></i>About</h5>
                           </div>
                           <div class="card-body pb-0">
                               <div class="row">
                                  <div class="col-sm-5">
                                      <div class="d-flex align-items-center mb-3">
                                        <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-calendar-event fs-16"></i></span>
                                        <div>
                                            <h6 class="fs-13 fw-bold mb-1">DOB</h6>
                                            <p class="mb-0">25 Jan 1990</p>
                                        </div>
                                      </div>
                                  </div>
                                  <div class="col-sm-7">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-droplet fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">Blood Group</h6>
                                          <p class="mb-0">O +ve</p>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-sm-5">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-gender-male fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">Gender</h6>
                                          <p class="mb-0">Male</p>
                                      </div>
                                    </div>
                                  </div>
                                  <div class="col-sm-7">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-circle bg-light text-dark flex-shrink-0 me-2"><i class="ti ti-mail fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">Email</h6>
                                          <p class="mb-0 text-break">alberto@example.com</p>
                                      </div>
                                    </div>
                                  </div>
                               </div>
                           </div>
                       </div>
                    </div>
                    <div class="col-xl-7 d-flex">
                        <div class="card shadow-sm flex-fill w-100">
                            <div class="card-header">
                               <h5 class="fw-bold mb-0"><i class="ti ti-book me-1"></i>Vital Signs</h5>
                            </div>
                            <div class="card-body pb-0">
                                <div class="row">
                                   <div class="col-sm-4">
                                       <div class="d-flex align-items-center mb-3">
                                         <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-droplet fs-16"></i></span>
                                         <div>
                                             <h6 class="fs-13 fw-bold mb-1 text-truncate">Blood Pressure</h6>
                                             <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>100/67 mmHg</p>
                                         </div>
                                       </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-heart-rate-monitor fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Heart Rate</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-danger fs-18"></i>89 Bpm</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-hexagons fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1">SPO2</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>98 %</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-temperature fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Temperature</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>101 C</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-activity fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Respiratory Rate</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-danger fs-18"></i>24 rpm</p>
                                      </div>
                                    </div>
                                   </div>
                                   <div class="col-sm-4">
                                    <div class="d-flex align-items-center mb-3">
                                      <span class="avatar rounded-2 bg-light text-dark flex-shrink-0 me-2 border"><i class="ti ti-weight fs-16"></i></span>
                                      <div>
                                          <h6 class="fs-13 fw-bold mb-1 text-truncate">Weight</h6>
                                          <p class="mb-0 d-inline-flex align-items-center text-truncate"><i class="ti ti-point-filled me-1 text-success fs-18"></i>100 kg</p>
                                      </div>
                                    </div>
                                   </div>
                                </div>
                            </div>
                        </div>
                     </div>
                </div>
                <!-- row end -->

                <!-- tab start -->
                <ul class="nav nav-tabs nav-bordered mb-3">
                    <li class="nav-item">
                        <a href="#appointments" data-bs-toggle="tab" aria-expanded="false" class="nav-link active bg-transparent">
                            <span>Appointments</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#transactions" data-bs-toggle="tab" aria-expanded="true" class="nav-link bg-transparent">
                            <span>Transactions</span>
                        </a>
                    </li>
                </ul>
                <!-- tab end -->                

                <!-- tab content start -->
                <div class="tab-content">
                    <div class="tab-pane show active" id="appointments">

                        <!--  Start Filter -->
                        <div class=" d-flex align-items-center justify-content-between flex-wrap">
                            <div class="d-flex align-items-center gap-2">
                                <div class="search-set mb-3">
                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                        <div class="table-search d-flex align-items-center mb-0">
                                            <div class="search-input">
                                                <a href="javascript:void(0);" class="btn-searchset"></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex right-content align-items-center flex-wrap mb-3">
                                    <div class="reportrange-picker d-flex align-items-center reportrange">
                                        <i class="ti ti-calendar text-gray-5 fs-14 me-1"></i><span class="reportrange-picker-field">16 Apr 25 - 16 Apr 25</span>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
                                <div class="dropdown me-2">
                                    <a href="javascript:void(0);" class="bg-white border rounded btn btn-md text-dark fs-14 py-1 align-items-center d-flex fw-normal" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                                    </a>
                                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown p-0">
                                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                                            <h4 class="mb-0 fw-bold">Filter</h4>
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="link-danger text-decoration-underline">Clear All</a>
                                            </div>
                                        </div>
                                        <form action="#">
                                            <div class="filter-body pb-0">
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Doctor</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-01.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Mick Thompson
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-02.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Sarah Johnson
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-03.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Emily Carter
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-04.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. David Lee
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        <span class="avatar avatar-xs rounded-circle me-2"><img src="assets/img/doctors/doctor-05.jpg" class="flex-shrink-0 rounded-circle" alt="img"></span>Dr. Anna Kim
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Designation</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cardiologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Orthopedic Surgeon
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Pediatrician
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Gynecologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Psychiatrist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Neurosurgeon
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Oncologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Pulmonologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Urologist
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Dermatologist
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Mode</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        In Person
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Online
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label mb-1 text-dark fs-14 fw-medium">Date<span class="text-danger">*</span></label>
                                                    <div class="input-icon-end position-relative">  
                                                        <input type="text" class="form-control bookingrange" placeholder="dd/mm/yyyy">
                                                        <span class="input-icon-addon">
                                                            <i class="ti ti-calendar"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Status</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Checked Out
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Checked In
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cancelled
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Schedule
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Confirmed
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                                                <a href="javascript:void(0);" class="btn btn-light btn-md me-2 fw-medium close-filter">Close</a>
                                                <button type="submit" class="btn btn-primary btn-md fw-medium">Filter</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--  End Filter -->

                        <!--  Start Table -->
                        <div class="table-responsive">
                            <table class="table datatable table-nowrap">
                                <thead class="">
                                    <tr>
                                        <th class="no-sort">
                                            Date & Time
                                        </th>
                                        <th>Doctor Name</th>
                                        <th>Mode</th>
                                        <th>Status</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>30 Apr 2025 - 09:30 AM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-01.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Mick Thompson</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Cardiologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            In-person
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium">Checked Out</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    
                                    <tr>
                                        <td>15 Apr 2025 - 11:20 AM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-02.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Sarah Johnson</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Orthopedic Surgeon</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            Online
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-warning rounded text-warning fw-medium">Checked In</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>02 Apr 2025 - 08:15 AM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-03.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Emily Carter</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Pediatrician</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            In-Person
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-danger rounded text-danger fw-medium">Cancelled</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>27 Mar 2025 - 02:00 PM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-04.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. David Lee</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Gynecologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            30 Apr 2025
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium">Schedule</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>12 Mar 2025 - 05:40 PM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-05.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Anna Kim</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Psychiatrist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            Online
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium">Confirmed</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center"  data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>24 Feb 2025 - 09:20 AM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-06.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. John Smith</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Neurosurgeon</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            In-Person
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-danger rounded text-danger fw-medium">Cancelled</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>16 Feb 2025 - 11:40 AM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-07.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Lisa White</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Oncologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            Online
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium">Confirmed</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>01 Feb 2025 - 04:00 PM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-08.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Patricia Brown</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Pulmonologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            Online
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium">Checked Out</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>25 Jan 2025 - 03:10 PM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-09.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Rachel Green</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Urologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            Online
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-primary rounded text-primary fw-medium">Schedule</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>12 Jan 2025 - 03:10 PM</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <a href="patient-doctors.html" class="avatar me-2 flex-shrink-0">
                                                    <img src="assets/img/doctors/doctor-10.jpg" alt="img" class="rounded-circle">
                                                </a>
                                                <div>
                                                <h6 class="fs-14 mb-1 text-truncate"><a href="patient-doctors.html" class="fw-semibold">Dr. Michael Smith</a></h6>
                                                <p class="mb-0 fs-13 text-truncate">Cardiologist</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            In-Person	
                                        </td>
                                        <td> <span class="badge fs-13 badge-soft-danger rounded text-danger fw-medium">cancelled</span> </td>
                                        <td class="action-item">
                                            <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                                <i class="ti ti-dots-vertical"></i>
                                            </a>
                                            <ul class="dropdown-menu p-2">
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="offcanvas" data-bs-target="#view_details">View</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#delete_modal">Delete</a>
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!--  End Table -->

                    </div>
                    <div class="tab-pane" id="transactions">

                        <!--  Start Filter -->
                        <div class=" d-flex align-items-center justify-content-between flex-wrap">
                            <div class="d-flex align-items-center gap-2">
                                <div class="search-set mb-3">
                                    <div class="d-flex align-items-center flex-wrap gap-2">
                                        <div class="table-search d-flex align-items-center mb-0">
                                            <div class="search-input">
                                                <a href="javascript:void(0);" class="btn-searchset"></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex right-content align-items-center flex-wrap mb-3">
                                    <div class="reportrange-picker d-flex align-items-center reportrange">
                                        <i class="ti ti-calendar text-gray-5 fs-14 me-1"></i><span class="reportrange-picker-field">16 Apr 25 - 16 Apr 25</span>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
                                <div class="dropdown me-2">
                                    <a href="javascript:void(0);" class="bg-white border rounded btn btn-md text-dark fs-14 py-1 align-items-center d-flex fw-normal" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                                    </a>
                                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown p-0">
                                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                                            <h4 class="mb-0 fw-bold">Filter</h4>
                                            <div class="d-flex align-items-center">
                                                <a href="javascript:void(0);" class="link-danger text-decoration-underline">Clear All</a>
                                            </div>
                                        </div>
                                        <form action="#">
                                            <div class="filter-body pb-0">
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Transaction ID</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0025
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0024
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0023
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0022
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0021
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0020
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        #TNX0019
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Description</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        General Consultation
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Dental Cleaning
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Eye Checkup
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        X-Ray
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Physiotherapy Session
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cardiac Screening
                                                                    </label>
                                                                </li>
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Skin Allergy Test
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label mb-1 text-dark fs-14 fw-medium">Date<span class="text-danger">*</span></label>
                                                    <div class="input-icon-end position-relative">  
                                                        <input type="text" class="form-control datetimepicker" placeholder="dd/mm/yyyy">
                                                        <span class="input-icon-addon">
                                                            <i class="ti ti-calendar"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Payment Method</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        PayPal
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Debit Card
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Cheque
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 close-filter">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Amount</label>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle form-control" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">							
                                                            <div class="filter-range">
                                                                <input type="text" id="range_03">
                                                                <p>Range : <span class="text-gray-9">$200 - $5695</span></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <label class="form-label">Status</label>
                                                        <a href="javascript:void(0);" class="link-primary mb-1">Reset</a>
                                                    </div>
                                                    <div class="dropdown">
                                                        <a href="javascript:void(0);" class="dropdown-toggle btn bg-white  d-flex align-items-center justify-content-start fs-13 p-2 fw-normal border" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="true">
                                                            Select <i class="ti ti-chevron-down ms-auto"></i>
                                                        </a>
                                                        <div class="dropdown-menu shadow-lg w-100 dropdown-info p-3">
                                                            <div class="mb-3">
                                                                <div class="input-icon-start input-icon position-relative">
                                                                    <span class="input-icon-addon fs-12">
                                                                        <i class="ti ti-search"></i>
                                                                    </span>
                                                                    <input type="text" class="form-control form-control-md" placeholder="Search">
                                                                </div>
                                                            </div>
                                                            <ul class="mb-3">
                                                                <li class="mb-1">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Completed
                                                                    </label>
                                                                </li>
                                                                <li class="mb-0">
                                                                    <label class="dropdown-item px-2 d-flex align-items-center text-dark">
                                                                        <input class="form-check-input m-0 me-2" type="checkbox">
                                                                        Pending
                                                                    </label>
                                                                </li>
                                                            </ul>
                                                            <div class="row g-2">
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-outline-white w-100 filter-close">Cancel</a>
                                                                </div>
                                                                <div class="col-6">
                                                                    <a href="javascript:void(0);" class="btn btn-primary w-100">Select</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                                                <a href="javascript:void(0);" class="btn btn-light btn-md me-2 fw-medium close-filter">Close</a>
                                                <button type="submit" class="btn btn-primary btn-md fw-medium">Filter</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--  End Filter -->

                        <!--  Start Table -->
                        <div class="table-responsive">
                            <table class="table table-nowrap datatable">
                                <thead class="thead-light">
                                    <tr>
                                        <th class="no-sort">
                                            Transaction ID
                                        </th>
                                        <th>Description</th>
                                        <th>Paid  Date</th>
                                        <th>Payment Method</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0025</a></td>
                                        <td class="text-dark"> General Consultation </td>
                                        <td class="text-dark"> 30 Apr 2025</td>
                                        <td class="text-dark"> PayPal</td>
                                        <td class="text-dark"> $800</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0024</a></td>
                                        <td class="text-dark">Dental Cleaning</td>
                                        <td class="text-dark"> 15 Apr 2025</td>
                                        <td class="text-dark"> Debit Card </td>
                                        <td class="text-dark"> $930</td>
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium border border-info">Pending</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0023</a></td>
                                        <td class="text-dark"> Eye Checkup </td>
                                        <td class="text-dark"> 02 Apr 2025 </td>
                                        <td class="text-dark"> Cheque </td>
                                        <td class="text-dark"> $850</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0022</a></td>
                                        <td class="text-dark"> X-Ray </td>
                                        <td class="text-dark"> 27 Mar 2025 </td>
                                        <td class="text-dark"> Debit Card</td>
                                        <td class="text-dark"> $80</td>
                                        
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0021</a></td>
                                        <td class="text-dark">
                                            Physiotherapy Session
                                        </td>
                                        <td class="text-dark"> 12 Mar 2025</td>
                                        <td class="text-dark"> PayPal</td>
                                        <td class="text-dark"> $650</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0020</a></td>
                                        <td class="text-dark">
                                            Cardiac Screening
                                        </td>
                                        <td class="text-dark"> 05 Mar 2025 </td>
                                        <td class="text-dark"> Cheque </td>
                                        <td class="text-dark"> $430 </td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0019</a></td>
                                        <td class="text-dark">
                                            Skin Allergy Test
                                        </td>
                                        <td class="text-dark"> 24 Feb 2025 </td>
                                        <td class="text-dark"> Debit Card </td>
                                        <td class="text-dark"> $300</td>
                                        
                                        <td> <span class="badge fs-13 badge-soft-info rounded text-info fw-medium border border-info">Pending</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0018</a></td>
                                        <td class="text-dark">
                                            Blood Test
                                        </td>
                                        <td class="text-dark"> 16 Feb 2025 </td>
                                        <td class="text-dark"> Cheque </td>
                                        <td class="text-dark"> $450</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0017</a></td>
                                        <td class="text-dark">
                                            ENT Consultation
                                        </td>
                                        <td class="text-dark"> 01 Feb 2025 </td>
                                        <td class="text-dark"> Debit Card </td>
                                        <td class="fw-semibold text-dark"> $570</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success"> completed</span> </td>
                                    </tr>
                                    <tr>
                                        <td> <a href="javascript:void(0);">#TNX0017</a></td>
                                        <td class="text-dark">
                                            Nutrition Counseling
                                        </td>
                                        <td class="text-dark"> 25 Jan 2025 </td>
                                        <td class="text-dark"> PayPal</td>
                                        <td class="text-dark"> $800</td>
                                        <td> <span class="badge fs-13 badge-soft-success rounded text-success fw-medium border border-success">Completed</span> </td>
                                    </tr>

                                </tbody>
                            </table>
                        </div>
                        <!--  End Table -->

                    </div>
                </div>
                <!-- tab content end -->

            </div>
            <!-- End Content -->

            <!-- Footer Start -->
            <div class="footer text-center bg-white p-2 border-top">
                <p class="text-dark mb-0">2025 &copy; <a href="javascript:void(0);" class="link-primary">Preclinic</a>, All Rights Reserved</p>
            </div>
            <!-- Footer End -->

        </div>

        <!-- ========================
			End Page Content
		========================= -->

    </div>
    <!-- End Wrapper -->

    <!-- jQuery -->
    <script src="assets/js/jquery-3.7.1.min.js"></script>

    <!-- Bootstrap Core JS -->
    <script src="assets/js/bootstrap.bundle.min.js"></script>    

	<!-- Simplebar JS -->
	<script src="assets/plugins/simplebar/simplebar.min.js"></script>

    <!-- Datetimepicker JS -->
    <script src="assets/js/moment.min.js"></script>
    <script src="assets/js/bootstrap-datetimepicker.min.js"></script> 

    <!-- Sticky Sidebar JS -->
    <script src="assets/plugins/theia-sticky-sidebar/ResizeSensor.js"></script>
    <script src="assets/plugins/theia-sticky-sidebar/theia-sticky-sidebar.js"></script>

    <!-- Select2 JS -->
    <script src="assets/plugins/select2/js/select2.min.js"></script>

    <!-- Main JS -->
    <script src="assets/js/social-feed.js"></script>
    <script src="assets/js/email.js"></script>
    <script src="assets/js/script.js"></script>

</body>

</html>