@extends('layouts.mail')

@section('title', 'New Patient Created')

@section('content')
    <h2>Hi Dr. {{ $adminDoctor->name }},</h2>
    <p>A new patient profile has been successfully created under your clinic on PRED Care.</p>

    <h3>Patient Details:</h3>
    <ul>
        <li><strong>Name:</strong> {{ $patient->user->name }}</li>
        <li><strong>Patient ID:</strong> {{ $patient->id }}</li>
        <li><strong>Mobile:</strong> {{ $patient->phone ?? 'N/A' }}</li>
        <li><strong>Email:</strong> {{ $patient->user->email }}</li>
        <li><strong>Gender:</strong> {{ ucfirst($patient->gender) ?? 'N/A' }}</li>
        <li><strong>Date of Birth:</strong> {{ $patient->date_of_birth ? \Carbon\Carbon::parse($patient->date_of_birth)->format('d/m/Y') : 'N/A' }}</li>
        <li><strong>Created By:</strong> {{ $createdBy->name }}</li>
        <li><strong>Created On:</strong> {{ $createdAt->format('d/m/Y H:i') }}</li>
    </ul>

    <p>You can now view and manage this patient's EMR, prescriptions, appointments, and more through your dashboard.</p>

    <p style="text-align: center;">
        <a href="{{ config('app.url') }}/login" class="action-button">Login to PRED Care</a>
    </p>

    <p><strong>Useful Links:</strong><br>
        <a href="{{ config('app.url') }}/help">Help Center</a><br>
        <a href="mailto:info@predcare.in">Contact Support</a>
    </p>

    <p>Thank you,<br>The PRED Care Team</p>
@endsection
