@extends('layouts.mail')

@section('title', 'Welcome to PRED Care – Your Clinic Account is Ready!')

@section('content')
    <h2>Hi {{ $clinicAdminName }},</h2>
    <p>Welcome to PRED Care – your complete clinic and practice management solution!</p>

    <p>Your clinic account has been successfully created. Below are your login details:</p>

    <h3>Clinic Login Details:</h3>
    <ul>
        <li><strong>Clinic Name:</strong> {{ $clinicName }}</li>
        <li><strong>Admin Username:</strong> {{ $adminUsername }}</li>
        <li><strong>Temporary Password:</strong> {{ $temporaryPassword }}</li>
    </ul>

    <p>
        <strong>Login URL:</strong> 
        <a href="https://www.predcare.in/login">https://www.predcare.in/login</a>
    </p>

    <p style="color: #d32f2f; font-weight: 600;">
        ⚠️ Important: Please log in and change your password immediately for your security.
    </p>

    <h3>Quick Links:</h3>
    <ul>
        <li><a href="https://www.predcare.in/getting-started">Getting Started Guide</a></li>
        <li><a href="https://www.predcare.in/support">Help & Support</a></li>
        <li><a href="https://www.predcare.in/features">Explore Features</a></li>
        <li><a href="mailto:info@predcare.in">Contact Support</a></li>
    </ul>

    <p>
        With PRED Care, you can manage appointments, staff, digital prescriptions, EMRs, telemedicine, reminders, analytics, and more – all in one place.
    </p>

    <p>
        We’re here to help you get the most out of your practice. Feel free to reach out if you need any assistance.
    </p>

    <p>Warm regards,<br />PRED Care Team</p>
@endsection
