<div class="sidebar-top shadow-sm p-2 rounded-1 mb-3 dropend">
    @if (count($clinics) > 0)
        <a href="javascript:void(0);" class="drop-arrow-none" data-bs-toggle="dropdown" data-bs-auto-close="outside"
            data-bs-offset="0,22" aria-haspopup="false" aria-expanded="false">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">

                    <div
                        class="avatar-initial rounded-circle bg-primary text-white d-flex align-items-center justify-content-center fw-bold" style="width: 35px; height: 35px; font-size: 16px;">
                        {{ getInitials($currentClinic['name']) }}
                    </div>

                    <div class="ms-2">
                        <h6 class="fs-14 fw-semibold mb-0">{{ $currentClinic['name'] ?? 'Select Clinic' }}</h6>
                        <p class="fs-13 mb-0">
                            @if ($currentClinic['is_primary'] ?? false)
                                Primary
                            @else
                                Clinic
                            @endif
                        </p>
                    </div>
                </div>
                <i class="ti ti-arrows-transfer-up"></i>
            </div>
        </a>
        <div class="dropdown-menu dropdown-menu-lg bg-white">
            <div class="p-2">
                @foreach ($clinics as $clinic)
                    <label class="dropdown-item d-flex align-items-center justify-content-between p-1"
                        wire:click="selectClinic('{{ $clinic['id'] }}')">
                        <span class="d-flex align-items-center">

                            <div
                                class="avatar-initial rounded-circle bg-primary text-white d-flex align-items-center justify-content-center fw-bold me-2"
                                style="width: 35px; height: 35px; font-size: 16px;">
                                {{ getInitials($clinic['name']) }}
                            </div>

                            <span class="fw-semibold text-dark">
                                {{ $clinic['name'] }}
                                <small class="d-block text-muted fw-normal fs-13">
                                    @if ($clinic['is_primary'])
                                        Primary Clinic
                                    @else
                                        {{ $clinic['location'] ?? 'Clinic' }}
                                    @endif
                                </small>
                            </span>
                        </span>
                        <input class="form-check-input m-0 me-2" type="radio" name="clinic_selection"
                            {{ $selectedClinic == $clinic['id'] ? 'checked' : '' }}>
                    </label>
                @endforeach
            </div>
        </div>
    @else
        <div class="sidebar-top shadow-sm p-2 rounded-1 mb-3">
            <div class="d-flex align-items-center text-warning">
                <span class="avatar rounded-circle flex-shrink-0 p-2">
                    <i class="fas fa-exclamation-circle"></i>
                </span>
                <div class="ms-2">
                    <h6 class="fs-14 fw-semibold mb-0 text-warning">No clinics assigned</h6>
                    <p class="fs-13 mb-0 text-muted">Please contact administrator</p>
                </div>
            </div>
        </div>
    @endif
</div>
