<div>
    <form wire:submit.prevent="next" class="needs-validation" novalidate>
        <div class="row g-3">
            <!-- Staff Limits -->
            <div class="col-md-6">
                <label class="form-label">Max Doctors*</label>
                <input type="number" wire:model="included_doctors"
                    class="form-control @error('included_doctors') is-invalid @enderror" readonly required>
                @error('included_doctors')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-6">
                <label class="form-label">Additional Doctor Price*</label>
                <div class="input-group">
                    <span class="input-group-text">{{ $currency }}</span>
                    <input type="number" wire:model.blur="additional_doctor_price"
                        class="form-control @error('additional_doctor_price') is-invalid @enderror" min="0"
                        step="0.01" required>
                </div>
                @error('additional_doctor_price')
                    <div class="invalid-feedback d-block">{{ $message }}</div>
                @enderror
            </div>

            <!-- Staff Limits -->
            <div class="col-md-6">
                <label class="form-label">Max Staff*</label>
                <input type="number" wire:model="included_staff"
                    class="form-control @error('included_staff') is-invalid @enderror" readonly required>
                @error('included_staff')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-6">
                <label class="form-label">Additional Staff Price*</label>
                <div class="input-group">
                    <span class="input-group-text">{{ $currency }}</span>
                    <input type="number" wire:model.blur="additional_staff_price"
                        class="form-control @error('additional_staff_price') is-invalid @enderror" min="0"
                        step="0.01" required>
                </div>
                @error('additional_staff_price')
                    <div class="invalid-feedback d-block">{{ $message }}</div>
                @enderror
            </div>



            <!-- Storage and Device Limits -->
            <div class="col-md-6">
                <label class="form-label">Storage Limit (GB)*</label>
                <input type="number" wire:model.blur="storage_limit_gb"
                    class="form-control @error('storage_limit_gb') is-invalid @enderror" min="0" required>
                @error('storage_limit_gb')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>


            <!-- Communication Limits -->
            <div class="col-md-6">
                <label class="form-label">Teleconsultation Minutes*</label>
                <input type="number" wire:model.blur="teleconsultation_minutes"
                    class="form-control @error('teleconsultation_minutes') is-invalid @enderror" min="0"
                    required>
                @error('teleconsultation_minutes')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-6">
                <label class="form-label">SMS Limit*</label>
                <input type="number" wire:model.blur="sms_limit"
                    class="form-control @error('sms_limit') is-invalid @enderror" min="0" required>
                @error('sms_limit')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            {{-- <div class="col-md-6">
                <label class="form-label">WhatsApp Limit*</label>
                <input type="number" wire:model="whatsapp_limit" class="form-control" min="0">
                @error('whatsapp_limit') <span class="text-danger">{{ $message }}</span> @enderror
            </div> --}}
        </div>

        <div class="mt-4 d-flex justify-content-between">
            <button type="button" wire:click="previous" class="btn btn-secondary">Previous</button>
            <button type="submit" class="btn btn-primary">Next: Features</button>
        </div>
    </form>
</div>