<div>
    <form wire:submit.prevent="next" class="needs-validation" novalidate>
        <div class="row g-3">
            <!-- Plan Code and Name -->
            <div class="col-md-6">
                <label class="form-label">Plan Code*</label>
                <input type="text" wire:model.blur="plan_code"
                    class="form-control @error('plan_code') is-invalid @enderror" placeholder="e.g., BASIC" required>
                @error('plan_code')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-6">
                <label class="form-label">Plan Name*</label>
                <input type="text" wire:model.blur="plan_name"
                    class="form-control @error('plan_name') is-invalid @enderror" placeholder="e.g., Basic Plan"
                    required>
                @error('plan_name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <!-- Description -->
            <div class="col-12">
                <label class="form-label">Description</label>
                <textarea wire:model.blur="description" class="form-control" rows="3" placeholder="Plan description..."></textarea>
            </div>
            <div class="col-md-6">
                <label class="form-label">Yearly Base Price*</label>
                <div class="input-group">
                    <span class="input-group-text">{{ $currency }}</span>
                    <input type="number" wire:model.blur="base_price"
                        class="form-control @error('base_price') is-invalid @enderror" min="0" step="0.01"
                        required>
                </div>
                @error('base_price')
                    <div class="invalid-feedback d-block">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-6">
                <label class="form-label">Yearly Discounted Price</label>
                <div class="input-group">
                    <span class="input-group-text">{{ $currency }}</span>
                    <input type="number" wire:model.blur="discounted_price"
                        class="form-control @error('discounted_price') is-invalid @enderror" min="0"
                        step="0.01">
                </div>
                @error('discounted_price')
                    <div class="invalid-feedback d-block">{{ $message }}</div>
                @enderror
            </div>
            <!-- Plan Type and Duration -->
            <div class="col-md-4">
                <label class="form-label">Plan Type*</label>
                <select wire:model.live="plan_type" class="form-select @error('plan_type') is-invalid @enderror"
                    required>
                    <option value="monthly">Monthly</option>
                    <option value="annual">Annual</option>
                    <option value="custom">Custom</option>
                </select>
                @error('plan_type')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-4">
                <label class="form-label">Duration @if ($plan_type === 'monthly')
                        (months)
                    @elseif($plan_type === 'annual')
                        (years)
                    @elseif($plan_type === 'custom')
                        (months)
                    @endif*</label>
                <input type="number" wire:model.blur="duration"
                    class="form-control @error('duration') is-invalid @enderror" min="1" required>
                @error('duration')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-md-4">
                <label class="form-label">Currency*</label>
                <select wire:model.live="currency" class="form-select @error('currency') is-invalid @enderror"
                    required>
                    <option value="INR">INR</option>
                    <option value="USD">USD</option>
                    <option value="EUR">EUR</option>
                    <option value="GBP">GBP</option>
                </select>
                @error('currency')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <div class="col-md-4">
                <label class="form-label">Max Doctors*</label>
                <input type="number" wire:model.blur="max_doctors"
                    class="form-control @error('max_doctors') is-invalid @enderror" min="1" required>
                @error('max_doctors')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <div class="col-md-4">
                <label class="form-label">Max Staff*</label>
                <input type="number" wire:model.blur="max_staff"
                    class="form-control @error('max_staff') is-invalid @enderror" min="1" required>
                @error('max_staff')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <div class="col-md-4">
                <label class="form-label">Device Limit*</label>
                <input type="number" wire:model.blur="device_limit"
                    class="form-control @error('device_limit') is-invalid @enderror" min="1" required>
                @error('device_limit')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <!-- Checkboxes -->
            <div class="col-md-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" wire:model.live="addon_eligible" id="addonEligible">
                    <label class="form-check-label" for="addonEligible">Addon Eligible</label>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" wire:model.live="auto_renewal" id="autoRenewal">
                    <label class="form-check-label" for="autoRenewal">Auto Renewal</label>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" wire:model.live="is_combo" id="isCombo">
                    <label class="form-check-label" for="isCombo">Combo Plan</label>
                </div>
            </div>
            @if ($is_combo)
                <div class="col-md-6">
                    <label class="form-label">Combo Subscription Plan (Optional)</label>
                    <div class="input-group">
                        <select wire:model.live="selected_plan_id" class="form-select @error('selected_plan_id') is-invalid @enderror">
                            <option value="">-- No Plan Selected --</option>
                            @foreach ($availablePlans as $plan)
                                <option value="{{ $plan->id }}">
                                    {{ $plan->plan_name }}
                                    ({{ $plan->base_price }}/{{ $plan->plan_type }})
                                </option>
                            @endforeach
                        </select>
                        @if ($selected_plan_id)
                            <button wire:click="$set('selected_plan_id', null)" class="btn btn-outline-danger"
                                type="button">
                                <i class="fa fa-times"></i>
                            </button>
                        @endif
                    </div>
                    @error('selected_plan_id')
                        <div class="invalid-feedback d-block">{{ $message }}</div>
                    @enderror
                    @if ($selected_plan_id && $selectedPlanDetails)
                        <div class="mt-2 small text-muted">
                            Selected: {{ $selectedPlanDetails->plan_name }}
                            ({{ $selectedPlanDetails->plan_type }})
                        </div>
                    @endif
                </div>
                <div class="col-md-6">
                    <label class="form-label">Combo Add On (Optional)</label>
                    <div class="dropdown">
                        <!-- Dynamic dropdown button title -->
                        <button class="form-select text-start dropdown-toggle" type="button" id="addOnDropdown"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            @if (count($selected_add_on_id) > 0)
                                {{ count($selected_add_on_id) }}
                                {{ count($selected_add_on_id) == 1 ? 'Add On' : 'Add Ons' }} Selected
                            @else
                                -- Select Add Ons --
                            @endif
                        </button>

                        <!-- Checkbox options -->
                        <ul class="dropdown-menu w-100" aria-labelledby="addOnDropdown">
                            @foreach ($availableAddOns as $addOn)
                                <li>
                                    <div class="dropdown-item">
                                        <input type="checkbox" wire:model.live="selected_add_on_id"
                                            value="{{ $addOn->id }}" id="addon-{{ $addOn->id }}"
                                            wire:change="updateSelectedCount">
                                        <label for="addon-{{ $addOn->id }}" class="ms-2">
                                            {{ $addOn->name }}
                                            ({{ $addOn->price_per_unit }}/{{ $addOn->resource_type }})
                                        </label>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                    <!-- Selected items details -->
                    @if (count($selected_add_on_id) > 0)
                        <div class="mt-2 small text-muted">
                            <strong>Selected:</strong>
                            @foreach ($availableAddOns->whereIn('id', $selected_add_on_id) as $selected)
                                <span class="d-block">
                                    {{ $selected->name }} ({{ $selected->resource_type }})
                                </span>
                            @endforeach
                        </div>
                    @endif
                </div>
            @endif

            <div class="mt-4 d-flex justify-content-between">
                <button type="button" class="btn btn-secondary" disabled>Previous</button>
                <button type="submit" class="btn btn-primary">Next: Plan Limits</button>
            </div>
    </form>
</div>
