<!-- row start -->
<div class="row justify-content-center">
    <div class="col-lg-12">

        <!-- page header start -->
        <div class="mb-4">
            <h6 class="fw-bold mb-0 d-flex align-items-center">
                <a href="{{ route('admin.privacy') }}" class="text-dark">
                    <!-- <i class="ti ti-chevron-left me-1"></i>--> {{ 'Privacy Policy' }}
                </a>
            </h6>
        </div>
        <!-- page header end -->

        <form action="{{ route('admin.privacy.store') }}" method="POST">
            @csrf
            <!-- card start -->
            <div class="card">
                <div class="card-body pb-0">
                    <div id="doctor-form" class="form">

                        <div class="row">
                            <!-- privacy -->
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="bio" class="form-label mb-1 fw-medium">Add Information on Privacy Policy</label>
                                    <textarea class="form-control" id="privacy" name="content" rows="10" placeholder="Brief description about the Privacy Policy rules"></textarea>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- card end -->

            <div class="d-flex align-items-center justify-content-end">
                <!-- <button type="button" class="btn btn-light me-2">
                    <i class="ti ti-refresh"></i> Reset Form
                </button> -->
                <button type="submit" class="btn btn-primary">
                    <span>
                        <i class="ti ti-plus"></i> Add Privacy Policy
                    </span>
                </button>
            </div>
        </form>

        <!-- Header Text -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
            <div class="flex-grow-1">
                <h6 class="fw-bold mb-0">
                    {{ 'Privacy Policy List' }} 
                </h6>
            </div>
        </div>

        <!-- Table Start --> 
        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead>
                    <tr>
                        <th>Sr. No.</th>
                        <th>Privacy Policy Content</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($policies as $index => $policy)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{!! nl2br(e($policy->content)) !!}</td>
                            <td>
                                <a href="{{ route('admin.privacy.toggle-status', $policy->id) }}"
                                class="badge {{ $policy->status == 'active' ? 'badge-soft-success' : 'badge-soft-danger' }}">
                                {{ ucfirst($policy->status) }}
                                </a>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <a href="#" data-bs-toggle="dropdown"><i class="ti ti-dots-vertical"></i></a>
                                    <ul class="dropdown-menu dropdown-menu-end">
                                        <li><a class="dropdown-item" href="{{ route('admin.privacy.edit', $policy->id) }}"><i class="ti ti-edit me-2"></i> Edit</a></li>
                                        <li><a class="dropdown-item text-danger" href="{{ route('admin.privacy.delete', $policy->id) }}"><i class="ti ti-trash me-2"></i> Delete</a></li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center">No privacy policies found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="d-flex justify-content-center mt-3">
                {{ $policies->links('pagination::bootstrap-5') }}
            </div>
        </div>

    </div>
</div>
