<div class="content">
    <!-- Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">
                Addon Management
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Addons: {{ $addons->total() ?? 0 }}
                </span>
            </h4>
        </div>
        <div class="text-end d-flex">
            <a href="{{ route('admin.plans.addons.create') }}" class="btn btn-primary ms-2 fs-13 btn-md">
                <i class="ti ti-plus me-1"></i>Add New Addon
            </a>
        </div>
    </div>

    <!-- Search and Filters -->
    <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3">
        <div class="search-set mb-3">
            <div class="d-flex align-items-center flex-wrap gap-2">
                <div class="table-search d-flex align-items-center mb-0">
                    <div class="search-input">
                        <a href="javascript:void(0);" class="btn-searchset"></a>
                        <div class="dataTables_filter">
                            <label>
                                <input type="search" class="form-control form-control-sm" placeholder="Search addons..."
                                    wire:model.live.debounce.300ms="search">
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" class="link-danger text-decoration-underline"
                                wire:click="resetFilters">Clear All</a>
                        </div>
                    </div>
                    <div>
                        <div class="filter-body pb-0">
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Status</label>
                                    <a href="javascript:void(0);" class="link-primary mb-1"
                                        wire:click="$set('tempStatusFilter', 'all')"
                                        wire:keydown.enter.prevent>Reset</a>
                                </div>
                                <select class="form-select" wire:model="tempStatusFilter" wire:keydown.enter.prevent>
                                    <option value="all">All Status</option>
                                    <option value="active">Active Only</option>
                                    <option value="inactive">Inactive Only</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Resource Type</label>
                                    <a href="javascript:void(0);" class="link-primary mb-1"
                                        wire:click="$set('tempResourceTypeFilter', 'all')"
                                        wire:keydown.enter.prevent>Reset</a>
                                </div>
                                <select class="form-select" wire:model="tempResourceTypeFilter"
                                    wire:keydown.enter.prevent>
                                    <option value="all">All Resource Types</option>
                                    @foreach ($resourceTypes as $resourceType)
                                        <option value="{{ $resourceType }}">
                                            {{ ucwords(str_replace('_', ' ', $resourceType)) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                            <a href="javascript:void(0);" class="btn btn-light btn-md me-2" id="close-filter">Close</a>
                            <button type="button" class="btn btn-primary btn-md" wire:click="applyFilters">Apply
                                Filters</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sort Dropdown -->
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1">Sort By: </span>
                    {{ ucfirst(str_replace('_', ' ', $sortField)) }} ({{ $sortDirection }})
                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('addon_code')">Code</a></li>
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('name')">Name</a></li>
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('price_per_unit')">Price/Unit</a></li>
                    <li><a class="dropdown-item rounded-1" wire:click="sortBy('is_active')">Status</a></li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Addons Table -->
    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th wire:click="sortBy('addon_code')" style="cursor: pointer;">
                        Code
                        {!! $sortField === 'addon_code' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th wire:click="sortBy('name')" style="cursor: pointer;">
                        Name {!! $sortField === 'name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th>Resource Type</th>
                    <th>Unit</th>
                    <th wire:click="sortBy('price_per_unit')" style="cursor: pointer;">
                        Price/Unit
                        {!! $sortField === 'price_per_unit' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th wire:click="sortBy('is_active')" style="cursor: pointer;">
                        Status
                        {!! $sortField === 'is_active' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                    </th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($addons as $addon)
                    <tr>
                        <td>{{ $addon->addon_code }}</td>
                        <td>{{ $addon->name }}</td>
                        <td>
                            <span class="badge badge-soft-primary border border-primary">
                                {{ ucwords(str_replace('_', ' ', $addon->resource_type)) }}
                            </span>
                        </td>
                        <td>{{ $addon->unit }}</td>
                        <td>${{ number_format($addon->price_per_unit, 2) }}</td>
                        <td>
                            @if ($addon->is_active)
                                <span class="badge badge-soft-success border border-success">Active</span>
                            @else
                                <span class="badge badge-soft-danger border border-danger">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="action-item">
                                    <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                        <i class="ti ti-dots-vertical"></i>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end bg-white">
                                        <li>
                                            <a href="{{ route('admin.plans.addons.edit', $addon) }}"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i> Edit
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center"
                                                wire:click="toggleStatus({{ $addon->id }})">
                                                <i class="ti ti-power me-2"></i>
                                                {{ $addon->is_active ? 'Deactivate' : 'Activate' }}
                                            </a>
                                        </li>
                                        <li>
                                            <a href="javascript:void(0);"
                                                class="dropdown-item d-flex align-items-center text-danger"
                                                wire:click="$set('deleteId' , {{$addon->id}})"
                                                data-bs-toggle="modal" data-bs-target="#delete_addon">
                                                <i class="ti ti-trash me-2"></i> Delete
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center">No addons found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <x-table.pagination :paginator="$addons" :position="'both'" />


    <!-- Start Delete Modal -->
    <div class="modal fade" id="delete_addon" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-body text-center position-relative">
                   <img src="{{ asset('assets/img/bg/delete-modal-bg-01.png') }}" alt=""
                        class="img-fluid position-absolute top-0 start-0">
                    <img src="{{ asset('assets/img/bg/delete-modal-bg-02.png') }}" alt=""
                        class="img-fluid position-absolute bottom-0 end-0">

                    <div class="mb-3">
                        <span class="avatar avatar-lg bg-danger text-white"><i class="ti ti-trash fs-24"></i></span>
                    </div>
                    <h5 class="fw-bold mb-1">Delete Confirmation</h5>
                    @if ($deleteId)
                        <p class="mb-3">Are you sure you want to delete ?</p>
                    @endif
                    <div class="d-flex justify-content-center">
                        <button class="btn btn-light position-relative z-1 me-3"
                            data-bs-dismiss="modal">Cancel</button>
                        <button class="btn btn-danger position-relative z-1" wire:click="delete({{ $deleteId }})"
                            data-bs-dismiss="modal">Yes, Delete</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Delete Modal -->
</div>