<div>
    @if (!$isLoaded)
        <div class="text-center py-4">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="mt-2">Loading staff...</p>
        </div>
    @else
        <!-- Start Page Header -->
        <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
            <div class="flex-grow-1">
                <h4 class="fw-bold mb-0">
                    Staff Management
                    <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                        Total Staff: {{ $staffAssociations->total() ?? 0 }}
                    </span>
                </h4>
            </div>

            <div class="text-end d-flex">
                <a href="#" class="btn btn-primary ms-2 fs-13 btn-md disabled" tabindex="-1" aria-disabled="true">
                    <i class="ti ti-plus me-1"></i>Add New Staff
                </a>
            </div>
        </div>
        <!-- End Page Header -->

        <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3">
            <div class="search-set mb-3">
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <div class="table-search d-flex align-items-center mb-0">
                        <div class="search-input">
                            <a href="javascript:void(0);" class="btn-searchset"></a>
                            <div id="DataTables_Table_0_filter" class="dataTables_filter">
                                <label>
                                    <input type="search" class="form-control form-control-sm" placeholder="Search staff..."
                                        wire:model.live.debounce.300ms="searchTerm" aria-controls="DataTables_Table_0">
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex table-dropdown mb-3 pb-1 right-content align-items-center flex-wrap row-gap-3">
                <div class="dropdown me-2">
                    <a href="javascript:void(0);"
                        class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                        data-bs-toggle="dropdown" data-bs-auto-close="outside">
                        <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                    </a>
                    <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                        <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                            <h4 class="mb-0">Filter</h4>
                            <div class="d-flex align-items-center">
                                <a href="javascript:void(0);" class="link-danger text-decoration-underline"
                                    wire:click="clearAllFilters">Clear All</a>
                            </div>
                        </div>
                        <div class="filter-body pb-0">
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Status</label>
                                    <a href="javascript:void(0);" class="link-primary mb-1"
                                        wire:click="resetStatusFilter">Reset</a>
                                </div>
                                <select class="form-select" wire:model="statusFilter">
                                    <option value="all">All Status</option>
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label">Approval Status</label>
                                    <a href="javascript:void(0);" class="link-primary mb-1"
                                        wire:click="resetApprovelStatusFilter">Reset</a>
                                </div>
                                <select class="form-select" wire:model="approvalStatusFilter">
                                    <option value="all">All Approval Status</option>
                                    <option value="approved">Approved</option>
                                    <option value="pending">Pending</option>
                                    <option value="rejected">Rejected</option>
                                </select>
                            </div>
                        </div>
                        <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                            <a href="javascript:void(0);" class="btn btn-light btn-md me-2"
                                data-bs-toggle="dropdown">Close</a>
                            <button type="button" class="btn btn-primary btn-md" wire:click="applyFilters"
                                data-bs-toggle="dropdown">Filter</button>
                        </div>
                    </div>
                </div>
                <div class="dropdown">
                    <a href="javascript:void(0);"
                        class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                        data-bs-toggle="dropdown">
                        <span class="me-1"> Sort By : </span> Recent
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1"
                                wire:click="sortBy('name')">Name</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1"
                                wire:click="sortBy('email')">Email</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1"
                                wire:click="sortBy('status')">Status</a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="dropdown-item rounded-1"
                                wire:click="sortBy('approval_status')">Approval Status</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table datatable table-nowrap">
                <thead class="">
                    <tr>
                        <th wire:click="sortBy('name')" style="cursor: pointer;">
                            Name {!! $sortField === 'name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                        </th>
                        <th wire:click="sortBy('email')" style="cursor: pointer;">
                            Email {!! $sortField === 'email' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                        </th>
                        <th>Supervisor</th>
                        <th wire:click="sortBy('status')" style="cursor: pointer;">
                            Status {!! $sortField === 'status' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                        </th>
                        <th wire:click="sortBy('approval_status')" style="cursor: pointer;">
                            Approval Status
                            {!! $sortField === 'approval_status' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : '' !!}
                        </th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($staffAssociations as $association)
                        @php
                            $user = $association->staff;
                            $doctor = $association->doctor;
                            $profileImage = $user->staff?->profile_image;
                        @endphp
                        <tr>
                            <td>
                                <x-user.avatar-name :name="$user->name" :profileImage="$profileImage" />
                            </td>
                            <td>
                                <span class="fs-13">{{ $user->email }}</span>
                            </td>
                            <td>
                                <span class="fs-13">{{ $doctor ? $doctor->name : 'N/A' }}</span>
                            </td>
                            <td>
                                <span
                                    wire:click="toggleStaffStatus({{ $user->id }}, {{ $clinic->id }}, {{ $doctor ? $doctor->id : 'null' }})"
                                    style="cursor: pointer;"
                                    class="badge badge-soft-{{ $association->status === 'active' ? 'success' : 'danger' }} border border-{{ $association->status === 'active' ? 'success' : 'danger' }}">
                                    {{ ucfirst($association->status ?? 'Inactive') }}
                                </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <span
                                        class="badge badge-soft-{{ $association->approval_status === 'approved' ? 'success' : ($association->approval_status === 'pending' ? 'warning' : 'danger') }} border border-{{ $association->approval_status === 'approved' ? 'success' : ($association->approval_status === 'pending' ? 'warning' : 'danger') }}">
                                        {{ ucfirst($association->approval_status ?? 'Pending') }}
                                    </span>
                                    <div class="action-item ms-2">
                                        <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                            <i class="ti ti-settings"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end bg-white">
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center" href="javascript:;"
                                                    wire:click="toggleStaffApprovalStatus({{ $user->id }}, {{ $clinic->id }}, {{ $doctor ? $doctor->id : 'null' }}, 'approved')">
                                                    <i class="ti ti-check me-2 text-success"></i>
                                                    Approve
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center" href="javascript:;"
                                                    wire:click="toggleStaffApprovalStatus({{ $user->id }}, {{ $clinic->id }}, {{ $doctor ? $doctor->id : 'null' }}, 'rejected')">
                                                    <i class="ti ti-x me-2 text-danger"></i>
                                                    Reject
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center" href="javascript:;"
                                                    wire:click="toggleStaffApprovalStatus({{ $user->id }}, {{ $clinic->id }}, {{ $doctor ? $doctor->id : 'null' }}, 'pending')">
                                                    <i class="ti ti-clock me-2 text-warning"></i>
                                                    Pending
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="action-item">
                                        <a href="javascript:void(0);" data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end bg-white">
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center"
                                                    href="{{route('admin.staff-management.edit', $user->id)}}">
                                                    <i class="ti ti-edit me-2"></i> Edit
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item d-flex align-items-center"
                                                    href="{{route('admin.staff-management.view', $user->id)}}">
                                                    <i class="ti ti-eye me-2"></i> View
                                                </a>
                                            </li>
                                            <li>

                                                <a href="javascript:void(0);" @click="$dispatch('show-shared-delete-modal', {
                                                                                title: 'Remove Staff Member',
                                                                                message: 'Are you sure you want to remove this staff member from the clinic?',
                                                                                staffId: {{ $user->id}},
                                                                                clinicId: {{ $clinic->id }},
                                                                                action: 'confirm-delete-staff'
                                                                            })" class="dropdown-item text-danger">
                                                    <i class="ti ti-trash me-2"></i> Remove Staff
                                                </a>

                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center">No staff found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <x-table.pagination :paginator="$staffAssociations" :position="'both'" />
    @endif
</div>