<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>@yield('title', 'Admin Dashboard - PRED Care')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Dreams Technologies">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('assets/img/favicon.png') }}">

    <!-- Apple Icon -->
    <link rel="apple-touch-icon" href="{{ asset('assets/img/apple-icon.png') }}">

    <!-- Theme Config Js -->
    <script src="{{ asset('assets/js/theme-script.js') }}"></script>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">

    <!-- Datetimepicker CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap-datetimepicker.min.css') }}">

    <!-- Daterangepikcer CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/daterangepicker/daterangepicker.css') }}">

    <!-- Fontawesome CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/fontawesome/css/fontawesome.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/plugins/fontawesome/css/all.min.css') }}">

    <!-- Tabler Icon CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/tabler-icons/tabler-icons.min.css') }}">

    <!-- Wizard CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/twitter-bootstrap-wizard/form-wizard.css') }}">

    <!-- Simplebar CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/simplebar/simplebar.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/plugins/select2/css/select2.min.css') }}">

    <!-- Include intlTelInput CSS -->
    <link rel="stylesheet" href="{{ asset('assets/plugins/intltelinput/css/intlTelInput.css') }}" />

    <!-- Main CSS -->
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}" id="app-style">
    <style>
        .modal {
            display: none;
        }

        .modal.show {
            display: block;
        }
    </style>
    @livewireStyles
    @stack('styles')
</head>

<body>
    <div class="main-wrapper">
        @include('layouts.partials.header')

        @if (Auth::guard('superadmin')->check())
            @include('layouts.partials.admin-sidebar')
        @elseif (Auth::guard('doctor')->check())
            @include('layouts.partials.doctor-sidebar')
        @elseif (Auth::guard('patient')->check())
            @include('layouts.partials.patient-sidebar')
        @endif

        <div class="page-wrapper">
            @yield('content')
            @include('layouts.partials.footer')
        </div>
    </div>

    @include('layouts.partials.delete-modals')

    <!-- jQuery -->
    <script src="{{ asset('assets/js/jquery-3.7.1.min.js') }}"></script>

    <!-- Bootstrap Core JS -->
    <script src="{{ asset('assets/js/bootstrap.bundle.min.js') }}"></script>


    <script src="{{ asset('assets/plugins/select2/js/select2.min.js') }}"></script>

    <!-- Simplebar JS -->
    <script src="{{ asset('assets/plugins/simplebar/simplebar.min.js') }}"></script>

    <!-- Chart JS -->
    <script src="{{ asset('assets/plugins/apexchart/apexcharts.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/apexchart/chart-data.js') }}"></script>

    <!-- Daterangepikcer JS -->
    <script src="{{ asset('assets/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/daterangepicker/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap-datetimepicker.min.js') }}"></script>

    <!-- Include intlTelInput JS -->
    <script src="{{ asset('assets/plugins/intltelinput/js/intlTelInput.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/intltelinput/js/utils.js') }}"></script>

    <script src="{{ asset('assets/plugins/theia-sticky-sidebar/theia-sticky-sidebar.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('assets/js/script.js') }}"></script>
    @livewireScripts

    <!-- Wizrd JS -->
    <script src="{{ asset('assets/plugins/vanilla-wizard/js/wizard.min.js') }}"></script>

    <!-- Wizard JS -->
    <script src="{{ asset('assets/js/deletemodel.js') }}"></script>
    <script>
        window.addEventListener('clinic-changed-refresh', function () {
            window.location.reload();
        });
    </script>
    <script>
        window.addEventListener('doctor-clinic-changed-refresh', function () {
            window.location.reload();
        });
    </script>

    @stack('scripts')
</body>

</html>