@extends('layouts.app')

@section('title', 'Add Availability')

@section('content')
<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>

    <div class="content">
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <!-- Page Header -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center">
                        <a href="{{ route('availability.list') }}" class="text-dark">
                            <i class="ti ti-chevron-left me-1"></i>Doctor Availability
                        </a>
                    </h6>
                </div>

                <!-- Form Start -->
                <form action="{{ route('availability.store') }}" method="POST">
                    @csrf
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Add New Availability</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Select Doctor <span class="text-danger">*</span></label>
                                    <select class="form-select" name="doctor_id" required>
                                        <option value="">Select Any one</option>
                                        @foreach($doctors as $entry)
                                            <option value="{{ $entry->doctor->id }}">{{ $entry->doctor->name }}</option>
                                        @endforeach
                                    </select>
                                    <!-- Clinic ID (Hidden or visible) -->
                                    <input type="hidden" name="clinic_id" value="{{ $entry->clinic->id }}">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Slot Duration <span class="text-danger">*</span></label>
                                    <select class="form-select" name="slot_duration" required>
                                        <option value="">Select</option>
                                        <option value="15">15 minutes</option>
                                        <option value="30">30 minutes</option>
                                        <option value="60">60 minutes</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">From</label>
                                        <input type="time" class="form-control" name="from_time" required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">To</label>
                                        <input type="time" class="form-control" name="to_time" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="row">
                                        <label class="form-label">Select Days</label>
                                        @foreach(['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'] as $day)
                                            <div class="col-lg-3 mt-2">
                                                <ul class="list-group">
                                                    <li class="list-group-item">
                                                        <div class="form-check">
                                                            <input class="form-check-input me-1" type="checkbox" name="days[]" value="{{ $day }}" id="day_{{ $day }}">
                                                            <label class="form-check-label" for="day_{{ $day }}">{{ $day }}</label>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label class="form-label">Doctor Fee</label>
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">In-Person Fee</label>
                                                    <input type="number" class="form-control" name="in_person_fee" placeholder="Enter the fee" min="0" required>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="mb-3">
                                                    <label class="form-label">Video Fee</label>
                                                    <input type="number" class="form-control" name="video_fee" placeholder="Enter the fee" min="0" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-between">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-save me-2"></i> Create Slot</button>
                            <a href="{{ route('availability.list') }}" class="btn btn-secondary"><i class="fas fa-times me-2"></i> Cancel</a>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>

@endsection