@extends('layouts.app')

@section('title', 'Specialization')

@section('content')
<style>
.fl-wrapper[data-position^=top-] {
    top: 4em;
}
</style>
    <div class="content">
        
        <!-- row start -->
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <!-- page header start -->
                <div class="mb-4">
                    <h6 class="fw-bold mb-0 d-flex align-items-center">
                        <a href="{{ route('admin.specialization-index') }}" class="text-dark">
                            <!-- <i class="ti ti-chevron-left me-1"></i> -->
                            {{ 'Notification' }}
                        </a>
                    </h6>
                </div>
                <!-- page header end -->

                <form action="{{ route('admin.specialization.store') }}" method="POST">
                    @csrf

                    <!-- card start -->
                    <div class="card">
                        <div class="card-body pb-0">
                            <div id="doctor-form" class="form">

                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label for="specialization" class="form-label mb-1 fw-medium">
                                                Specialization Name<span class="text-danger ms-1">*</span>
                                            </label>
                                            <input type="text" class="form-control @error('name') is-invalid @enderror" id="specialization" name="specialization" placeholder="e.g., Cardiology, Pediatrics" required>
                                            @error('name')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- card end -->

                    <div class="d-flex align-items-center justify-content-end">
                        <!-- <button type="button" class="btn btn-light me-2">
                            <i class="ti ti-refresh"></i> Reset Form
                        </button> -->
                        <button type="submit" class="btn btn-primary">
                            <span>
                                <i class="ti ti-plus"></i> Add Specialization
                            </span>
                            <!-- <span wire:loading>
                                <i class="ti ti-loader fa-spin"></i> Processing...
                            </span> -->
                        </button>
                    </div>
                </form>


                <!-- Header Text -->
                <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 mb-3 pb-3 border-bottom">
                    <div class="flex-grow-1">
                        <h6 class="fw-bold mb-0">
                            Specialization List
                        </h6>
                    </div>
                </div>

                <!-- Notification Table -->
                <div class="table-responsive">
                    <table class="table datatable table-nowrap">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Specialization</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($specializations as $key => $row)
                                <tr>
                                    <td>{{ $specializations->firstItem() + $key }}</td>
                                    <td>{{ $row->specialization }}</td>
                                    <td>
                                        <a href="{{ route('admin.specialization.toggle', $row->id) }}"
                                        class="badge {{ $row->status ? 'badge-soft-success border border-success' : 'badge-soft-danger border border-danger' }}">
                                            {{ ucfirst($row->status ? 'Active' : 'Inactive') }}
                                        </a>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <a href="#" data-bs-toggle="dropdown"><i class="ti ti-dots-vertical"></i></a>
                                            <ul class="dropdown-menu dropdown-menu-end">
                                                <!-- <li>
                                                    <a class="dropdown-item edit-btn" href="#" data-id="{{ $row->id }}" data-name="{{ $row->specialization }}">
                                                        <i class="ti ti-edit me-2"></i>Edit
                                                    </a>
                                                </li> -->
                                                <li>
                                                    <a class="dropdown-item text-danger" href="{{ route('admin.specialization.delete', $row->id) }}" onclick="return confirm('Are you sure?')">
                                                        <i class="ti ti-trash me-2"></i>Delete
                                                    </a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item {{ $row->status ? 'text-danger' : 'text-success' }}" href="{{ route('admin.specialization.toggle', $row->id) }}">
                                                        <i class="ti {{ $row->status ? 'ti-ban' : 'ti-check' }} me-2"></i> {{ $row->status ? 'Inactivate' : 'Activate' }}
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>

                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">No specializations found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>

                    {{ $specializations->links() }}
                </div>

                {{-- Edit Modal --}}
                <div class="modal fade" id="editModal" tabindex="-1">
                    <div class="modal-dialog">
                        <form method="POST" id="editForm">
                            @csrf
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Edit Specialization</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <label for="edit_specialization">Specialization</label>
                                    <input type="text" name="specialization" id="edit_specialization" class="form-control" required>
                                </div>
                                <div class="modal-footer">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection

@section('scripts')
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const editButtons = document.querySelectorAll('.edit-btn');
        const modal = new bootstrap.Modal(document.getElementById('editModal'));

        editButtons.forEach(btn => {
            btn.addEventListener('click', function (e) {
                e.preventDefault(); // Prevent anchor behavior

                const id = this.dataset.id;
                const name = this.dataset.name;

                document.getElementById('edit_specialization').value = name;
                document.getElementById('editForm').action = `/admin/setting/specialization/update/${id}`;

                modal.show();
            });
        });
    });
</script>
@endsection




