@extends('layouts.app')

@section('title', 'FAQ')

@section('content')
<div class="content">
    <div class="row justify-content-center">
        <div class="col-lg-12">

            <!-- page header start -->
            <div class="mb-4">
                <h6 class="fw-bold mb-0 d-flex align-items-center">
                    <a href="{{ route('admin.patient-faq') }}" class="text-dark">
                        <!-- <i class="ti ti-chevron-left me-1"></i> -->
                        {{ 'Edit Frequently Asked Questions (FAQ)' }}
                    </a>
                </h6>
            </div>
            <!-- page header end -->

            <form action="{{ route('admin.faq.update', $faq->id) }}" method="POST">
                @csrf

                <!-- card start -->
                <div class="card">
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="question" class="form-label">Question</label>
                            <input type="text" name="question" id="question" class="form-control @error('question') is-invalid @enderror" value="{{ old('question', $faq->question) }}" required>
                            @error('question') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="answer" class="form-label">Answer</label>
                            <textarea name="answer" id="answer" rows="4" class="form-control @error('answer') is-invalid @enderror" required>{{ old('answer', $faq->answer) }}</textarea>
                            @error('answer') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select name="status" class="form-select" required>
                                <option value="active" {{ old('status', $faq->status) === 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ old('status', $faq->status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
                            </select>
                        </div>
                    </div>
                </div>
                <!-- card end -->

                <div class="text-end">
                    <a href="{{ route('admin.patient-faq') }}" class="btn btn-warning"><i class="fas fa-times me-1"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Update FAQ</button>
                </div>
            </form>
             
        </div>
    </div>
</div>
@endsection
