@extends('layouts.app')
@if (isset($editId))
    @section('title', 'Add Clinic Doctor')
@else
    @section('title', 'Edit Clinic Doctor')
@endif
@section('content')
    @livewire('admin.clinics.doctor.clinic-doctor-form', ['editId' => $editId ?? null, 'clinic' => $clinic ?? null])
@endsection

@push('scripts')
    <script>
        document.addEventListener('livewire:init', function() {
            initializeSelect2();

            Livewire.hook('morph.updated', () => {
                initializeSelect2();
            });


            function initializeSelect2() {
                $('.select2').select2('destroy');

                $('.select2').select2({
                    placeholder: 'Select clinics',
                    width: '100%'
                }).on('change', function(e) {
                    const selectedValues = $(this).val() || [];

                    const componentEl = $(this).closest('[wire\\:id]')[0];
                    if (componentEl) {
                        const component = Livewire.get(componentEl);
                        if (component) {
                            component.$set('selected_clinics', selectedValues);
                        }
                    }
                });
            }
        });
    </script>
@endpush
