// Constants
const API_BASE_URL = "https://api.videosdk.live";

//App URL
//console.log(window.APP_URL);

document.getElementById("network-stats").style.display = "none";
document.getElementById("network-error-offline").style.display = "none";
document.getElementById("network-error-online").style.display = "none";

// Declaring variables
let videoContainer = document.getElementById("videoContainer");
let micButton = document.getElementById("micButton");
let camButton = document.getElementById("camButton");
let copy_meeting_id = document.getElementById("meetingid");
let contentRaiseHand = document.getElementById("contentRaiseHand");
let videoScreenShare = document.getElementById("videoScreenShare");
let btnSend = document.getElementById("btnSend");
let participantsList = document.getElementById("participantsList");

let videoCamOn, videoCamOff;
let micOn, micOff;
let btnStartRecording, btnStopRecording;
let btnScreenShare;

function getRaiseHandButton() {
  if (window.innerWidth < 768) {
    videoCamOff = document.getElementById("mobile-main-pg-cam-off");
    videoCamOn = document.getElementById("mobile-main-pg-cam-on");
    micOn = document.getElementById("mobile-main-pg-unmute-mic");
    micOff = document.getElementById("mobile-main-pg-mute-mic");
    btnStartRecording = document.getElementById("mobileBtnStartRecording");
    btnStopRecording = document.getElementById("mobileBtnStopRecording");
    btnScreenShare = document.getElementById("mobileBtnScreenShare");
  } else {
    micOn = document.getElementById("main-pg-unmute-mic");
    micOff = document.getElementById("main-pg-mute-mic");
    videoCamOff = document.getElementById("main-pg-cam-off");
    videoCamOn = document.getElementById("main-pg-cam-on");
    btnStartRecording = document.getElementById("btnStartRecording");
    btnStopRecording = document.getElementById("btnStopRecording");
    btnScreenShare = document.getElementById("btnScreenShare");
  }
}

getRaiseHandButton();

//videoPlayback DIV
let videoPlayback = document.getElementById("videoPlayback");

// For PreCall
const cameraDeviceDropDown = document.getElementById('cameraDeviceDropDown');
const microphoneDeviceDropDown = document.getElementById('microphoneDeviceDropDown');
const playBackDeviceDropDown = document.getElementById('playBackDeviceDropDown');
const joinMeetingCode = document.getElementById("joinMeetingId");
const joiningName = document.getElementById("name");
const refreshButton = document.getElementById("refresh");
const networkErrorRefreshButton = document.querySelectorAll(".network-error-refresh");
const microphonePermission = document.getElementById("no-microphone-permission");
const cameraPermission = document.getElementById("no-camera-permission");

joinMeetingCode.addEventListener("input", handleInputChange);
joiningName.addEventListener("input", handleInputChange);

let joinMeetingCodeValue = "";
let joinNameValue = "";

let currentMic = null;
let currentCamera = null;
let currentPlayback = null;

let meeting = "";
// Local participants
let localParticipant;
let localParticipantAudio;
let createMeetingFlag = 0;
let joinMeetingFlag = 0;
let token = "";
let micEnable = false;
let webCamEnable = false;
let totalParticipants = 0;
let remoteParticipantId = "";
let participants = [];
// join page
let joinPageWebcam = document.getElementById("joinCam");
let meetingCode = "";
let screenShareOn = false;
let joinPageVideoStream = null;
let cameraPermissionAllowed = true;
let microphonePermissionAllowed = true;
let deviceChangeEventListener;

window.addEventListener("load", async function () {
  let checkAudioVideoPermission;

  try {
    checkAudioVideoPermission = await VideoSDK.checkPermissions(
      VideoSDK.Constants.permission.AUDIO_AND_VIDEO,
    );
    console.log(
      "check Audio and Video Permissions",
      checkAudioVideoPermission.get(VideoSDK.Constants.permission.AUDIO),
      checkAudioVideoPermission.get(VideoSDK.Constants.permission.VIDEO)
    );
  } catch (ex) {
    console.log("Error in checkPermissions ", ex);
  }

  if (checkAudioVideoPermission.get(window.VideoSDK.Constants.permission.VIDEO) === false || checkAudioVideoPermission.get(window.VideoSDK.Constants.permission.AUDIO) === false) {
    checkAudioVideoPermission = await window.VideoSDK.requestPermission(
      window.VideoSDK.Constants.permission.AUDIO_AND_VIDEO,
    );
  }

  if (checkAudioVideoPermission.get(window.VideoSDK.Constants.permission.AUDIO) === false) {
    this.document.getElementById("micButton").style.display = "none";
    this.document.getElementById("no-microphone-permission").style.display = "block";
  }

  if (checkAudioVideoPermission.get(window.VideoSDK.Constants.permission.VIDEO) === false) {
    this.document.getElementById("camButton").style.display = "none";
    this.document.getElementById("no-camera-permission").style.display = "block";
  }

  await updateDevices();
  await enableCam();
  await enableMic();

  deviceChangeEventListener = async (devices) => {
    await updateDevices();
    await enableCam();
  }
  window.VideoSDK.on("device-changed", deviceChangeEventListener);

  refreshButton.addEventListener('click', async () => {
    try {
      const refreshElement = document.getElementById("refresh");
      this.document.getElementById("download-speed-div").style.display = "none";
      this.document.getElementById("upload-speed-div").style.display = "none";
      this.document.getElementById("check-speed-div").style.display = "unset";
      this.document.getElementById("network-stats").style.marginLeft = "47%";
      refreshElement.firstElementChild.classList.remove("bi-arrow-cloclwise");
      refreshElement.firstElementChild.classList.add("bi-arrow-repeat");
      refreshElement.classList.add("spin")
      const result = await window.VideoSDK.getNetworkStats({ timeoutDuration: 120000 });
      this.document.getElementById("download-speed-div").style.display = "flex";
      this.document.getElementById("upload-speed-div").style.display = "flex";
      this.document.getElementById("check-speed-div").style.display = "none";
      this.document.getElementById("network-stats").style.marginLeft = "47%";
      refreshElement.firstElementChild.classList.add("bi-arrow-cloclwise");
      refreshElement.firstElementChild.classList.remove("bi-arrow-repeat");
      refreshElement.classList.remove("spin");
      document.getElementById("network-error-offline").style.display = "none";
      document.getElementById("network-error-online").style.display = "none";
      document.getElementById("download-speed").innerHTML = result["downloadSpeed"] + " MBPS";
      document.getElementById("upload-speed").innerHTML = result["uploadSpeed"] + " MBPS";
      document.getElementById("network-stats").style.display = "flex";
    } catch (error) {
      this.document.getElementById("network-stats").style.display = "none";
      if (error == "Not able to get NetworkStats due to no Network") {
        this.document.getElementById("network-error-offline").style.display = "flex"
      } else if (error == "Not able to get NetworkStats due to timeout") {
        this.document.getElementById("network-error-online").style.display = "flex"
      }
    }
  });

  networkErrorRefreshButton.forEach((refersh) => {
    refersh.addEventListener("click", async () => {
      try {
        const refreshElement = document.getElementById("refresh");
        refreshElement.firstElementChild.classList.remove("bi-arrow-cloclwise");
        refreshElement.firstElementChild.classList.add("bi-arrow-repeat");
        refreshElement.classList.add("spin");
        this.document.getElementById("download-speed-div").style.display = "none";
        this.document.getElementById("upload-speed-div").style.display = "none";
        this.document.getElementById("check-speed-div").style.display = "unset";
        this.document.getElementById("network-stats").style.marginLeft = "47%";
        const result = await window.VideoSDK.getNetworkStats({ timeoutDuration: 120000 });
        this.document.getElementById("download-speed-div").style.display = "flex";
        this.document.getElementById("upload-speed-div").style.display = "flex";
        this.document.getElementById("check-speed-div").style.display = "none";
        this.document.getElementById("network-stats").style.marginLeft = "47%s";
        refreshElement.firstElementChild.classList.remove("bi-arrow-repeat");
        refreshElement.classList.remove("spin");
        refreshElement.firstElementChild.classList.add("bi-arrow-cloclwise");
        document.getElementById("network-error-offline").style.display = "none";
        document.getElementById("network-error-online").style.display = "none";
        document.getElementById("download-speed").innerHTML = result["downloadSpeed"] + " MBPS";
        document.getElementById("upload-speed").innerHTML = result["uploadSpeed"] + " MBPS";
        document.getElementById("network-stats").style.display = "flex";
      } catch (error) {
        this.document.getElementById("network-stats").style.display = "none";
        if (error == "Not able to get NetworkStats due to no Network") {
          this.document.getElementById("network-error-offline").style.display = "flex"
        } else if (error == "Not able to get NetworkStats due to timeout") {
          this.document.getElementById("network-error-online").style.display = "flex"
        }
      }
    })
  })

  await window.VideoSDK.getNetworkStats({ timeoutDuration: 120000 })
    .then((result) => {
      const refreshElement = document.getElementById("refresh");
      this.document.getElementById("download-speed-div").style.display = "flex";
      this.document.getElementById("upload-speed-div").style.display = "flex";
      this.document.getElementById("check-speed-div").style.display = "none";
      this.document.getElementById("network-stats").style.marginLeft = "47%";
      refreshElement.classList.remove("spin");
      refreshElement.firstElementChild.classList.remove("bi-arrow-repeat");
      refreshElement.firstElementChild.classList.add("bi-arrow-clockwise");
      document.getElementById("network-error-offline").style.display = "none";
      document.getElementById("network-error-online").style.display = "none";
      document.getElementById("download-speed").innerHTML = result["downloadSpeed"] + " MBPS"
      document.getElementById("upload-speed").innerHTML = result["uploadSpeed"] + " MBPS"
      document.getElementById("network-stats").style.display = "flex";
    })
    .catch((error) => {
      if (error == "Not able to get NetworkStats due to no Network") {
        this.document.getElementById("network-error-offline").style.display = "flex"
      } else if (error == "Not able to get NetworkStats due to timeout") {
        this.document.getElementById("network-error-online").style.display = "flex"
      }
    });
});

async function updateDevices() {
  try {
    const checkAudioVideoPermission = await window.VideoSDK.checkPermissions();

    cameraPermissionAllowed = checkAudioVideoPermission.get(window.VideoSDK.Constants.permission.VIDEO);
    microphonePermissionAllowed = checkAudioVideoPermission.get(window.VideoSDK.Constants.permission.AUDIO);

    if (cameraPermissionAllowed) {
      const cameras = await window.VideoSDK.getCameras();
      cameraDeviceDropDown.innerHTML = "";
      cameras.forEach(item => {
        const li = document.createElement('li');
        li.id = item.deviceId;
        li.textContent = item.label;
        li.addEventListener("click", function () {
          document.getElementById(currentCamera.deviceId).innerHTML = `
            ${currentCamera.label}
          `
          currentCamera = item;
          document.getElementById("select-camera").innerHTML = `
          <i class="bi bi-camera-video" style="font-size: 16px;"></i>
          ${currentCamera.label}
          `

          document.getElementById(currentCamera.deviceId).innerHTML = `
        <i class="bi bi-check2"></i>
        ${currentCamera.label}
        `

          toggleWebCam();
          toggleWebCam();
        })
        currentCamera = item;
        document.getElementById("select-camera").innerHTML = `
          <i class="bi bi-camera-video" style="font-size: 16px;"></i>
          ${currentCamera.label}
          `
        cameraDeviceDropDown.appendChild(li);
      });

      document.getElementById(currentCamera.deviceId).innerHTML = `
        <i class="bi bi-check2"></i>
        ${currentCamera.label}
        `

    } else {
      const option = document.createElement('option');
      option.value = "Permission needed";
      option.text = "Permission needed";
      cameraDeviceDropDown.appendChild(option);
      cameraDeviceDropDown.disabled = true;
      cameraDeviceDropDown.setAttribute("style", "cursor:not-allowed")
    }

    if (microphonePermissionAllowed) {
      const microphones = await window.VideoSDK.getMicrophones();
      const playBackDevices = await window.VideoSDK.getPlaybackDevices();
      microphoneDeviceDropDown.innerHTML = "";
      playBackDeviceDropDown.innerHTML = "";

      microphones.forEach((item) => {
        const li = document.createElement('li');
        li.id = item.deviceId;
        li.textContent = item.label;
        li.addEventListener("click", (e) => {
          if (currentMic.deviceId == "communications" || currentMic.deviceId == "default") {
            document.querySelector(`#microphoneDeviceDropDown #${currentMic.deviceId}`).innerHTML = `
            ${currentMic.label}
            `
          } else {
            document.getElementById(currentMic.deviceId).innerHTML = `
            ${currentMic.label}
            `
          }
          currentMic = item;
          document.getElementById("select-microphone").innerHTML = `
          <i class="bi bi-mic" style="font-size: 14px;"></i>
          ${currentMic.label}
          `

          if (currentMic.deviceId == "communications" || currentMic.deviceId == "default") {
            document.querySelector(`#microphoneDeviceDropDown #${currentMic.deviceId}`).innerHTML = `
            <i class="bi bi-check2"></i>
            ${currentMic.label}
            `
          } else {
            document.getElementById(currentMic.deviceId).innerHTML = `
            <i class="bi bi-check2"></i>
            ${currentMic.label}
            `
          }
          enableMic();
        })
        if (item.deviceId == 'default') {
          currentMic = item;
          document.getElementById("select-microphone").innerHTML = `
          <i class="bi bi-mic" style="font-size: 14px;"></i>
          ${currentMic.label}
          `
        }
        microphoneDeviceDropDown.appendChild(li);
      });

      playBackDevices.forEach(item => {
        const li = document.createElement('li');
        li.classList.add("playback-type");
        li.id = item.deviceId;
        li.textContent = item.label;
        li.addEventListener("click", () => {
          if (currentPlayback.deviceId == "communications" || currentPlayback.deviceId == "default") {
            document.querySelector(`#playBackDeviceDropDown #${currentPlayback.deviceId}`).innerHTML = `
              ${currentPlayback.label}
            `
          } else {
            document.getElementById(currentPlayback.deviceId).innerHTML = `
            ${currentPlayback.label}
            `
          }
          currentPlayback = item;
          document.getElementById("select-speaker").innerHTML = `
        <i class="bi bi-volume-up" style="font-size: 17px;"></i>
        ${currentPlayback.label}
        `;
          setAudioOutputDevice(currentPlayback.deviceId);

          if (currentPlayback.deviceId == "communications" || currentPlayback.deviceId == "default") {
            document.querySelector(`#playBackDeviceDropDown #${currentPlayback.deviceId}`).innerHTML = `
          <i class="bi bi-check2"></i>
          ${currentPlayback.label}
          `
          } else {
            document.getElementById(currentPlayback.deviceId).innerHTML = `
          <i class="bi bi-check2"></i>
            ${currentPlayback.label}
            `
          }
        })
        if (item.deviceId == 'default') {
          currentPlayback = item;
          document.getElementById("select-speaker").innerHTML = `
          <i class="bi bi-volume-up" style="font-size: 17px;"></i>
          ${currentPlayback.label}
          `
        }
        playBackDeviceDropDown.appendChild(li);
      });

      document.querySelector(`#microphoneDeviceDropDown #${currentMic.deviceId}`).innerHTML = `
            <i class="bi bi-check2"></i>
            ${currentMic.label}
            `

      document.querySelector(`#playBackDeviceDropDown #${currentPlayback.deviceId}`).innerHTML = `
          <i class="bi bi-check2"></i>
          ${currentPlayback.label}
          `

    } else {
      const microphoneDeviceOption = document.createElement('option');
      microphoneDeviceOption.value = "Permission needed";
      microphoneDeviceOption.text = "Permission needed";
      microphoneDeviceDropDown.appendChild(microphoneDeviceOption);

      const playBackDeviceOption = document.createElement('option');
      playBackDeviceOption.value = "Permission needed";
      playBackDeviceOption.text = "Permission needed";
      playBackDeviceDropDown.appendChild(playBackDeviceOption);

      microphoneDeviceDropDown.disabled = true;
      playBackDeviceDropDown.disabled = true;
      microphoneDeviceDropDown.setAttribute("style", "cursor:not-allowed")
      playBackDeviceDropDown.setAttribute("style", "cursor:not-allowed")
    }
  } catch (Ex) {
    console.log("Error in check permission" + Ex);
  }
}

function handleInputChange(event) {
  var input = event.target;
  var inputValue = input.value;

  if (input.id === "joinMeetingId") {
    joinMeetingCodeValue = inputValue;
  } else if (input.id === "name") {
    joinNameValue = inputValue;
  }

  if (joinMeetingCodeValue.length == 14 && joinNameValue.length >= 3) {
    document.querySelector(".inner-join-button").style.backgroundColor = "#5A6BFF";
    document.querySelector(".inner-join-button").style.border = "none";
  } else {
    document.querySelector(".inner-join-button").style.backgroundColor = "rgb(28, 28, 28)";
    document.querySelector(".inner-join-button").style.border = "0.1px solid rgb(122, 122, 122)";
  }
}

const setAudioOutputDevice = (deviceId) => {
  const audioTags = document.getElementsByTagName("audio");
  for (let i = 0; i < audioTags.length; i++) {
    audioTags.item(i).setSinkId(deviceId);
  }
};

function showInputFields() {
  const inputElement = document.querySelectorAll(".join-meeting-input");
  inputElement.forEach((element) => {
    element.style.display = "block";
    element.style.margin = "auto";
  })

  document.querySelectorAll(".join-btn").forEach((btn => {
    btn.style.display = 'none'
  }))
}
function hideInputFields() {
  const inputElement = document.querySelectorAll(".join-meeting-input");
  inputElement.forEach((element) => {
    element.style.display = "none";
  })

  document.querySelectorAll(".join-btn").forEach((btn => {
    btn.style.display = 'block'
  }))
}

function getBaseUrl() {
  const currentPath = window.location.pathname;

  if (currentPath.startsWith('/admin')) {
    return window.location.origin + '/admin/';
  } else if (currentPath.startsWith('/doctor')) {
    return window.location.origin + '/doctor/';
  } else if (currentPath.startsWith('/patient')) {
    return window.location.origin + '/patient/';
  }

  // Default fallback
  return window.location.origin + '/';
}

async function tokenGeneration() {
  try {

    const appUrl = getBaseUrl(); // ✅ Dynamic base URL detect
    console.log("Fetching token from:", `${appUrl}videosdk-token`);
    const response = await fetch(`${appUrl}videosdk-token`);

    //console.log("Fetching token from:", `${window.APP_URL}videosdk-token`);
    //const response = await fetch(`${window.APP_URL}videosdk-token`);
    
    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    const data = await response.json();

    if (!data.token) {
      throw new Error('Token not received from server');
    }

    token = data.token;
    //console.log("Token generated:", token);
    return token;
  } catch (error) {
    console.error("Error generating token:", error);
    alert("Failed to generate token. Please try again.");
    window.location.href = "/";
    throw error; // Re-throw to prevent further execution
  }
}

async function validateMeeting(meetingId, joinMeetingName) {
  if (token) {
    const url = `${API_BASE_URL}/v2/rooms/validate/${meetingId}`;

    const options = {
      method: "GET",
      headers: { Authorization: token },
    };

    const result = await fetch(url, options)
      .then((response) => response.json())
      .catch((error) => {
        console.error("error", error);
        alert("Invalid Meeting Id");
        window.location.href = "/";
        return;
      });

    if (result.roomId === meetingId) {
      document.getElementById("meetingid").value = meetingId;
      document.getElementById("joinPage").style.display = "none";
      document.getElementById("gridPpage").style.display = "flex";
      toggleControls();
      startMeeting(token, meetingId, joinMeetingName);
    }
  }
}

function addParticipantToList({ id, displayName }) {
  let participantTemplate = document.createElement("div");
  participantTemplate.className = "row";
  participantTemplate.style.padding = "4px";
  participantTemplate.style.marginTop = "1px";
  participantTemplate.style.marginLeft = "7px";
  participantTemplate.style.marginRight = "7px";
  participantTemplate.style.borderRadius = "3px";
  participantTemplate.style.border = "1px solid rgb(61, 60, 78)";
  participantTemplate.style.backgroundColor = "rgb(0, 0, 0)";

  let colIcon = document.createElement("div");
  colIcon.className = "col-2";
  colIcon.innerHTML = "Icon";
  participantTemplate.appendChild(colIcon);

  let content = document.createElement("div");
  colIcon.className = "col-3";
  colIcon.innerHTML = `${displayName}`;
  participantTemplate.appendChild(content);

  participantsList.appendChild(participantTemplate);
  participantsList.appendChild(document.createElement("br"));
}

function createLocalParticipant() {
  totalParticipants++;
  localParticipant = createVideoElement(meeting.localParticipant.id);
  localParticipantAudio = createAudioElement(meeting.localParticipant.id);
  videoContainer.appendChild(localParticipant);
}

async function startMeeting(token, meetingId, name) {
  if (joinPageVideoStream !== null) {
    const tracks = joinPageVideoStream.getTracks();
    tracks.forEach((track) => {
      track.stop();
    });
    joinPageVideoStream = null;
    joinPageWebcam.srcObject = null;
  }

  window.VideoSDK.off("device-changed", deviceChangeEventListener);

  // Meeting config
  window.VideoSDK.config(token);
  let customVideoTrack, customAudioTrack;

  if (webCamEnable) {
    customVideoTrack = await window.VideoSDK.createCameraVideoTrack({
      cameraId: currentCamera.deviceId ? currentCamera.deviceId : undefined,
      optimizationMode: "motion",
      multiStream: false,
    });
  }

  if (micEnable) {
    customAudioTrack = await window.VideoSDK.createMicrophoneAudioTrack({
      microphoneId: currentMic.deviceId ? currentMic.deviceId : undefined,
      encoderConfig: "high_quality",
      noiseConfig: {
        noiseSuppresion: true,
        echoCancellation: true,
        autoGainControl: true,
      },
    });
  }

  // Meeting Init
  meeting = window.VideoSDK.initMeeting({
    meetingId: meetingId,
    name: name,
    micEnabled: micEnable,
    webcamEnabled: webCamEnable,
    maxResolution: "hd",
    customCameraVideoTrack: customVideoTrack,
    customMicrophoneAudioTrack: customAudioTrack,
  });

  participants = meeting.participants;

  // Meeting Join
  meeting.join();

  //create Local Participant
  createLocalParticipant();

  //add yourself in participant list
  if (totalParticipants != 0)
    addParticipantToList({
      id: meeting.localParticipant.id,
      displayName: "You",
    });

  // Setting local participant stream
  meeting.localParticipant.on("stream-enabled", (stream) => {
    setTrack(
      stream,
      localParticipantAudio,
      meeting.localParticipant,
      (isLocal = true)
    );
  });

  meeting.localParticipant.on("stream-disabled", (stream) => {
    if (stream.kind == "video") {
      videoCamOn.style.display = "none";
      videoCamOff.style.display = "inline-block";
    }
    if (stream.kind == "audio") {
      micOn.style.display = "none";
      micOff.style.display = "inline-block";
    }
  });

  meeting.on("meeting-joined", () => {
    meeting.pubSub.subscribe("CHAT", (data) => {
      let { message, senderId, senderName, timestamp } = data;
      const chatBox = document.getElementById("chatArea");
      const chatTemplate = `
          <div style="margin-bottom: 10px; ${meeting.localParticipant.id == senderId && "text-align : right"
        }">
            <span style="font-size:12px;">${senderName}</span>
            <div style="margin-top:5px">
              <span style="background:${meeting.localParticipant.id == senderId ? "grey" : "crimson"
        };color:white;padding:5px;border-radius:8px">${message}<span>
            </div>
          </div>
          `;
      chatBox.insertAdjacentHTML("beforeend", chatTemplate);
    });
  });

  meeting.on("meeting-left", () => {
    window.location.reload();
    document.getElementById("join-page").style.display = "flex";
  });

  // Other participants
  meeting.on("participant-joined", (participant) => {
    totalParticipants++;
    let videoElement = createVideoElement(participant.id);
    let resizeObserver = new ResizeObserver(() => {
      participant.setViewPort(
        videoElement.offsetWidth,
        videoElement.offsetHeight
      );
    });
    resizeObserver.observe(videoElement);
    let audioElement = createAudioElement(participant.id);
    remoteParticipantId = participant.id;

    participant.on("stream-enabled", (stream) => {
      setTrack(stream, audioElement, participant, (isLocal = false));
    });
    videoContainer.appendChild(videoElement);
    videoContainer.appendChild(audioElement);
    addParticipantToList(participant);
    setAudioOutputDevice(currentPlayback.deviceId);
  });

  // participants left
  meeting.on("participant-left", (participant) => {
    totalParticipants--;
    let vElement = document.getElementById(`v-${participant.id}`);
    vElement.parentNode.removeChild(vElement);

    let aElement = document.getElementById(`a-${participant.id}`);
    aElement.parentNode.removeChild(aElement);
    document.getElementById(`p-${participant.id}`).remove();
  });

  //recording events
  meeting.on("recording-started", () => {
    btnStartRecording.style.display = "none";
    btnStopRecording.style.display = "inline-block";
  });
  meeting.on("recording-stopped", () => {
    btnStartRecording.style.display = "inline-block";
    btnStopRecording.style.display = "none";
  });

  meeting.on("presenter-changed", (presenterId) => {
    if (presenterId) {
      console.log(presenterId);
    } else {
      videoScreenShare.removeAttribute("src");
      videoScreenShare.pause();
      videoScreenShare.load();
      videoScreenShare.style.display = "none";

      btnScreenShare.style.color = "white";
      screenShareOn = false;
    }
  });

  //add DOM Events
  addDomEvents();
}

async function joinMeeting(newMeeting) {
  try {
    // get Token
    await tokenGeneration();

    let joinMeetingName = document.getElementById("name");
    let meetingId = document.getElementById("joinMeetingId").value || "";

    if (!newMeeting) {
      if (!meetingId) {
        return alert("Please enter a meeting ID");
      }
      if (!validateMeetingId(meetingId)) {
        return alert("Please enter a valid meeting ID (format: xxxx-xxxx-xxxx)");
      }
      await validateMeeting(meetingId, joinNameValue);
      return;
    }

    // Create new meeting
    const url = `${API_BASE_URL}/v2/rooms`;
    const options = {
      method: "POST",
      headers: {
        Authorization: token,
        "Content-Type": "application/json"
      },
    };

    const response = await fetch(url, options);
    if (!response.ok) {
      throw new Error(`Failed to create room: ${response.status}`);
    }

    const { roomId } = await response.json();
    if (roomId) {
      document.getElementById("meetingid").value = roomId;
      document.getElementById("joinPage").style.display = "none";
      document.getElementById("gridPpage").style.display = "flex";
      toggleControls();
      startMeeting(token, roomId, 'Admin');
    }
  } catch (error) {
    console.error("Error in joinMeeting:", error);
    alert("Failed to join/create meeting. Please try again.");
  }
}

function validateMeetingId(meetingId) {
  const regex = /^[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}$/;
  return regex.test(meetingId);
}

function createVideoElement(pId) {
  let division;
  division = document.createElement("div");
  division.setAttribute("id", "video-frame-container");
  division.className = `v-${pId}`;
  let videoElement = document.createElement("video");
  videoElement.classList.add("video-frame");
  videoElement.setAttribute("id", `v-${pId}`);
  videoElement.setAttribute("playsinline", true);
  videoElement.setAttribute("width", "300");
  division.appendChild(videoElement);
  return videoElement;
}

function createAudioElement(pId) {
  let audioElement = document.createElement("audio");
  audioElement.setAttribute("autoPlay", "false");
  audioElement.setAttribute("playsInline", "true");
  audioElement.setAttribute("controls", "false");
  audioElement.setAttribute("id", `a-${pId}`);
  return audioElement;
}

function setTrack(stream, audioElement, participant, isLocal) {
  if (stream.kind == "video") {
    if (isLocal) {
      videoCamOff.style.display = "none";
      videoCamOn.style.display = "inline-block";
    }
    const mediaStream = new MediaStream();
    mediaStream.addTrack(stream.track);
    let videoElm = document.getElementById(`v-${participant.id}`);
    videoElm.srcObject = mediaStream;
    videoElm
      .play()
      .catch((error) =>
        console.error("videoElem.current.play() failed", error)
      );
    participant.setViewPort(videoElm.offsetWidth, videoElm.offsetHeight);
  }
  if (stream.kind == "audio") {
    if (isLocal) {
      micOff.style.display = "none";
      micOn.style.display = "inline-block";
      return;
    }
    const mediaStream = new MediaStream();
    mediaStream.addTrack(stream.track);
    audioElement.srcObject = mediaStream;
    audioElement
      .play()
      .catch((error) => console.error("audioElem.play() failed", error));
  }
  if (stream.kind == "share" && !isLocal) {
    screenShareOn = true;
    const mediaStream = new MediaStream();
    mediaStream.addTrack(stream.track);
    videoScreenShare.srcObject = mediaStream;
    videoScreenShare
      .play()
      .catch((error) =>
        console.error("videoElem.current.play() failed", error)
      );
    videoScreenShare.style.display = "inline-block";
    btnScreenShare.style.color = "grey";
  }
}

function addDomEvents() {
  micOn.addEventListener("click", () => {
    meeting.muteMic();
  });

  micOff.addEventListener("click", async () => {
    if (microphonePermissionAllowed) {
      meeting.unmuteMic();
    }
  });

  videoCamOn.addEventListener("click", async () => {
    meeting.disableWebcam();
  });

  videoCamOff.addEventListener("click", async () => {
    if (cameraPermissionAllowed) {
      meeting.enableWebcam();
    }
  });

  btnScreenShare.addEventListener("click", async () => {
    if (btnScreenShare.style.color == "grey") {
      meeting.disableScreenShare();
    } else {
      meeting.enableScreenShare();
    }
  });

  $(".btnRaiseHand").click(function () {
    let participantId = localParticipant.className;
    //console.log([participantId, meeting.localParticipant.id]);
    if (participantId.split("-")[1] == meeting.localParticipant.id) {
      contentRaiseHand.innerHTML = "You Have Raised Your Hand";
    } else {
      contentRaiseHand.innerHTML = `<b>${remoteParticipantId}</b> Have Raised Their Hand`;
    }

    $("#contentRaiseHand").show();
    setTimeout(function () {
      $("#contentRaiseHand").hide();
    }, 2000);
  });

  btnSend.addEventListener("click", async () => {
    const message = document.getElementById("txtChat").value;
    document.getElementById("txtChat").value = "";
    meeting.pubSub
      .publish("CHAT", message, { persist: true })
      .then((res) => console.log(`response of publish : ${res}`))
      .catch((err) => console.log(`error of publish : ${err}`));
  });

  $(".leaveCall").click(async () => {
    participants = new Map(meeting.participants);
    meeting.leave();
  });

  $(".endCall").click(async () => {
    meeting.end();
  });

  btnStartRecording.addEventListener("click", async () => {
    meeting.startRecording();
  });

  btnStopRecording.addEventListener("click", async () => {
    meeting.stopRecording();
  });
}

async function toggleMic() {
  if (micEnable) {
    document.getElementById("micButton").style.backgroundColor = "#FF5D5D";
    document.getElementById("micButton").style.color = "black";
    document.getElementById("muteMic").style.display = "unset";
    document.getElementById("unmuteMic").style.display = "none";
    micEnable = false;
  } else {
    enableMic();
  }
}

async function toggleWebCam() {
  if (joinPageVideoStream) {
    document.getElementById("camera-status").style.display = "block";
    joinPageWebcam.style.backgroundColor = "#1C1C1C";
    joinPageWebcam.srcObject = null;
    document.getElementById("camButton").style.backgroundColor = "#FF5D5D";
    document.getElementById("camButton").style.color = "black";
    document.getElementById("offCamera").style.display = "unset";
    document.getElementById("onCamera").style.display = "none";
    webCamEnable = false;
    const tracks = joinPageVideoStream.getTracks();
    tracks.forEach((track) => {
      track.stop();
    });
    joinPageVideoStream = null;
  } else {
    enableCam();
  }
}

async function enableCam() {
  if (joinPageVideoStream !== null) {
    const tracks = joinPageVideoStream.getTracks();
    tracks.forEach((track) => {
      track.stop();
    });
    joinPageVideoStream = null;
    joinPageWebcam.srcObject = null;
  }

  if (cameraPermissionAllowed) {
    let mediaStream;
    try {
      mediaStream = await window.VideoSDK.createCameraVideoTrack({
        cameraId: currentCamera.deviceId ? currentCamera.deviceId : undefined,
        optimizationMode: "motion",
        multiStream: false,
      });
    } catch (ex) {
      console.log("Exception in enableCam", ex);
    }

    if (mediaStream) {
      document.getElementById("camera-status").style.display = "none";
      joinPageVideoStream = mediaStream;
      joinPageWebcam.srcObject = mediaStream;
      joinPageWebcam.play().catch((error) =>
        console.log("videoElem.current.play() failed", error)
      );
      document.getElementById("camera-status").display = "none";
      document.getElementById("camButton").style.backgroundColor = "white";
      document.getElementById("camButton").style.color = "black";
      document.getElementById("offCamera").style.display = "none";
      document.getElementById("onCamera").style.display = "unset";
      webCamEnable = true;
    }
  }
}

async function enableMic() {
  if (microphonePermissionAllowed) {
    micEnable = true;
    document.getElementById("micButton").style.backgroundColor = "white";
    document.getElementById("micButton").style.color = "black";
    document.getElementById("muteMic").style.display = "none";
    document.getElementById("unmuteMic").style.display = "unset";
  }
}

function copyMeetingCode() {
  copy_meeting_id.select();
  document.execCommand("copy");
}

function openParticipantWrapper() {
  document.getElementById("participants").style.width = "350px";
  document.getElementById("gridPpage").style.marginRight = "350px";
  document.getElementById("ParticipantsCloseBtn").style.visibility = "visible";
  document.getElementById("totalParticipants").style.visibility = "visible";
  document.getElementById(
    "totalParticipants"
  ).innerHTML = `Participants (${totalParticipants})`;
}

function closeParticipantWrapper() {
  document.getElementById("participants").style.width = "0";
  document.getElementById("gridPpage").style.marginRight = "0";
  document.getElementById("ParticipantsCloseBtn").style.visibility = "hidden";
  document.getElementById("totalParticipants").style.visibility = "hidden";
}

function openChatWrapper() {
  document.getElementById("chatModule").style.width = "350px";
  document.getElementById("gridPpage").style.marginRight = "350px";
  document.getElementById("chatCloseBtn").style.visibility = "visible";
  document.getElementById("chatHeading").style.visibility = "visible";
  document.getElementById("btnSend").style.display = "inline-block";
}

function closeChatWrapper() {
  document.getElementById("chatModule").style.width = "0";
  document.getElementById("gridPpage").style.marginRight = "0";
  document.getElementById("chatCloseBtn").style.visibility = "hidden";
  document.getElementById("btnSend").style.display = "none";
}

function toggleControls() {
  if (micEnable) {
    micOn.style.display = "inline-block";
    micOff.style.display = "none";
  } else {
    micOn.style.display = "none";
    micOff.style.display = "inline-block";
  }

  if (webCamEnable) {
    videoCamOn.style.display = "inline-block";
    videoCamOff.style.display = "none";
  } else {
    videoCamOn.style.display = "none";
    videoCamOff.style.display = "inline-block";
  }
}

document.getElementById("no-camera-permission").addEventListener("click", async () => {
  alert("Click (i) left side of URL bar to allow permission ..!");
});