<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('patient_clinics', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('patient_id'); // Will now be user_id of the patient
            $table->unsignedBigInteger('clinic_id');
            $table->unsignedBigInteger('doctor_id');
            $table->unsignedBigInteger('added_by');
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->enum('approval_status', ['pending', 'approved', 'rejected'])->default('approved');
            $table->timestamp('approved_at')->nullable();
            $table->json('notes')->nullable();
            $table->timestamps();

            // Reference patient_id to users table
            $table->foreign('patient_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('clinic_id')->references('id')->on('clinics')->onDelete('cascade');
            $table->foreign('doctor_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('added_by')->references('id')->on('users')->onDelete('cascade');

            $table->unique(['patient_id', 'clinic_id', 'doctor_id'], 'unique_patient_clinic_doctor');
        });
    }

    public function down()
    {
        Schema::dropIfExists('patient_clinics');
    }
};
