<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usage_transactions', function (Blueprint $table) {
            $table->id(); // replaces transaction_id
            $table->unsignedBigInteger('subscription_id');
            $table->unsignedBigInteger('usage_type_id');
            $table->integer('units_used');
            $table->decimal('rate_applied', 10, 2);
            $table->integer('free_units_applied');
            $table->decimal('charge_amount', 10, 2);
            $table->dateTime('transaction_date');
            $table->text('description')->nullable();
            $table->string('billing_cycle', 20);
            $table->timestamps();

            $table->foreign('subscription_id')->references('id')->on('customer_subscriptions');
            $table->foreign('usage_type_id')->references('id')->on('usage_types');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usage_transactions');
    }
};
