<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('add_ons', function (Blueprint $table) {
            $table->id();
            $table->string('addon_code', 25)->unique();
            $table->string('name', 100);
            $table->enum('resource_type', ['storage', 'doctor', 'staff', 'sms', 'talecommunication', 'whatsapp']);
            $table->string('unit', 20);
            $table->bigInteger('unit_counts');
            $table->decimal('price_per_unit', 10, 2);
            $table->string('billing_cycle', 20);
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('add_ons');
    }
};
