<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscription_plans', function (Blueprint $table) {
            $table->id();
            $table->string('plan_code', 50)->unique();
            $table->string('plan_name', 100);
            $table->text('description')->nullable();
            $table->enum('plan_type', ['monthly', 'annual', 'custom']);
            $table->string('duration', 20);
            $table->decimal('base_price', 10, 2);
            $table->decimal('discounted_price', 10, 2)->nullable();
            $table->boolean('addon_eligible')->default(false);
            $table->boolean('is_combo')->default(false);
            $table->string('plan_status', 20)->default('draft');
            $table->integer('max_doctors')->nullable(); // Changed from max_users
            $table->integer('max_staff')->nullable();   // New field
            $table->integer('device_limit')->nullable();
            $table->integer('trial_period')->nullable();
            $table->boolean('auto_renewal')->default(true);
            $table->string('currency', 3)->default('USD');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscription_plans');
    }
};
