<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('features', function (Blueprint $table) {
            $table->id();
            $table->string('feature_code', 25)->unique();
            $table->string('feature_name', 100);
            $table->text('description')->nullable();
            $table->boolean('is_base_feature');
            $table->enum('feature_status', ['active', 'inactive', 'beta'])->default('active');
            $table->string('category', 50)->nullable();
            $table->timestamps();

            $table->index('is_base_feature');
            $table->index('category');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('features');
    }
};
