<?php

use Illuminate\Foundation\Application;
use App\Http\Middleware\SetGuardByRole;
use App\Http\Middleware\CheckActiveDevice;
use App\Http\Middleware\CheckDoctorClinic;
use App\Http\Middleware\CheckClinicPermissions;
use App\Http\Middleware\RedirectIfAuthenticated;
use Spatie\Permission\Middleware\RoleMiddleware;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Spatie\Permission\Middleware\PermissionMiddleware;
use Spatie\Permission\Middleware\RoleOrPermissionMiddleware;


return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'role' => RoleMiddleware::class,
            'permission' => PermissionMiddleware::class,
            'role_or_permission' => RoleOrPermissionMiddleware::class,
            'check_active_device' => CheckActiveDevice::class,
            'set_guard_by_role' => SetGuardByRole::class,
            'check_doctor_clinic' => CheckDoctorClinic::class,
            'clinic_permission' => CheckClinicPermissions::class,
            'redirect_if_authenticated' => RedirectIfAuthenticated::class,
        ]);
        $middleware->group('web', [
            \Illuminate\Cookie\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \Illuminate\Foundation\Http\Middleware\ValidateCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
