<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UsageTransaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'subscription_id',
        'usage_type_id',
        'units_used',
        'rate_applied',
        'free_units_applied',
        'charge_amount',
        'transaction_date',
        'description',
        'billing_cycle'
    ];

    public function subscription()
    {
        return $this->belongsTo(CustomerSubscription::class);
    }

    public function usageType()
    {
        return $this->belongsTo(UsageType::class);
    }
}