<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UsageRate extends Model
{
    protected $fillable = [
        'plan_id',
        'usage_type_id',
        'rate_per_unit',
        'free_units',
        'overage_rate',
        'currency',
        'effective_date',
        'expiry_date'
    ];

    protected $dates = [
        'effective_date' => 'datetime:Y-m-d',
        'expiry_date' => 'datetime:Y-m-d',
    ];

    public function plan(): BelongsTo
    {
        return $this->belongsTo(SubscriptionPlan::class, 'plan_id');
    }

    public function usageType(): BelongsTo
    {
        return $this->belongsTo(UsageType::class, 'usage_type_id');
    }
}