<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SupportTicket extends Model
{
    use HasFactory;

    protected $fillable = [
        'ticket_no',
        'patient_id',
        'doctor_id',
        'appointment_id', // ✅ added
        'created_by',
        'created_by_type',
        'email',
        'subject',
        'message',
        'status',
    ];

    /**
     * Boot method to auto-generate unique ticket_no
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($ticket) {
            if (empty($ticket->ticket_no)) {
                $ticket->ticket_no = self::generateTicketNo();
            }
        });
    }

    /**
     * Generate unique Ticket Number
     */
    private static function generateTicketNo()
    {
        $prefix = "TKT" . date('Ymd');
        $unique = strtoupper(substr(uniqid(), -6)); // last 6 chars
        return $prefix . $unique; // e.g. TKT20250918AB12CD
    }
}
