<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PlanLimit extends Model
{
    protected $fillable = [
        'plan_id',
        'included_doctors',
        'included_staff',
        'storage_limit_gb',
        'teleconsultation_minutes',
        'sms_limit',
        'whatsapp_limit',
        'additional_doctor_price',
        'additional_staff_price'
    ];

    public function plan(): BelongsTo
    {
        return $this->belongsTo(SubscriptionPlan::class, 'plan_id');
    }
}