<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FreeUnitBalance extends Model
{
    use HasFactory;

    protected $fillable = [
        'subscription_id',
        'usage_type_id',
        'cycle_start_date',
        'cycle_end_date',
        'total_free_units',
        'units_consumed'
    ];

    public function subscription()
    {
        return $this->belongsTo(CustomerSubscription::class);
    }

    public function usageType()
    {
        return $this->belongsTo(UsageType::class);
    }
}