<?php

// app/Models/Appointment.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    // protected $fillable = [
    //     'appointment_id', 'patient_id', 'doctor_id', 'department', 'appointment_type',
    //     'appointment_date', 'appointment_time', 'reason', 'status'
    // ];

    protected $fillable = [
        'appointment_id',
        'patient_id',
        'doctor_id',
        'clinic_id',
        'specialization',
        'appointment_date',
        'appointment_slot_time',
        'appointment_fee',
        'fee_type',
        'appointment_type',
        'appointment_status',
        'meeting_id',
        'payment_type', // <-- add this
        'reason',
        'token', // 👈 added
    ];


    public function patient()
    {
        return $this->belongsTo(User::class, 'patient_id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }
}

