<?php
namespace App\Mail\Staff;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CreateStaffMail extends Mailable
{
    use Queueable, SerializesModels;

    public $staffName;
    public $clinicName;
    public $doctorName;
    public $username;
    public $temporaryPassword;
    public $role;
    public $permissions;

    public function __construct($staffName, $clinicName, $doctorName, $username, $temporaryPassword, $role, $permissions = [])
    {
        $this->staffName = $staffName;
        $this->clinicName = $clinicName;
        $this->doctorName = $doctorName;
        $this->username = $username;
        $this->temporaryPassword = $temporaryPassword;
        $this->role = $role;
        $this->permissions = $permissions;
    }

    public function build()
    {
        return $this->subject('Your Staff Account Has Been Created on PRED Care')
            ->view('mail.staff.create-staff-mail');
    }
}

