<?php

namespace App\Mail\Patient;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\User;
use App\Models\Patient;

class UpdatePatientMail extends Mailable
{
    use Queueable, SerializesModels;

    public $adminDoctor;
    public $patient;
    public $updatedBy;
    public $updatedAt;
    public $changedFields;

    /**
     * Create a new message instance.
     */
    public function __construct(User $adminDoctor, Patient $patient, User $updatedBy, $updatedAt, array $changedFields)
    {
        $this->adminDoctor = $adminDoctor;
        $this->patient = $patient;
        $this->updatedBy = $updatedBy;
        $this->updatedAt = $updatedAt;
        $this->changedFields = $changedFields;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Patient Profile Updated on PRED Care',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'mail.patient.update-patient-mail',
            with: [
                'adminDoctor' => $this->adminDoctor,
                'patient' => $this->patient,
                'updatedBy' => $this->updatedBy,
                'updatedAt' => $this->updatedAt,
                'changedFields' => $this->changedFields,
            ]
        );
    }

    /**
     * Get the attachments for the message.
     */
    public function attachments(): array
    {
        return [];
    }
}