<?php

namespace App\Livewire\Doctor\Profile;

use Livewire\Component;
use App\Models\DoctorEducation;
use App\Models\DoctorProfile;
use Illuminate\Support\Facades\Auth;

class DoctorEducationComponent extends Component
{
    public $educations = [];

    protected $rules = [
        'educations.*.institution' => 'required|string|max:255',
        'educations.*.degree' => 'required|string|max:255',
        'educations.*.start_year' => 'required|digits:4|integer|min:1900',
        'educations.*.end_year' => 'nullable|digits:4|integer|min:1900',
    ];

    public function mount()
    {
        $doctorProfile = Auth::user()->doctorProfile;
        $this->educations = $doctorProfile->educations->toArray() ?? [];
        
        if (empty($this->educations)) {
            $this->addEducation();
        }
    }

    public function addEducation()
    {
        $this->educations[] = [
            'institution' => '',
            'degree' => '',
            'start_year' => '',
            'end_year' => '',
            'is_current' => false,
        ];
    }

    public function removeEducation($index)
    {
        if (isset($this->educations[$index]['id'])) {
            DoctorEducation::find($this->educations[$index]['id'])->delete();
        }
        unset($this->educations[$index]);
        $this->educations = array_values($this->educations);
    }

    public function save()
    {
        $this->validate();

        $doctorProfile = Auth::user()->doctorProfile;

        $doctorProfile->educations()->delete();

        foreach ($this->educations as $education) {
            if (!empty($education['institution']) && !empty($education['degree'])) {
                $data = [
                    'institution' => $education['institution'],
                    'degree' => $education['degree'],
                    'start_year' => $education['start_year'],
                    'is_current' => empty($education['end_year']),
                ];
                    
                if($education['end_year'] ?? null){
                    $data['end_year'] = $education['end_year'];
                }
                $doctorProfile->educations()->create($data);
            }
        }

        notyf()->success('Education information saved successfully.');
    }

    public function render()
    {
        return view('livewire.doctor.profile.doctor-education-component');
    }
}