<?php

namespace App\Livewire\Admin\Plans;

use App\Models\UsageType;
use Livewire\Component;

class UsageTypeForm extends Component
{
    public $type_name;
    public $unit_name;
    public $description;
    public $is_active = 1;
    public $usageType;

    protected $rules = [
        'type_name' => 'required|string|max:255',
        'unit_name' => 'required|string|max:50',
        'description' => 'nullable|string|max:500',
        'is_active' => 'required|boolean',
    ];

    public function mount(UsageType $usageType = null)
    {
        $this->usageType = $usageType;

        $this->type_name = $usageType->type_name ?? '';
        $this->unit_name = $usageType->unit_name ?? '';
        $this->description = $usageType->description ?? '';
        $this->is_active = $usageType->is_active ?? true;
    }

    public function save()
    {
        $this->validate();

        $data = [
            'type_name' => $this->type_name,
            'unit_name' => $this->unit_name,
            'description' => $this->description,
            'is_active' => $this->is_active
        ];

        if ($this->usageType && $this->usageType->exists) {
            $this->usageType->update($data);
            $message = 'Usage Type updated successfully';
        } else {
            UsageType::create($data);
            $message = 'Usage Type created successfully';
        }

        session()->flash('message', $message);
        return redirect()->route('admin.plans.usage-types.index');
    }

    public function render()
    {
        return view('livewire.admin.plans.usage-type-form');
    }
}