<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;


class HomeController extends Controller
{
    public function index()
    {
        return view('home');
    }

    public function forgotPassword()
    {
        return view('user.forgot-password');
    }

    public function showResetForm($token, $email)
    {   
        // Check if token is valid and not expired (1 hour expiration)
        $record = DB::table('password_reset_tokens')
                    ->where('email', $email)
                    ->first();

        // Check if token exists
        if (!$record) {
            notyf()->error('Invalid or expired token !');
            return redirect()->route('home');
            //throw new \Exception('Invalid or expired token.');
        }

        // Check if token matches (hashed comparison)
        if (!hash_equals($record->token, hash('sha256', $token))) {
            notyf()->error('Invalid Token !');
            return redirect()->route('home');
            //throw new \Exception('Invalid token.');
        }

        // Check if token is expired
        if (Carbon::parse($record->created_at)->addMinutes(30)->isPast()) {
            notyf()->error('This password reset link has expired !');
            return redirect()->route('home');
            //throw new \Exception('This password reset link has expired (1-minute test).');
        }

        return view('user.reset-password', [
            'token' => $token,
            'email' => $email
        ]);
    }
}