<?php

namespace App\Http\Controllers\Doctor\Staff;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class DoctorStaffController extends Controller
{
    public function index()
    {
        Log::info('DoctorStaffController@index called');
        return view('doctor.staff.list');
    }
    public function addstaff()
    {
        return view('doctor.staff.add');
    }
    public function edit(User $doctor , User $staff)
    {
        return view('doctor.staff.add', ['staff' => $staff , 'doctor' => $doctor]);
    }
    public function view(User $staff)
    {
        return view('doctor.staff.view', ['staffId' => $staff->id]);
    }
}
