<?php

namespace App\Http\Controllers\Doctor\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Log;
use App\Models\ActiveDevice;

class StaffAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('doctor.auth.login', ['role' => 'doctor_staff']);
    }

    public function logout(Request $request)
    {
        $user = Auth::guard('doctor')->user();
        $deviceId = Session::get('device_id');
        $currentRole = Session::get('current_role');
        
        if ($user && $deviceId) {
            Log::info('Doctor staff logout', [
                'user_id' => $user->id,
                'device_id' => $deviceId,
                'role_type' => $currentRole ?? 'doctor_staff'
            ]);
            
            ActiveDevice::where('user_id', $user->id)
                ->where('device_id', $deviceId)
                ->where('role_type', $currentRole ?? 'doctor_staff')
                ->update([
                    'is_active' => false,
                    'last_active_at' => now(),
                ]);
        }

        Session::forget(['device_id', 'current_role', 'session_id']);
        Auth::guard('doctor')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('doctor.staff.login');
    }
}