<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Faq;
use App\Models\PrivacyPolicy;
use App\Models\TermCondition;

class BasicSettingController extends Controller
{
    // ✅ Patient FAQs
    public function faqPatient()
    {
        $faqs = Faq::where('type', 'patient')
            ->where('status', 1)
            ->get(['id', 'question', 'answer']);

        return response()->json([
            'status' => true,
            'message' => 'Patient FAQs fetched successfully',
            'data' => $faqs
        ]);
    }

    // ✅ Patient Privacy Policy
    public function privacyPolicyPatient()
    {
        $policies = PrivacyPolicy::where('type', 'patient')
            ->where('status', 1)
            ->get(['id', 'content']);

        return response()->json([
            'status' => true,
            'message' => 'Patient Privacy Policies fetched successfully',
            'data' => $policies
        ]);
    }

    // ✅ Patient Terms & Conditions
    public function termsPatient()
    {
        $terms = TermCondition::where('type', 'patient')
            ->where('status', 1)
            ->get(['id', 'content']);

        return response()->json([
            'status' => true,
            'message' => 'Patient Terms & Conditions fetched successfully',
            'data' => $terms
        ]);
    }

    
    // ✅ Doctor FAQs
    public function faqDoctors()
    {
        $faqs = Faq::where('type', 'doctor')
            ->where('status', 1)
            ->get(['id', 'question', 'answer']); // 👈 sirf ye fields return hongi

        return response()->json([
            'status' => true,
            'message' => 'Doctor FAQs fetched successfully',
            'data' => $faqs
        ]);
    }


    // ✅ Doctor Privacy Policy
    public function privacyPolicyDoctor()
    {
        $policies = PrivacyPolicy::where('type', 'doctor')
            ->where('status', 1)
            ->get(['id', 'content']); // 👈 sirf id & content

        return response()->json([
            'status' => true,
            'message' => 'Doctor Privacy Policies fetched successfully',
            'data' => $policies
        ]);
    }

    // ✅ Doctor Terms & Conditions
    public function termsDoctor()
    {
        $terms = TermCondition::where('type', 'doctor')
            ->where('status', 1)
            ->get(['id', 'content']);

        return response()->json([
            'status' => true,
            'message' => 'Doctor Terms & Conditions fetched successfully',
            'data' => $terms
        ]);
    }
}
