<?php

namespace App\Http\Controllers\Admin;

use App\Models\Doctor;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DoctorManagementController extends Controller
{
    public function index()
    {
        return view('admin.doctor.doctor-list');
    }

    public function create()
    {
        return view('admin.doctor.doctor-form', ['editId' => null]);
    }

    public function edit($id)
    {
        return view('admin.doctor.doctor-form', ['editId' => $id]);
    }

    public function view($id)
    {
        return view('admin.doctor.doctor-view', [
            'id' => $id
        ]);
    }

    public function clinicManager($doctorId = null)
    {
        return view('admin.doctor.clinic-manager', [
            'doctorId' => $doctorId
        ]);
    }

    function profile($id)
    {
        return view('admin.clinic.view', ['id' => $id]);
    }
}