<div class="d-flex flex-column justify-content-lg-center p-4 p-lg-0 pb-0 flex-fill">
    <div class=" mx-auto mb-3 text-center">
        <img src="<?php echo e(asset('assets/img/PRED_CARE-Logo.png')); ?>" class="img-fluid login-logo-small" alt="Logo">
    </div>
    <div class="card border-1 p-lg-3 shadow-md rounded-3 mb-4">
        <div class="card-body">
            <div class="text-center mb-3">
                <h5 class="mb-1 fs-20 fw-bold">Reset Password</h5>
                <p class="mb-0">Enter your email address to receive a password reset link</p>
            </div>

            <!--[if BLOCK]><![endif]--><?php if($status): ?>
                <div class="alert alert-<?php echo e(str_contains($status, 'Failed') ? 'danger' : 'success'); ?> mt-3">
                    <?php echo e($status); ?>

                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <div class="mb-3">
                <label class="form-label">Email Address <span class="text-danger">*</span></label>
                <div class="input-group">
                    <span class="input-group-text border-end-0 bg-white">
                        <i class="ti ti-mail fs-14 text-dark"></i>
                    </span>
                    <input wire:model.lazy="email" type="email" name="email"
                        class="form-control border-start-0 ps-0" placeholder="Enter Email Address" 
                        wire:keydown.enter="sendResetLink" required>
                </div>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger pt-2"><?php echo e($message); ?></div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            
            <div class="mb-3">
                <button type="button"
                    class="btn bg-primary text-white w-100 position-relative d-flex align-items-center justify-content-center"
                    wire:click="sendResetLink"
                    wire:loading.attr="disabled">

                    <span wire:loading.class="d-none">
                        <i class="fas fa-paper-plane me-2"></i>
                        Send Reset Link
                    </span>

                    <span wire:loading.class.remove="d-none" class="d-none">
                        <div class="spinner-border spinner-border-sm me-2" role="status"></div>
                        Sending...
                    </span>
                </button>
            </div>
            
            <div class="text-center">
                <h6 class="fw-normal fs-14 text-dark mb-0">
                    Remember your password? 
                    <a href="<?php echo e(back()->getTargetUrl()); ?>" class="hover-a">
                        Back to Login
                    </a>
                </h6>
            </div>
        </div><!-- end card body -->
    </div><!-- end card -->
</div>

    <?php
        $__scriptKey = '1382854485-0';
        ob_start();
    ?>
<script>
    Livewire.on('reset-complete', () => {
        // You can add any post-submission JavaScript here
        // For example, scroll to the status message:
        const alert = document.querySelector('.alert');
        if (alert) {
            alert.scrollIntoView({ behavior: 'smooth' });
        }
    });
</script>
    <?php
        $__output = ob_get_clean();

        \Livewire\store($this)->push('scripts', $__output, $__scriptKey)
    ?><?php /**PATH /var/www/predcare/resources/views/livewire/user/forgot-password-form.blade.php ENDPATH**/ ?>