<div class="content">
    <!-- Success Message -->
    <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('message')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Error Message -->
    <?php if(session()->has('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Start Page Header -->
    <div class="d-flex align-items-sm-center flex-sm-row flex-column gap-2 pb-3 mb-3 border-1 border-bottom">
        <div class="flex-grow-1">
            <h4 class="fw-bold mb-0">Staff List
                <span class="badge badge-soft-primary fs-13 fw-medium ms-2">
                    Total Staff: <?php echo e($staffAssociations->total()); ?>

                </span>
            </h4>
        </div>
        <div class="text-end d-flex">
            <!-- Add New Staff -->
            <a href="<?php echo e(route('doctor.staff.add')); ?>" class="btn btn-primary ms-2 fs-13 btn-md">
                <i class="ti ti-plus me-1"></i>Add New Staff
            </a>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Start Filter -->
    <div class="d-flex align-items-center justify-content-between flex-wrap">
        <!-- Search -->
        <div>
            <div class="search-set mb-3">
                <div class="d-flex align-items-center flex-wrap gap-2">
                    <div class="table-search d-flex align-items-center mb-0">
                        <div class="search-input">
                            <input type="text" wire:model.live.debounce.300ms="search"
                                class="form-control form-control-md" placeholder="Search staff...">
                            <a href="javascript:void(0);" class="btn-searchset"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters and Sort -->
        <div class="d-flex table-dropdown mb-3 right-content align-items-center flex-wrap row-gap-3">
            <!-- Filter Dropdown -->
            <div class="dropdown me-2">
                <a href="javascript:void(0);"
                    class="btn btn-white bg-white fs-14 py-1 border d-inline-flex text-dark align-items-center"
                    data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <i class="ti ti-filter text-gray-5 me-1"></i>Filters
                </a>
                <div class="dropdown-menu dropdown-lg dropdown-menu-end filter-dropdown bg-white p-0" id="filter-dropdown">
                    <div class="d-flex align-items-center justify-content-between border-bottom filter-header">
                        <h4 class="mb-0">Filter</h4>
                        <div class="d-flex align-items-center">
                            <a href="javascript:void(0);" class="link-danger text-decoration-underline"
                                wire:click="clearAllFilters">Clear All</a>
                        </div>
                    </div>
                    <div class="filter-body pb-0">
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Status</label>
                                <a href="javascript:void(0);" class="link-primary mb-1"
                                    wire:click="resetStatusFilter">Reset</a>
                            </div>
                            <select class="form-select" wire:model="statusFilter">
                                <option value="all">All Status</option>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                                <option value="beta">Beta</option>
                            </select>
                        </div>

                        <!-- Docotr Filter -->
                        <div class="mb-3">
                            <div class="d-flex align-items-center justify-content-between">
                                <label class="form-label">Doctor</label>
                                <a href="javascript:void(0);" wire:click="$set('doctorFilter', 'all')"
                                    class="link-primary mb-1">Reset</a>
                            </div>
                            <select class="form-select" wire:model="doctorFilter">
                                <option value="all">All Doctors</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $allDoctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $association): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $doctor = $association->doctor;
                                    ?>
                                    <option value="<?php echo e($doctor->id); ?>"><?php echo e($doctor->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                        </div>

                    </div>
                    <div class="filter-footer d-flex align-items-center justify-content-end border-top">
                        <a href="javascript:void(0);" class="btn btn-light btn-md me-2"
                            data-bs-toggle="dropdown">Close</a>
                        <button type="button" class="btn btn-primary btn-md" wire:click="applyFilters"
                            data-bs-toggle="dropdown">Filter</button>
                    </div>
                </div>
            </div>

            <!-- Sort Dropdown -->
            <div class="dropdown">
                <a href="javascript:void(0);"
                    class="dropdown-toggle btn bg-white btn-md d-inline-flex align-items-center fw-normal rounded border text-dark px-2 py-1 fs-14"
                    data-bs-toggle="dropdown">
                    <span class="me-1">Sort By : </span> <?php echo e(ucfirst($sortField)); ?>

                </a>
                <ul class="dropdown-menu dropdown-menu-end bg-white p-2">
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('name')">Name</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="dropdown-item rounded-1"
                            wire:click="sortBy('status')">Status</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <!-- End Filter -->

    <!-- Start Table -->
    <div class="table-responsive">
        <table class="table datatable table-nowrap">
            <thead class="">
                <tr>
                    <th wire:click="sortBy('name')" style="cursor: pointer;">
                        Name
                        <?php echo $sortField === 'name' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : ''; ?>

                    </th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Assigned Doctor</th>
                    <th wire:click="sortBy('status')" style="cursor: pointer;">
                        Status
                        <?php echo $sortField === 'status' ? ($sortDirection === 'asc' ? '&#8593;' : '&#8595;') : ''; ?>

                    </th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $staffAssociations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $association): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $user = $association->staff;
                        $doctor = $association->doctor;
                        $profileImage = $user->staff?->profile_image;
                    ?>
                    <tr>
                        <td>
                            <a href="<?php echo e(route('doctor.staff.view', $user)); ?>" class="text-dark fw-semibold">
                                <?php if (isset($component)) { $__componentOriginal61678554f89acd69b53e2505281ebce7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal61678554f89acd69b53e2505281ebce7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user.avatar-name','data' => ['name' => $user->name,'profileImage' => $profileImage]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user.avatar-name'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($user->name),'profileImage' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($profileImage)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal61678554f89acd69b53e2505281ebce7)): ?>
<?php $attributes = $__attributesOriginal61678554f89acd69b53e2505281ebce7; ?>
<?php unset($__attributesOriginal61678554f89acd69b53e2505281ebce7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal61678554f89acd69b53e2505281ebce7)): ?>
<?php $component = $__componentOriginal61678554f89acd69b53e2505281ebce7; ?>
<?php unset($__componentOriginal61678554f89acd69b53e2505281ebce7); ?>
<?php endif; ?>
                            </a>
                        </td>
                        <td><?php echo e($user->email); ?></td>
                        <td><?php echo e($user->phone_number ?? 'N/A'); ?></td>
                        <td>
                            <!--[if BLOCK]><![endif]--><?php if($doctor): ?>
                                <?php if (isset($component)) { $__componentOriginal61678554f89acd69b53e2505281ebce7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal61678554f89acd69b53e2505281ebce7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user.avatar-name','data' => ['name' => $doctor->name,'profileImage' => $doctor->doctor->profile_image]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user.avatar-name'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($doctor->name),'profileImage' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($doctor->doctor->profile_image)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal61678554f89acd69b53e2505281ebce7)): ?>
<?php $attributes = $__attributesOriginal61678554f89acd69b53e2505281ebce7; ?>
<?php unset($__attributesOriginal61678554f89acd69b53e2505281ebce7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal61678554f89acd69b53e2505281ebce7)): ?>
<?php $component = $__componentOriginal61678554f89acd69b53e2505281ebce7; ?>
<?php unset($__componentOriginal61678554f89acd69b53e2505281ebce7); ?>
<?php endif; ?>
                            <?php else: ?>
                                Not assigned
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>
                        <td>
                            <span
                                class="badge badge-soft-<?php echo e($association->status === 'active' ? 'success' : 'danger'); ?> rounded text-<?php echo e($association->status === 'active' ? 'success' : 'danger'); ?> border border-<?php echo e($association->status === 'active' ? 'success' : 'danger'); ?>">
                                <?php echo e(ucfirst($association->status ?? 'Inactive')); ?>

                            </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <a href="javascript:void(0);"
                                    class="shadow-sm fs-14 d-inline-flex border rounded-2 p-1"
                                    data-bs-toggle="dropdown">
                                    <i class="ti ti-dots-vertical"></i>
                                </a>
                                <ul class="dropdown-menu p-2 bg-white">
                                    <li>
                                        <a href="<?php echo e(route('doctor.staff.view', $user->id)); ?>"
                                            class="dropdown-item d-flex align-items-center">
                                            <i class="ti ti-eye me-2"></i>View
                                        </a>
                                    </li>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit staff')): ?>
                                        <li>
                                            <a href="<?php echo e(route('doctor.staff.edit', ['staff'=>$user , 'doctor'=>$doctor])); ?>"
                                                class="dropdown-item d-flex align-items-center">
                                                <i class="ti ti-edit me-2"></i>Edit
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <li>
                                        <a href="javascript:void(0);" class="dropdown-item d-flex align-items-center"
                                            wire:click="toggleStatus(<?php echo e($association); ?>)">
                                            <i class="ti ti-power me-2"></i>
                                            <?php echo e($association->status === 'active' ? 'Deactivate' : 'Activate'); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);"
                                            class="dropdown-item d-flex align-items-center text-danger"
                                            wire:click="delete(<?php echo e($association->id); ?>)">
                                            <i class="ti ti-trash me-2"></i>Remove
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center">No staff members found.</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </tbody>
        </table>
    </div>
    <!-- End Table -->

    <!-- Pagination -->
    <?php if (isset($component)) { $__componentOriginal7a1de95135fea4b7a0f524148344a9f0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0 = $attributes; } ?>
<?php $component = App\View\Components\Table\Pagination::resolve(['paginator' => $staffAssociations,'position' => 'both'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('table.pagination'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Table\Pagination::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $attributes = $__attributesOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__attributesOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0)): ?>
<?php $component = $__componentOriginal7a1de95135fea4b7a0f524148344a9f0; ?>
<?php unset($__componentOriginal7a1de95135fea4b7a0f524148344a9f0); ?>
<?php endif; ?>
</div>
<?php /**PATH /var/www/predcare/resources/views/livewire/doctor/staff/staff-list.blade.php ENDPATH**/ ?>