<div>
    <div class="card">
        <div class="card-header">
            <h5>Configure Usage Rates</h5>
            <p class="mb-0 text-muted">Define pricing for various usage types in this plan</p>
        </div>

        <div class="card-body">
            <!-- Add New Rate Form -->
            <div class="border rounded p-3 mb-4">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Usage Type*</label>
                        <select wire:model="current_usage_type" wire:change="updateUnitFromUsageType" class="form-select">
                            <option value="">Select Usage Type</option>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $available_usage_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->id); ?>">
                                    <?php echo e($type->type_name); ?> (<?php echo e($type->unit_name); ?>)
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </select>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['current_usage_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Per <?php echo e($unit); ?> Rate*</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                <?php echo e($currency); ?>

                            </span>
                            <input type="number" class="form-control" wire:model="current_rate_per_unit">
                        </div>
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['current_rate_per_unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Free Units*</label>
                        <input type="number" wire:model="current_free_units" class="form-control" min="0">
                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['current_free_units'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    

                    <div class="col-md-2 d-flex align-items-end">
                        <button wire:click="addUsageRate" class="btn btn-primary w-100">
                            <i class="fas fa-plus me-1"></i> Add Rate
                        </button>
                    </div>
                </div>
            </div>

            <!-- Existing Rates Table -->
            <!--[if BLOCK]><![endif]--><?php if(count($usage_rates) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Usage Type</th>
                                <th>Per Unit Rate</th>
                                <th>Free Units</th>
                                
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $usage_rates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $type = $available_usage_types->firstWhere('id', $rate['usage_type_id']);
                                ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($type->type_name ?? 'N/A'); ?></strong>
                                        <div class="small text-muted"><?php echo e($type->unit_name ?? ''); ?></div>
                                    </td>
                                    <td><?php echo e(number_format($rate['rate_per_unit'], 2)); ?> <?php echo e($currency); ?> Per <?php echo e($type->unit_name); ?></td>
                                    <td><?php echo e(number_format($rate['free_units'])); ?> <?php echo e($type->unit_name); ?></td>
                                    
                                    <td class="text-center">
                                        <button wire:click="removeUsageRate(<?php echo e($index); ?>)"
                                            class="btn btn-sm btn-outline-danger" title="Remove">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i> No usage rates configured yet.
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <div class="mt-4 d-flex justify-content-between">
        <button type="button" wire:click="previous" class="btn btn-secondary">Previous</button>
        <button type="button" wire:click="next" class="btn btn-primary">Next: Review</button>
    </div>
</div>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/subscription-plan-wizard/step4-usage-rates.blade.php ENDPATH**/ ?>