<!-- row start -->
<div class="row justify-content-center">
    <div class="col-lg-10">
        <!-- page header start -->
        <div class="mb-4">
            <h6 class="fw-bold mb-0 d-flex align-items-center">
                <a href="<?php echo e(route('admin.doctor-management')); ?>" class="text-dark">
                    <i class="ti ti-chevron-left me-1"></i><?php echo e($editId ? 'Edit Doctor' : 'Add New Doctor'); ?>

                </a>
            </h6>
        </div>
        <!-- page header end -->

        <!-- card start -->
        <div class="card">
            <div class="card-body pb-0">
                <div id="doctor-form" class="form">
                    <!-- Flash Messages -->
                    <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('message')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <?php if(session()->has('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <h6 class="fw-bold mb-3">Basic Information</h6>

                    <div class="row">
                        <!-- Profile Image -->
                        <div class="col-lg-12">
                            <div class="mb-3 d-flex align-items-center">
                                <label class="form-label mb-0 fw-medium">Profile Image</label>
                                <div
                                    class="drag-upload-btn avatar avatar-xxl rounded-circle bg-light text-muted position-relative overflow-hidden z-1 mb-2 ms-4 p-0">

                                    <?php
                                        $imageUrl = $this->getProfileImageUrl();
                                    ?>

                                    <!--[if BLOCK]><![endif]--><?php if($imageUrl): ?>
                                        <!-- Show current image -->
                                        <img src="<?php echo e($imageUrl); ?>" alt="Profile" class="w-100 h-100"
                                            style="object-fit: cover;">
                                        <!-- Remove button -->
                                        <div class="position-absolute top-0 end-0 m-1">
                                            <button type="button" wire:click="removeProfileImage"
                                                class="btn btn-danger btn-sm rounded-circle p-1"
                                                style="width: 24px; height: 24px; z-index: 10;">
                                                <i class="ti ti-x fs-12"></i>
                                            </button>
                                        </div>
                                    <?php else: ?>
                                        <!-- Show placeholder when no image -->
                                        <i class="ti ti-user-plus fs-16"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                    <!-- File input -->
                                    <input type="file" wire:model="profile_image"
                                        class="form-control image-sign position-absolute top-0 start-0 w-100 h-100 opacity-0"
                                        accept="image/*" style="cursor: pointer;">

                                    <!-- Camera icon overlay -->
                                    <div class="position-absolute bottom-0 end-0 w-100 h-25 bg-dark d-flex align-items-center justify-content-center"
                                        style="z-index: 1;">
                                        <span class="text-white d-flex align-items-center justify-content-center">
                                            <i class="ti ti-photo fs-14"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <!-- Loading indicator -->
                            <div wire:loading wire:target="profile_image" class="text-primary">
                                <small><i class="spinner-border spinner-border-sm me-1"></i>Uploading image...</small>
                            </div>

                            <!-- Error display -->
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['profile_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Name -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label mb-1 fw-medium">Full Name<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="name" wire:model="name" placeholder="Enter doctor's full name">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Email -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="email" class="form-label mb-1 fw-medium">Email<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="email" wire:model="email" placeholder="doctor@example.com">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Password Fields -->
                        <!--[if BLOCK]><![endif]--><?php if(!$editId): ?>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label mb-1 fw-medium">Password<span
                                            class="text-danger ms-1">*</span></label>
                                    <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        id="password" wire:model="password" placeholder="Enter secure password">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password_confirmation" class="form-label mb-1 fw-medium">Confirm
                                        Password<span class="text-danger ms-1">*</span></label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        wire:model="password_confirmation" placeholder="Confirm password">
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password" class="form-label mb-1 fw-medium">New Password</label>
                                    <input type="password"
                                        class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="password"
                                        wire:model="password" placeholder="Enter new password">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="password_confirmation" class="form-label mb-1 fw-medium">Confirm New
                                        Password</label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                        wire:model="password_confirmation" placeholder="Confirm new password">
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Status -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Status<span
                                        class="text-danger ms-1">*</span></label>
                                <select class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="status">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Professional Information Section -->
                        <h6 class="fw-bold mb-3 border-top pt-3">Professional Information</h6>

                        <!-- Specialization -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="specialization" class="form-label mb-1 fw-medium">Specialization<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="text"
                                    class="form-control <?php $__errorArgs = ['specialization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="specialization" wire:model="specialization"
                                    placeholder="e.g., Cardiology, Pediatrics">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['specialization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- License Number -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="license_number" class="form-label mb-1 fw-medium">License Number<span
                                        class="text-danger ms-1">*</span></label>
                                <input type="text"
                                    class="form-control <?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="license_number" wire:model="license_number"
                                    placeholder="Medical license number">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['license_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Qualifications -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="qualifications" class="form-label mb-1 fw-medium">Qualifications</label>
                                <input type="text"
                                    class="form-control <?php $__errorArgs = ['qualifications'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="qualifications" wire:model="qualifications"
                                    placeholder="e.g., MD, MBBS, PhD">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['qualifications'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Experience Years -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="experience_years" class="form-label mb-1 fw-medium">Years of
                                    Experience</label>
                                <input type="number"
                                    class="form-control <?php $__errorArgs = ['experience_years'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    id="experience_years" wire:model="experience_years" min="0"
                                    placeholder="0">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['experience_years'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Bio -->
                        <div class="col-12">
                            <div class="mb-3">
                                <label for="bio" class="form-label mb-1 fw-medium">Bio</label>
                                <textarea class="form-control <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="bio" rows="3" wire:model="bio"
                                    placeholder="Brief description about the doctor's background and expertise"></textarea>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>

                        <!-- Clinic Assignments Section -->
                        <h6 class="fw-bold mb-3 border-top pt-3">Clinic Assignments</h6>

                        <div class="col-12">
                            <!--[if BLOCK]><![endif]--><?php if($has_primary_clinic): ?>
                                <div class="alert alert-info mb-3">
                                    <i class="fas fa-info-circle me-2"></i>
                                    This doctor has a primary clinic
                                    (<strong><?php echo e($this->getPrimaryClinicName()); ?></strong>).
                                    The primary clinic assignment cannot be changed but you can add or remove other
                                    clinics.
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!-- Clinic Search -->
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Search Clinics</label>
                                <div class="input-icon-end position-relative">
                                    <input type="text" class="form-control" placeholder="Search clinics..."
                                        wire:model.live.debounce.300ms="clinicSearch">
                                    <span class="input-icon-addon">
                                        <i class="ti ti-search"></i>
                                    </span>
                                </div>
                            </div>

                            <!-- Clinics List -->
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Available Clinics</label>
                                <div class="clinics-list border rounded p-3"
                                    style="max-height: 250px; overflow-y: auto;">
                                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $this->filteredClinics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php
                                            $isPrimary = $has_primary_clinic && $clinic->id === $primary_clinic_id;
                                            $isChecked = in_array($clinic->id, $selected_clinics);
                                        ?>

                                        <div class="form-check py-2 <?php echo e($isPrimary ? 'bg-light rounded px-2' : ''); ?>">
                                            <input class="form-check-input" type="checkbox"
                                                id="clinic_<?php echo e($clinic->id); ?>" wire:model.live="selected_clinics"
                                                value="<?php echo e($clinic->id); ?>"
                                                <?php echo e($isPrimary ? 'checked disabled' : ''); ?>>

                                            <label
                                                class="form-check-label d-flex justify-content-between align-items-center"
                                                for="clinic_<?php echo e($clinic->id); ?>">
                                                <span>
                                                    <?php echo e($clinic->name); ?>

                                                    <!--[if BLOCK]><![endif]--><?php if($isPrimary): ?>
                                                        <span class="badge bg-primary ms-2">Primary</span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </span>

                                                <!--[if BLOCK]><![endif]--><?php if($clinic->address): ?>
                                                    <small class="text-muted"><?php echo e($clinic->address); ?></small>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="text-center text-muted py-3">
                                            <i class="fas fa-search mb-2"></i>
                                            <p class="mb-0">No clinics found</p>
                                            <!--[if BLOCK]><![endif]--><?php if(!empty($clinicSearch)): ?>
                                                <small>Try adjusting your search terms</small>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selected_clinics'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!-- Selected Clinics -->
                            <div class="mb-3">
                                <label class="form-label mb-1 fw-medium">Selected Clinics</label>
                                <div class="p-2 rounded bg-light">
                                    <!--[if BLOCK]><![endif]--><?php if(count($this->selectedClinicsNames) > 0): ?>
                                        <div class="d-flex flex-wrap gap-2">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->selectedClinicsNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clinicName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="badge bg-secondary"><?php echo e($clinicName); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">No clinics selected</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- card end -->

        <div class="d-flex align-items-center justify-content-end">
            <button type="button" wire:click="resetForm" class="btn btn-light me-2">
                <i class="ti ti-refresh"></i> Reset Form
            </button>
            <button type="submit" wire:click="<?php echo e($editId ? 'updateDoctor' : 'createDoctor'); ?>"
                wire:loading.attr="disabled" class="btn btn-primary">
                <span wire:loading.remove>
                    <!--[if BLOCK]><![endif]--><?php if($editId): ?>
                        <i class="ti ti-device-floppy"></i> Update Doctor
                    <?php else: ?>
                        <i class="ti ti-plus"></i> Add New Doctor
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </span>
                <span wire:loading>
                    <i class="ti ti-loader fa-spin"></i> Processing...
                </span>
            </button>
        </div>
    </div>
</div>


<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('scroll-to-form', () => {
                document.getElementById('doctor-form').scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /var/www/predcare/resources/views/livewire/admin/doctor/doctor-form.blade.php ENDPATH**/ ?>